package com.ejianc.business.proequipmentcorprent.rent.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentalSumVo;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping
public class RentContractApiController implements Serializable {

    @Autowired
    private IRentContractService rentContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @ApiOperation("根据定标参照id查询对应的合同")
    @RequestMapping(value = "/api/rentContract/queryContractByTargetResultId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList) {
        logger.info("根据定标结果id查询合同，查询参数：{}", JSONObject.toJSONString(targetResultIdList));
        List<SignContractVo> list = rentContractService.queryContractByTargetResultId(targetResultIdList);
        logger.info("根据定标结果id查询合同，查询结果：{}", JSONObject.toJSONString(list));
        return CommonResponse.success("查询成功", list);
    }
}
