package com.ejianc.business.proequipmentcorpout.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderDetailEntity;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.mapper.OutOrderDetailMapper;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.CommonConstant;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁订单明细
 * 
 * @author generator
 * 
 */
@Service("outOrderDetailService")
public class OutOrderDetailServiceImpl extends BaseServiceImpl<OutOrderDetailMapper, OutOrderDetailEntity> implements IOutOrderDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutOrderService outOrderService;
    @Autowired
    private IRentReceiptsApi receiptsApi;


    @Override
    public Boolean deleteOrderDetailByOrderId(Long orderId) {
        return baseMapper.deleteOrderDetailByOrderId(orderId);
    }

    @Override
    public List<OutOrderDetailVO> geOutOrderDetail(QueryWrapper queryWrapper, Long contractId) {
        if(null==contractId){
            return new ArrayList<>();
        }
        return baseMapper.geOutOrderDetail(queryWrapper,contractId);
    }
    @Override
    public List<OutOrderVO> queryOrderNumTotal(List<Long> orderIdList) {
        if(CollectionUtils.isEmpty(orderIdList)){
            return new ArrayList<>();
        }
        return baseMapper.queryOrderNumTotal(orderIdList);
    }

    @Override
    public void saveOrUpdateNum(List<OutStoreDetailEntity> detailVOS) {
        List<Long> addIdList = new ArrayList<>();
        List<Long> delIdList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailVOS)){
            for (OutStoreDetailEntity detailVO : detailVOS) {
                if(detailVO.getSourceType()!=null&&detailVO.getSourceType()==0) {
                    if("del".equals(detailVO.getRowState())){
                        delIdList.add(detailVO.getSourceDetailId());
                    }else if(null==detailVO.getId()){
                        addIdList.add(detailVO.getSourceDetailId());
                    }
                }
            }
        }
        this.addOrderDetail(addIdList);
        this.delOrderDetail(delIdList);
    }

    @Override
    public void deleteNum(List<OutStoreDetailEntity> detailVOS) {
        List<Long> delIdList = new ArrayList<>();
        List<OutOrderDetailEntity> orderDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailVOS)){
            for (OutStoreDetailEntity detailVO : detailVOS) {
                if(detailVO.getSourceType()!=null&&detailVO.getSourceType()==0){
                    delIdList.add(detailVO.getSourceDetailId());
                }
            }
        }
        this.delOrderDetail(delIdList);
    }
//新增回显
    public void addOrderDetail(List<Long> addIdList) {
        if(CollectionUtils.isNotEmpty(addIdList)){
            LambdaQueryWrapper<OutOrderDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(OutOrderDetailEntity::getId, addIdList);
            List<OutOrderDetailEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (OutOrderDetailEntity outOrderDetailEntity : list) {
                    outOrderDetailEntity.setDeliverNumsSum(ComputeUtil.safeAdd(outOrderDetailEntity.getDeliverNumsSum(),new BigDecimal("1")));
                    outOrderDetailEntity.setCheckNumsSum(ComputeUtil.safeAdd(outOrderDetailEntity.getCheckNumsSum(),new BigDecimal("1")));
                    outOrderDetailEntity.setNotDeliveredNumsSum(ComputeUtil.safeSub(outOrderDetailEntity.getNotDeliveredNumsSum(),new BigDecimal("1")));
                }
                super.saveOrUpdateBatch(list);
                this.updateOrderDeliverState(list,true);
            }
        }
    }


    //    //删除回显
    public void delOrderDetail(List<Long> delIdList) {
        if(CollectionUtils.isNotEmpty(delIdList)){
            LambdaQueryWrapper<OutOrderDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(OutOrderDetailEntity::getId, delIdList);
            List<OutOrderDetailEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (OutOrderDetailEntity outOrderDetailEntity : list) {
                    outOrderDetailEntity.setDeliverNumsSum(ComputeUtil.safeSub(outOrderDetailEntity.getDeliverNumsSum(),new BigDecimal("1")));
                    outOrderDetailEntity.setCheckNumsSum(ComputeUtil.safeSub(outOrderDetailEntity.getCheckNumsSum(),new BigDecimal("1")));
                    outOrderDetailEntity.setNotDeliveredNumsSum(ComputeUtil.safeAdd(outOrderDetailEntity.getNotDeliveredNumsSum(),new BigDecimal("1")));
                }
                super.saveOrUpdateBatch(list);
                this.updateOrderDeliverState(list,false);
            }
        }
    }



        //修改订单发货状态
    public void updateOrderDeliverState(List<OutOrderDetailEntity> orderDetailList,Boolean type) {
        logger.info((type ? "占用" : "释放") + "要修改的订单明细数据集合:{}", JSONObject.toJSONString(orderDetailList));
        List<OutOrderVO> orderDeliverState = new ArrayList<>();//要修改的订单列表
        if (CollectionUtils.isNotEmpty(orderDetailList)) {
            Map<Long, List<OutOrderDetailEntity>> collect = orderDetailList.stream().collect(Collectors.groupingBy(item -> item.getOrderId()));
            if (MapUtils.isNotEmpty(collect)) {
                Set<Long> longs = collect.keySet();
                List<OutOrderVO> outOrderNumList = this.queryOrderNumTotal(new ArrayList<>(longs));
                if (CollectionUtils.isNotEmpty(outOrderNumList)) {
                    for (OutOrderVO orderVO : outOrderNumList) {
                        BigDecimal receiveNumsSumTotal = orderVO.getReceiveNumsSumTotal();
                        BigDecimal notDeliveredNumsSumTotal = orderVO.getNotDeliveredNumsSumTotal();
                        if (notDeliveredNumsSumTotal.compareTo(BigDecimal.ZERO) <= 0) {//全部
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_ALL);
                        } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) > 0) {//部分
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_PART);
                        } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) == 0) {//未发货
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
                        } else {
                            logger.info("订单id:{},接收数量累计：{}，未发货数量累计：{}", orderVO.getId(), receiveNumsSumTotal, notDeliveredNumsSumTotal);
                            throw new BusinessException("订单发货状态回显失败,计算发生错误！");
                        }
                        List<OutOrderDetailEntity> orderDetailEntities1 = collect.get(orderVO.getId());
                        orderVO.setOutOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutOrderDetailVO.class));
                        orderVO.setRentOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutOrderDetailVO.class));
                        orderDeliverState.add(orderVO);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orderDeliverState)) {
            logger.info((type ? "占用" : "释放") + "要修改发货状态的订单数据集合:{}", JSONObject.toJSONString(orderDeliverState));
            JSONArray jsonArray = JSONArray.parseArray(JSONObject.toJSONString(orderDeliverState));
            outOrderService.updateBatchById(BeanMapper.mapList(orderDeliverState,OutOrderEntity.class));
            receiptsApi.orderChangeStatus(jsonArray);
        }
    }
}
