package com.ejianc.business.proequipmentcorpout.outLedger.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 租出设备台账
 *
 * @author generator
 *
 */
@TableName("ejc_outequipmentcorp_rent_parameter")
public class OutRentParameterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 单据编码
     */
    @TableField("code")
    private String code;
    /**
     * 设备名称
     */
    @TableField("name")
    private String name;
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField("bill_state")
    private Integer billState;
    /**
     * 设备出厂编号
     */
    @TableField("factory_code")
    private String factoryCode;
    /**
     * 设备类别id
     */
    @TableField("category_id")
    private Long categoryId;
    /**
     * 设备类别名称
     */
    @TableField("category_name")
    private String categoryName;

    /**
     * 设备分类编码
     */
    @TableField(value = "category_code")
    private String categoryCode;
    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;
    /**
     * 计量单位id
     */
    @TableField("unit_id")
    private Long unitId;
    /**
     * 单位
     */
    @TableField("unit_name")
    private String unitName;
    /**
     * 租赁数量
     */
    @TableField("rent_num")
    private Integer rentNum;

    /**
     * 生产厂家
     */
    @TableField("production_manufactor")
    private String productionManufactor;
    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    /**
     * 设备编号
     */
    @TableField("equipment_code")
    private String equipmentCode;
    /**
     * 设备id
     */
    @TableField("equipment_id")
    private Long equipmentId;
    /**
     * 数量/选择数量/送货数量
     */
    @TableField("num")
    private Integer num;
    /**
     * 验收单Id
     */
    @TableField("acceptance_id")
    private Long acceptanceId;
    /**
     * 验收单子表Id
     */
    @TableField("acceptance_detail_id")
    private Long acceptanceDetailId;
    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    @TableField("equipment_state")
    private Integer equipmentState;
    /**
     * 设备状态名称:1--进场,2--启用,3--停用,4--退场
     */
    @TableField("equipment_state_name")
    private String equipmentStateName;
    /**
     * 设备费用
     */
    @TableField("equipment_cost")
    private BigDecimal equipmentCost;
    /**
     * 验收日期
     */
    @TableField("acceptance_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate;
    /**
     * 启用日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    /**
     * 停用日期
     */
    @TableField("stop_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopDate;

    /**
     * 设备名称
     */
    @TableField("equipment_name")
    private String equipmentName;
    /**
     * 有税单价
     */
    @TableField("price")
    private BigDecimal price;
    /**
     * 无税单价
     */
    @TableField("not_tax_price")
    private BigDecimal notTaxPrice;
    /**
     * 工程量数量
     */
    @TableField("quantities_num")
    private BigDecimal quantitiesNum;
    /**
     * 来源id
     */
    @TableField("source_id")
    private Long sourceId;
    /**
     * 来源单据类型：
     *  1-设备公司采购 设备验收（直入直出）
     *  2-设备公司租入 设备验收-送货单（直入直出）
     *  3-设备公司租入 设备验收-自制（直入直出）
     *  4-设备公司租出 设备租出（自购）
     *  5-设备公司租出 设备租出（租赁）
     */
    @TableField(value = "source_bill_type")
    private String sourceBillType;

    /**
     * 来源单据编码
     */
    @TableField(value = "source_bill_code")
    private String sourceBillCode;

    /**
     * 是否已计算租金（0-否，1-是）
     */
    @TableField("settlement_flag")
    private Integer settlementFlag;
    /**
     * 合同id
     */
    @TableField("contract_id")
    private Long contractId;
    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;
    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;
    /**
     * 合同穿透地址
     */
    @TableField("contract_link_url")
    private String contractLinkUrl;

    /**
     * 租赁方/合同甲方id
     */
    @TableField("first_party_id")
    private Long firstPartyId;
    /**
     * 租赁方/合同甲方名称
     */
    @TableField("first_party_name")
    private String firstPartyName;
    /**
     * 工程id
     */
    @TableField("engineering_id")
    private Long engineeringId;
    /**
     * 工程名称
     */
    @TableField("engineering_name")
    private String engineeringName;
    /**
     * 供应商id
     */
    @TableField("supplier_id")
    private Long supplierId;
    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;
    /**
     * 项目id
     */
    @TableField("project_id")
    private Long projectId;
    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;
    /**
     * 项目编号
     */
    @TableField("project_code")
    private String projectCode;
    /**
     * 组织id
     */
    @TableField("org_id")
    private Long orgId;
    /**
     * 项目部名称
     */
    @TableField("org_name")
    private String orgName;
    /**
     * 项目部上级组织Id
     */
    @TableField("parent_org_id")
    private Long parentOrgId;
    /**
     * 项目部上级组织名称
     */
    @TableField("parent_org_name")
    private String parentOrgName;
    /**
     * 项目部上级组织编码
     */
    @TableField("parent_org_code")
    private String parentOrgCode;

    /**
     * 累计工作量
     */
    @TableField("cumulative_workload")
    private BigDecimal cumulativeWorkload;
    /**
     * 合同税率
     */
    @TableField("contract_taxR_rate")
    private BigDecimal contractTaxRate;

    /**
     * 计租日期
     */
    @TableField("meter_rent_date")
    private Date meterRentDate;
    /**
     * 出库日期
     */
    @TableField("outstore_date")
    private Date outstoreDate;
    /**
     * 止租日期
     */
    @TableField("rent_end_date")
    private Date rentEndDate;
    /**
     * 进厂日期
     */
    @TableField("into_date")
    private Date intoDate;
    /**
     * 退场日期
     */
    @TableField("out_date")
    private Date outDate;

    /**
     * 操作日期
     */
    @TableField(value = "operation_date")
    private Date operationDate;

    /**
     * 使用状态1-闲置,2-再用
     */
    @TableField("use_type")
    private Integer useType;
    /**
     * 计租方式 day--日租，month--月租,engineering--工程量,other--其它费用
     */
    @TableField("meter_rent_type")
    private String meterRentType;
    /**
     * 租赁来源,0-自购,1-租赁
     */
    @TableField("source_type")
    private Integer sourceType;
    /**
     * 租赁方式：0-外租，1-内租
     */
    @TableField("rent_harbor_type")
    private Integer rentHarborType;
    /**
     * 租赁方式名称：0-外租，1-内租
     */
    @TableField("rent_harbor_type_name")
    private String rentHarborTypeName;

    /**
     * 使用单位id
     */
    @TableField("use_org_id")
    private Long useOrgId;
    /**
     * 使用单位名称
     */
    @TableField("use_org_name")
    private String useOrgName;
    /**
     * 使用单位编码
     */
    @TableField("use_org_code")
    private String useOrgCode;
    /**
     * 使用项目Id
     */
    @TableField("use_project_id")
    private Long useProjectId;
    /**
     * 使用项目名称
     */
    @TableField("use_project_name")
    private String useProjectName;
    /**
     * 使用项目编码
     */
    @TableField("use_project_code")
    private String useProjectCode;

    /**
     * 租出单位主键
     */
    @TableField("out_org_id")
    private Long outOrgId;
    /**
     * 租出单位名称
     */
    @TableField("out_org_name")
    private String outOrgName;
    /**
     * 租出单位编码
     */
    @TableField("out_org_code")
    private String outOrgCode;

    /**
     * 出库单位主键
     */
    @TableField("out_store_org_id")
    private Long outStoreOrgId;
    /**
     * 出库单位名称
     */
    @TableField("out_store_org_name")
    private String outStoreOrgName;
    /**
     * 出库单位名称
     */
    @TableField("out_store_org_code")
    private String outStoreOrgCode;

    /**
     * 关联设备台账Id
     */
    @TableField(value = "equip_ledger_id")
    private Long equipLedgerId;

    /**
     * 关联台账设备出厂编码
     */
    @TableField(value = "equip_ledger_factory_code")
    private String equipLedgerFactoryCode;

    /**
     * 设备台账明细
     */
    @TableField(exist = false)
    @SubEntity(serviceName="outRentParameterDetailService",pidName = "parameterId")
    private List<OutRentParameterDetailEntity> rentParameterDetailList = new ArrayList<>();

    public Long getEquipLedgerId() {
        return equipLedgerId;
    }

    public void setEquipLedgerId(Long equipLedgerId) {
        this.equipLedgerId = equipLedgerId;
    }

    public String getEquipLedgerFactoryCode() {
        return equipLedgerFactoryCode;
    }

    public void setEquipLedgerFactoryCode(String equipLedgerFactoryCode) {
        this.equipLedgerFactoryCode = equipLedgerFactoryCode;
    }

    public Long getAcceptanceDetailId() {
        return acceptanceDetailId;
    }

    public void setAcceptanceDetailId(Long acceptanceDetailId) {
        this.acceptanceDetailId = acceptanceDetailId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public Long getUseOrgId() {
        return useOrgId;
    }

    public void setUseOrgId(Long useOrgId) {
        this.useOrgId = useOrgId;
    }

    public String getUseOrgName() {
        return useOrgName;
    }

    public void setUseOrgName(String useOrgName) {
        this.useOrgName = useOrgName;
    }

    public String getUseOrgCode() {
        return useOrgCode;
    }

    public void setUseOrgCode(String useOrgCode) {
        this.useOrgCode = useOrgCode;
    }

    public Long getUseProjectId() {
        return useProjectId;
    }

    public void setUseProjectId(Long useProjectId) {
        this.useProjectId = useProjectId;
    }

    public String getUseProjectName() {
        return useProjectName;
    }

    public void setUseProjectName(String useProjectName) {
        this.useProjectName = useProjectName;
    }

    public String getUseProjectCode() {
        return useProjectCode;
    }

    public void setUseProjectCode(String useProjectCode) {
        this.useProjectCode = useProjectCode;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public BigDecimal getCumulativeWorkload() {
        return cumulativeWorkload;
    }

    public void setCumulativeWorkload(BigDecimal cumulativeWorkload) {
        this.cumulativeWorkload = cumulativeWorkload;
    }

    public String getEquipmentStateName() {
        return equipmentStateName;
    }

    public void setEquipmentStateName(String equipmentStateName) {
        this.equipmentStateName = equipmentStateName;
    }

    public String getRentHarborTypeName() {
        return rentHarborTypeName;
    }

    public void setRentHarborTypeName(String rentHarborTypeName) {
        this.rentHarborTypeName = rentHarborTypeName;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 设备名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设备名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编号
     */
    public String getFactoryCode() {
        return factoryCode;
    }

    /**
     * 设备出厂编号
     */
    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
    /**
     * 设备类别id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 设备类别id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 设备类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设备类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 租赁数量
     */
    public Integer getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 生产厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生产厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 设备编号
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编号
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 数量/选择数量/送货数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 数量/选择数量/送货数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }
    /**
     * 验收单id
     */
    public Long getAcceptanceId() {
        return acceptanceId;
    }

    /**
     * 验收单id
     */
    public void setAcceptanceId(Long acceptanceId) {
        this.acceptanceId = acceptanceId;
    }
    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public Integer getEquipmentState() {
        return equipmentState;
    }

    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    /**
     * 设备费用
     */
    public BigDecimal getEquipmentCost() {
        return equipmentCost;
    }

    /**
     * 设备费用
     */
    public void setEquipmentCost(BigDecimal equipmentCost) {
        this.equipmentCost = equipmentCost;
    }
    /**
     * 验收日期
     */
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    /**
     * 验收日期
     */
    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    /**
     * 启动日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 启动日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 停用日期
     */
    public Date getStopDate() {
        return stopDate;
    }

    /**
     * 停用日期
     */
    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    /**
     * 退场日期
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 退场日期
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 有税单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 有税单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 无税单价
     */
    public BigDecimal getNotTaxPrice() {
        return notTaxPrice;
    }

    /**
     * 无税单价
     */
    public void setNotTaxPrice(BigDecimal notTaxPrice) {
        this.notTaxPrice = notTaxPrice;
    }
    /**
     * 计租日期
     */
    public Date getMeterRentDate() {
        return meterRentDate;
    }

    /**
     * 计租日期
     */
    public void setMeterRentDate(Date meterRentDate) {
        this.meterRentDate = meterRentDate;
    }
    /**
     * 工程量数量
     */
    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    /**
     * 工程量数量
     */
    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 是否已计算租金（0-否，1-是）
     */
    public Integer getSettlementFlag() {
        return settlementFlag;
    }

    /**
     * 是否已计算租金（0-否，1-是）
     */
    public void setSettlementFlag(Integer settlementFlag) {
        this.settlementFlag = settlementFlag;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 工程id
     */
    public Long getEngineeringId() {
        return engineeringId;
    }

    /**
     * 工程id
     */
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Date getOutstoreDate() {
        return outstoreDate;
    }

    public void setOutstoreDate(Date outstoreDate) {
        this.outstoreDate = outstoreDate;
    }

    public Date getRentEndDate() {
        return rentEndDate;
    }

    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }

    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }

    public String getMeterRentType() {
        return meterRentType;
    }

    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOutStoreOrgId() {
        return outStoreOrgId;
    }

    public void setOutStoreOrgId(Long outStoreOrgId) {
        this.outStoreOrgId = outStoreOrgId;
    }

    public String getOutStoreOrgName() {
        return outStoreOrgName;
    }

    public void setOutStoreOrgName(String outStoreOrgName) {
        this.outStoreOrgName = outStoreOrgName;
    }

    public String getSourceBillType() {
        return sourceBillType;
    }

    public void setSourceBillType(String sourceBillType) {
        this.sourceBillType = sourceBillType;
    }

    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    public String getOutStoreOrgCode() {
        return outStoreOrgCode;
    }

    public void setOutStoreOrgCode(String outStoreOrgCode) {
        this.outStoreOrgCode = outStoreOrgCode;
    }

    public List<OutRentParameterDetailEntity> getRentParameterDetailList() {
        return rentParameterDetailList;
    }

    public void setRentParameterDetailList(List<OutRentParameterDetailEntity> rentParameterDetailList) {
        this.rentParameterDetailList = rentParameterDetailList;
    }


    public Date getOperationDate() {
        return operationDate;
    }

    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }
}
