package com.ejianc.business.proequipmentcorpout.rental.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalDayEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalMonthEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("outRentRental") 
public class OutRentRentalBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOutRentRentalService service;
	@Autowired
	private ICostDetailApi costDetailApi;
	/** 设备台账 */
	@Autowired
	private IOutRentParameterService parameterService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRentRentalEntity entity = service.selectById(billId);
		logger.info("推送成本---");
//		service.costPush(entity);
		if ("1".equals(entity.getRentalType())) {
			// 5. 处理设备台账
			List<OutRentParameterVO> rentParameterList = parameterService.getRentParameterByContractId(entity.getContractId(),
							entity.getId(), entity.getRentalDate());
			List<OutRentParameterEntity> parameterEntityList = new ArrayList<>();
			for (OutRentParameterVO rentParameterVO : rentParameterList) {
				OutRentParameterEntity rentParameterEntity = BeanMapper.map(rentParameterVO, OutRentParameterEntity.class);
				rentParameterEntity.setOperationDate(entity.getRentalDate());
				// 处理子表
				List<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<>();
				OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.租金计算.getCode());
				detailEntity.setSourceId(entity.getId());
				detailEntity.setOperationDate(entity.getRentalDate());
				detailEntity.setEquipmentState(rentParameterEntity.getEquipmentState());
				detailEntity.setParameterId(rentParameterEntity.getId());
				parameterDetailList.add(detailEntity);

				rentParameterEntity.setRentParameterDetailList(parameterDetailList);
				parameterEntityList.add(rentParameterEntity);
			}
			parameterService.changeParameter(parameterEntityList, RentParameterTypeEnum.租金计算.getCode());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }
		OutRentRentalEntity entity = service.selectById(billId);
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-Id---{}",entity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(entity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<OutRentRentalEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(OutRentRentalEntity::getId, entity.getId());
		updateWrapper.set(OutRentRentalEntity::getRelationFlag, "0");//(1:是，0：否)
		service.update(updateWrapper);

		// 处理自动租金计算数据
		if ("1".equals(entity.getRentalType())) {
			List<Long> parameterIdList = new ArrayList<>();
			List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList(); // 租金计算日租明细
			List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList(); // 租金计算月租明细
			// 租金计算工程量租明细
			List<OutRentRentalQuantitiesEntity> qList = entity.getRentRentalQuantitiesList();
			if (CollectionUtils.isNotEmpty(dayList)) {
				List<Long> sourceIdList = dayList.stream().map(OutRentRentalDayEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}
			if (CollectionUtils.isNotEmpty(monthList)) {
				List<Long> sourceIdList = monthList.stream().map(OutRentRentalMonthEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}
			if (CollectionUtils.isNotEmpty(qList)) {
				List<Long> sourceIdList = qList.stream().map(OutRentRentalQuantitiesEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}
			parameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.租金计算.getCode(), entity.getId());
		}
		return CommonResponse.success();
	}

}
