package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceSubVO;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractDetailedService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("purchaseAcceptance") 
public class PurchaseAcceptanceBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IPurchaseAcceptanceService service;
	@Autowired
	private IPurchaseContractService contractService;
	@Autowired
	private IPurchaseContractDetailedService equipmentDetailedService;
	@Autowired
	private IPurchaseAcceptanceSubService subService;
	@Autowired
	private IAssetService assetService;
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IOutRentContractService outRentContractService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseAcceptanceEntity acc = service.selectById(billId);

		OutRentContractEntity contract = null;
		if(null != acc.getOutRentContractId()) {
			contract = outRentContractService.selectById(acc.getOutRentContractId());
		}

		//TODO
		//这个地方写推送 固定资产 和其他的业务区分开
		QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("purchase_acceptance_id",billId);
		List<AssetEntity> list = assetService.list(queryWrapper);
		AssetVO pushAssetVO = null;
		if (CollectionUtils.isEmpty(list)){
			pushAssetVO = assetService.pushAsset(billId, contract);
		}

		PurchaseAcceptanceVO assetVO = BeanMapper.map(acc, PurchaseAcceptanceVO.class);
		PurchaseAcceptanceSubVO subVo = assetVO.getPurchaseAcceptanceSubList().get(0);

		//如果是设备验收直入直出，则生成出库台账数据
		if(acc.getAcceptanceStandardSectionFlag() == 0 && acc.getAcceptanceType() == 0) {
			OutRentParameterVO pushParamVO = null;
			if(null == contract) {
				throw new BusinessException("未查询到id-["+subVo.getContractId()+"]匹配的租出合同信息！");
			}
			try {
				pushParamVO = BeanConvertorUtil.convert(assetVO, OutRentParameterVO.class);
				logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));
			} catch (Exception e) {
				logger.error("出库单推送租出设备台账失败, 出库转换台账单异常: ", e);
				return CommonResponse.error("出库单推送租出设备台账失败！");
			}

			//设备基本信息
			pushParamVO.setCategoryId(subVo.getEquipmentTypeId());
			pushParamVO.setCategoryName(subVo.getEquipmentType());
			pushParamVO.setEquipmentId(subVo.getEquipmentId());
			pushParamVO.setEquipmentCode(subVo.getEquipmentCode());
			pushParamVO.setEquipmentName(subVo.getEquipmentName());
			pushParamVO.setUnitName(subVo.getCompany());
			pushParamVO.setProductionManufactor(subVo.getManufacturer());
			//组织项目信息
			pushParamVO.setProjectId(contract.getProjectId());
			pushParamVO.setProjectCode(contract.getProjectCode());
			pushParamVO.setProjectName(contract.getProjectName());
            //项目部
            pushParamVO.setOutOrgId(contract.getOutOrgId());
            pushParamVO.setOutOrgCode(contract.getOutOrgCode());
            pushParamVO.setOutOrgName(contract.getOutOrgName());
            pushParamVO.setParentOrgId(contract.getParentOrgId());
			pushParamVO.setParentOrgName(contract.getParentOrgName());
			pushParamVO.setParentOrgCode(contract.getParentOrgCode());
			//租赁方
			pushParamVO.setFirstPartyId(contract.getPartyId());
			pushParamVO.setFirstPartyName(contract.getPartyName());
			//单据审批状态设置为生效
			pushParamVO.setBillState(1);
			//计租日期
			pushParamVO.setMeterRentDate(assetVO.getAcceptanceDate());
			//计租方式
			pushParamVO.setMeterRentType(contract.getMeterRentType());
			pushParamVO.setRentHarborType(contract.getRentHarborType());
			//设备状态
			pushParamVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
			pushParamVO.setEquipmentStateName(OutRentEquipmentStateEnum.启用.getDescription());
            //使用状态- 在用
            pushParamVO.setUseType(2);
			//使用项目-- 从出库单的项目信息获取
			pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
			pushParamVO.setUseProjectId(pushParamVO.getProjectId());
			pushParamVO.setUseProjectName(pushParamVO.getProjectName());
			pushParamVO.setUseOrgCode(pushParamVO.getUseOrgCode());
			pushParamVO.setUseOrgName(pushParamVO.getUseOrgName());
			pushParamVO.setUseOrgId(pushParamVO.getUseOrgId());
			//租出单位
            pushParamVO.setOrgId(contract.getOrgId());
            pushParamVO.setOrgName(contract.getOrgName());
            pushParamVO.setOrgCode(contract.getOrgCode());

			//合同税率
			pushParamVO.setContractId(contract.getId());
			pushParamVO.setContractName(contract.getContractName());
			pushParamVO.setContractCode(contract.getContractCode());
			pushParamVO.setContractTaxRate(contract.getContractTax());

			//合同供应商
			pushParamVO.setSupplierId(contract.getSupplierId());
			pushParamVO.setSupplierName(contract.getSupplierName());
			pushParamVO.setSourceId(acc.getId());
			pushParamVO.setSourceBillType(RentOutParamSourceBillTypeEnum.设备验收直入直出.getCode());
			//设备出厂编码
			pushParamVO.setFactoryCode(acc.getLeaveFactoryCode());
			//设备台账Id
			pushParamVO.setEquipLedgerId(pushAssetVO.getId());
			//设备台账出厂编码
			pushParamVO.setEquipLedgerFactoryCode(acc.getLeaveFactoryCode());

			//验收单Id
			pushParamVO.setAcceptanceId(acc.getId());
			pushParamVO.setAcceptanceDetailId(subVo.getId());
			//验收日期
			pushParamVO.setAcceptanceDate(acc.getAcceptanceDate());
			//出库日期
			pushParamVO.setOutstoreDate(acc.getAcceptanceDate());

			OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
			paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
			paramDetailVO.setOperationDate(assetVO.getAcceptanceDate());
			paramDetailVO.setSourceId(subVo.getId());
			paramDetailVO.setSourceType(OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE); //出库单

			List<OutRentParameterDetailVO> paramSubList =new ArrayList<>();
			paramSubList.add(paramDetailVO);
			pushParamVO.setRentParameterDetailList(paramSubList);
			logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));

			outRentParameterService.saveOrUpdateOutRentParams(pushParamVO);
		}

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));

		if(e.getAcceptanceStandardSectionFlag() == 0) {
			PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
			logger.info("当前为设备验收单，更新合同【{}】下设备的验数量", JSONObject.toJSONString(contractEntity));
			QueryParam param = new QueryParam();
			param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
			param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
			param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
			List<PurchaseContractDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
			PurchaseContractDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
			logger.info("合同下要更新的设备---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));

			//设备验收，更新合同子表验收数量
			if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
				equipmentDetailedEntity.setAcceptanceQuantity(1);
			}else{
				equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()+1);
			}

			equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);
		}


		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//		 参数是单据类型编码字符串 根据需求是否打开下面代码
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		logger.info("333333333333333---------->: {}", JSONObject.toJSONString(contractEntity));
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<PurchaseContractDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		logger.info("4444444444444444---------->: {}", JSONObject.toJSONString(equipmentList));
		PurchaseContractDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		logger.info("555555555555555555---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(0);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()-1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);

		//如果是设备验收直入直出，则生成出库台账数据
		if(e.getAcceptanceStandardSectionFlag() == 0) {
			if(e.getAcceptanceType() == 0) {
				//查询对应租出台账
				QueryWrapper<OutRentParameterEntity> query = new QueryWrapper<>();
				query.eq("source_id", billId);
				query.eq("dr", BaseVO.DR_UNDELETE);
				OutRentParameterEntity outRentParameterEntity = outRentParameterService.getOne(query);

				List<Long> subIds = e.getPurchaseAcceptanceSubList().stream().map(PurchaseAcceptanceSubEntity::getId).collect(Collectors.toList());
				QueryWrapper<OutRentParameterDetailEntity> detailQuery = new QueryWrapper<>();
				detailQuery.in("parameter_id", outRentParameterEntity);
				detailQuery.ne("source_type", OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE);

				List<OutRentParameterDetailEntity> list = outRentParameterDetailService.list(detailQuery);
				if(CollectionUtils.isNotEmpty(list)) {
					return CommonResponse.error("弃审失败，设备已进行下游业务！");
				}

				String result = outRentParameterService.removeBySourceId(e.getId(), RentOutParamSourceBillTypeEnum.设备验收直入直出.getCode());
				if(StringUtils.isNotBlank(result)) {
					return CommonResponse.error("弃审失败，删除租出台账失败，原因："+result);
				}

			}

			//弃审删除固定资产卡片
			QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("purchase_acceptance_id",billId);
			List<AssetEntity> list = assetService.list(queryWrapper);
			AssetEntity assetEntity = list.get(0);
			if (CollectionUtils.isNotEmpty(list)){
				CommonResponse<String> response = billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
				if(!response.isSuccess()){
					return CommonResponse.error("验收生成的固定资产卡片被下游引用无法撤回！"+resp.getMsg());
				}else {
					assetService.removeById(assetEntity.getId());
				}
			}
		} else {
			QueryWrapper<AssetEntity> dbQuery = new QueryWrapper<>();
			dbQuery.eq("leave_factory_code", e.getLeaveFactoryCode());
			AssetEntity dbEntity = assetService.getOne(dbQuery);

			if(null == dbEntity) {
				throw new BusinessException("没找到出厂编码匹配的设备，操作失败！");
			}

			//减少标准节数量 设置新的标准节数量
			dbEntity.setEquipmentStandardNum((null != dbEntity.getEquipmentStandardNum() ? dbEntity.getEquipmentStandardNum() : 0) - (null != subEntity.getCurAcceptStandardSectionNum() ? subEntity.getCurAcceptStandardSectionNum() : 0));

			if(e.getAcceptanceType() == 0) {
				//验收方式为直入直出时，同时也要减少使用的数量
				dbEntity.setUseEquipmentStandardNum((null != dbEntity.getUseEquipmentStandardNum() ? dbEntity.getUseEquipmentStandardNum() : 0) - (null != subEntity.getCurAcceptStandardSectionNum() ? subEntity.getCurAcceptStandardSectionNum() : 0));
			}
			assetService.saveOrUpdate(dbEntity, false);
		}




		return CommonResponse.success("采购验收处理成功！");
	}

}
