package com.ejianc.business.proequipmentcorprent.ac.controller;

import java.io.Serializable;

import com.ejianc.business.proequipmentcorprent.ac.bean.ContractDetailEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractOtherCostEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractDetailService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractOtherCostService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractRelieveService;
import com.ejianc.business.proequipmentcorprent.ac.utils.TreeNodeBUtil;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractDetailVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractOtherCostVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractPaymentVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;

/**
 * 安拆合同主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    //安拆合同单据编码
    private final String AC_CONTRACT_Bill_CODE = "EJCBT202204000008";

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IContractRelieveService contractRelieveService;

    @Autowired
    private IContractOtherCostService otherCostService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = service.insertOrUpdate(saveorUpdateVO, authority);
        return CommonResponse.success("保存成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     *
     * @return
     */
    @RequestMapping(value = "/pushContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractVO> pushContract(@RequestParam Long id){

        ContractEntity contractEntity = service.selectById(id);
        ContractVO map = BeanMapper.map(contractEntity,ContractVO.class);
        service.pushContract(map);
        return CommonResponse.success("同步合同池成功");
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            boolean filingFlag = service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error("合同未归档，不允许新增补充协议！");
            }
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return service.deleteByIds(vos);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     *
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = pageList(param);
        List<ContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<ContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(c -> {
                    //设置合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；
                    // 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。
                    // 当合同存在生效的最终结算时，状态自动改为【已终止】
                    if(StringUtils.isBlank(c.getPerformanceStatus())) {
                        c.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                    }

                    //设置签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
                    if(StringUtils.isBlank(c.getSignatureStatus())) {
                        c.setSignatureStatus(SignatureStatusEnum.未签章.getDescription());
                    } else {
                        c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                    }

                    //流程状态
                    c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 合同参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

        if (!(null != conditionMap.get("orgId") || null != conditionMap.get("projectId"))){
            return CommonResponse.error("当前传入项目id 或 组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")){
            return CommonResponse.error("当前传入组织类型为空！");
        }
//        if(null != conditionMap.get("contractType")) {
//            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, conditionMap.get("contractType")));
//        }
        if(null != conditionMap.get("categoryId")) {
            //查询该分类下所有子分类
            CommonResponse<List<TemplateCategoryVO>> categoryVOResp = templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if(!categoryVOResp.isSuccess()) {
                return CommonResponse.error("获取合同类别信息失败！");
            }
            List<Long> categoryIds = categoryVOResp.getData().stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0:
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList<>());
                    page.put("total", 0);
                    page.put("current", queryParam.getPageIndex());
                    page.put("size", queryParam.getPageSize());
                    page.put("pages", 0);
                    return CommonResponse.success("查询分包合同数据成功！", page);
                case 1:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.EQ, categoryIds.get(0)));
                    break;
                default:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.IN, categoryIds));
            }
        }

        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else {

            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        queryParam.getParams().put("performance_status", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);
        // 获取合同归档控制参数
        String valueData = service.getContractFilingCode();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 控制参数0：不控制
            // 控制参数1：部分控制，需要传入参数filingType并且值=1，查询已归档合同
            if ("1".equals(valueData)) {
                // 如果传入查询条件中有filingType参数，并且参数值=1，则查询已归档的合同参照
                if (_con.containsKey("filingType") && "1".equals(_con.getString("filingType"))) {
                    queryParam.getParams()
                            .put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
                }
            }
            // 控制参数2：合同未归档限制全部业务，只查询已归档合同
            else if ("2".equals(valueData)) {
                queryParam.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }
        else {
            if ("2".equals(valueData)) {
                queryParam.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }
        logger.info("分包合同查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractEntity> pageData= service.queryPage(queryParam,false);
        logger.info("分包合同查询参照-查询结果条数---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同数据成功！",page);
    }

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            contractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", AC_CONTRACT_Bill_CODE);
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 合同明细参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/proOtherContractDetailRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> proOtherContractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
//        String calcLastTotalNum = null != conditionMap.get("calcLastTotalNum") ? conditionMap.get("calcLastTotalNum").toString() : null;

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置只查询叶子节点清单
        queryParam.getParams().put("detail_price", new Parameter(QueryParam.NE, null));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同明细查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractDetailEntity> pageData= detailService.queryPage(queryParam,false);
        logger.info("分包合同明细查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        List<JSONObject> records = BeanMapper.mapList(pageData.getRecords(), JSONObject.class);
        List<Long> detailIds = new ArrayList<>();
        Map<Long, List<JSONObject>> detailHasParentMap = new HashMap<>();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if(null != item.get("parentId")) {
                if(null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList<>());
                }
                detailHasParentMap.get(item.getLong("parentId")).add(item);
            }
        });

        //查询清单的直接父级
        if (!detailHasParentMap.isEmpty()){
            List<ContractDetailEntity> parents = (List<ContractDetailEntity>) detailService.listByIds(new ArrayList<>(detailHasParentMap.keySet()));
            for(ContractDetailEntity parent : parents) {
                detailHasParentMap.get(parent.getId()).forEach(child -> child.put("pTag", parent.getDetailCode() + "-" + parent.getDetailName()));
            }
        }
//        //查询清单的累计计量
//        if("true".equals(calcLastTotalNum)&&!detailIds.isEmpty()) {
//            Map<Long, BigDecimal> calcResult = measureDetailService.queryLastWorkNumByIds(detailIds);
//            records.stream().forEach(r -> {
//                r.put("lastTotalNum", calcResult.get(r.getLong("id")));
//            });
//        }

        page.put("records", records);
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同明细数据成功！",page);
    }

    /**
     * 合同明细参照查询（合同按钮选择用）
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractDetailRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractDetailVO> resList = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                List<ContractDetailVO> contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class);
                if (CollectionUtils.isNotEmpty(contractDetailList)) {
                    for (ContractDetailVO detail : contractDetailList) {
                        detail.setTid(detail.getId().toString());
                        detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                    }
                    resList = TreeNodeBUtil.buildTree(contractDetailList);
                }
            }
        }
        logger.info("返回合同明细数据成功：", JSONObject.toJSONString(resList));
        return CommonResponse.success("查询参照数据成功！",resList);
    }

    /**
     * @param contractId 合同id
     * @return 合同子级list
     */
    @ResponseBody
    @RequestMapping(value = "/queryPayment",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> queryPayment(
            @RequestParam(value = "contractId") String contractId){
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        ContractEntity contractEntity = service.selectById(contractId);
//        JSONObject jsonObject = new JSONObject();
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);

            }
        }
//        if (contractPayments.isEmpty()){
//            jsonObject.put("data",null);
//            return CommonResponse.success(jsonObject);
//        }
//        List<Map<String, Object>> list =new ArrayList();
//        contractPayments.forEach( payment->{
//            JSONObject o = (JSONObject) JSONObject.toJSON(payment);
//            o.put("text",payment.getPaymentName());
//            o.put("value",payment.getId());
//            list.add(o);
//        });
//        jsonObject.put("data",list);

        return CommonResponse.success("查询数据成功！",contractPayments);
    }

    /**
     * 付款阶段参照查询 后续删除
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractPaymentRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
            }
        }
        return CommonResponse.success("查询参照数据成功！",contractPayments);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        ContractVO vo = service.saveOrUpdateSupplement(supplement);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * 判断当前合同能否新增合同解除单据
     * @param id 合同主键
     * @return boolean
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = contractRelieveService.isCanRelieve(id);
        return CommonResponse.success("校验该合同新增合同解除单据成功！", flag);
    }

    /**
     * 合同其他费用参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractOtherCostRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractOtherCostRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同其他费用查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractOtherCostEntity> pageData= otherCostService.queryPage(queryParam,false);
        logger.info("分包合同其他费用查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同其他费用数据成功！",page);
    }

    @PostMapping(value = "/testPushContract")
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = service.selectById(contractVO.getId());
        boolean pushContractResult = service.pushContract(BeanMapper.map(contract, ContractVO.class));
        if(pushContractResult) {
            return CommonResponse.success("合同数据推送合同池成功！");
        }

        return CommonResponse.error("合同数据推送合同池失败！");
    }

    @PostMapping(value = "/deleteContractFile")
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = service.deleteContractFileById(contractVO.getId());
        if(null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error("合同删除合同附件失败！");
        }
        return CommonResponse.success("合同删除合同附件成功！", contractVersion);
    }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVo) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(contractVo));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }
    /**
     * 校验合同能否新增变更、补充协议
     *
     * @param id 合同id
     * @return 校验结果
     */
    @RequestMapping(value = "/checkContractFiling", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success("校验通过！");
        }
        return CommonResponse.error("当前合同无法新增");
    }


}
