package com.ejianc.business.proequipmentcorprent.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceEntity;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.proequipmentcorprent.appearance.service.IAppearanceService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.impl.UseRecordServiceImpl;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("appearance") 
public class AppearanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IAppearanceService service;
	@Autowired
	private IRentParameterService rentParameterService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		AppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e,false);

		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
				|| BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(userContext.getUserCode());
			e.setCommitUserName(userContext.getUserName());
		}


		List<RentParameterEntity> parameterList = new ArrayList<>();
		List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		for (AppearanceSubEntity subEntity : appearanceSubList) {
//			// 主表赋值
			RentParameterEntity parameterEntity = new RentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setOutDate(e.getAppearanceDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());//启动状态
			parameterEntity.setUseType(2);//使用
			// 处理子表
			List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
			RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
			detailEntity.setSourceType(RentParameterTypeEnum.退场单.getCode());
			detailEntity.setSourceId(e.getId());
			detailEntity.setOperationDate(e.getRentEndDate());
			detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
			detailEntity.setParameterId(subEntity.getSourceId());
			parameterDetailList.add(detailEntity);

			parameterEntity.setRentParameterDetailList(parameterDetailList);
			parameterList.add(parameterEntity);
		}
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.退场单.getCode());

		//TODO 推送供方暂时注释掉
		boolean pushFlag = false;
//推送供方
//		boolean pushFlag = service.pushBillToSupCenter(e,billTypeCode);
//		logger.info("获取推送供方结果--"+pushFlag);
		if(!pushFlag){
			e.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}else{
			e.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}
		service.saveOrUpdate(e, false);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AppearanceEntity entity = service.selectById(billId);
		if(entity.getNotSignature()){
			throw new BusinessException("已签字不能撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AppearanceEntity e = service.selectById(billId);
		List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		List<Long> parameterIdList = appearanceSubList.stream().map(AppearanceSubEntity::getSourceId).collect(Collectors.toList());
		rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.退场单.getCode(), e.getId());
		//推送供方
		if(BillPushStatusEnum.推送成功.getStatus().equals(e.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(e,billTypeCode);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				throw new BusinessException(commonResponse.getMsg());
			}
		}
		e.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		service.saveOrUpdate(e,false);
		return CommonResponse.success();
	}

}
