package com.ejianc.business.proequipmentcorppur.acceptance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.AcceptAbleContractDetailVO;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractDetailedService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设备验收表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseAcceptance")
public class PurchaseAcceptanceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EQUIP_PUR_ACCEPTANCE_CORP";

    @Autowired
    private IPurchaseAcceptanceService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPurchaseContractDetailedService purchaseContractDetailedService;

    @Autowired
    private IPurchaseAcceptanceSubService purchaseAcceptanceSubService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseAcceptanceVO> saveOrUpdate(@RequestBody PurchaseAcceptanceVO saveOrUpdateVO) {
    	PurchaseAcceptanceEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseAcceptanceEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }

            QueryParam param = new QueryParam();
            param.getParams().put("orgId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getProjectId()));
            param.getParams().put("contractId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getContractId()));
            if(null != saveOrUpdateVO.getId()) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, saveOrUpdateVO.getId()));
            }
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("billState",new Parameter(QueryParam.NOT_IN,billStateList));
            param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
            List<PurchaseAcceptanceEntity> entityList = service.queryList(param);
            if(CollectionUtils.isNotEmpty(entityList)){
                throw new BusinessException("存在未生效的验收单！");
            }

            //由于只对单台设备进行验收，将设备的出厂编码维护在主表中
            if(CollectionUtils.isNotEmpty(entity.getPurchaseAcceptanceSubList())) {
                PurchaseAcceptanceSubEntity subEntity = entity.getPurchaseAcceptanceSubList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList()).get(0);
                entity.setLeaveFactoryCode(subEntity.getEquipmentFactoryCode());
                entity.setManufacturer(subEntity.getManufacturer());
            }
        }

        PurchaseAcceptanceVO vo = service.saveOrUpdateAccepts(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseAcceptanceVO> queryDetail(Long id) {
    	PurchaseAcceptanceEntity entity = service.selectById(id);
    	PurchaseAcceptanceVO vo = BeanMapper.map(entity, PurchaseAcceptanceVO.class);
        vo.setEquipmentCode(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentCode());
        vo.setEquipmentType(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentType());
        vo.setEquipmentName(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentName());
        vo.setSpec(entity.getPurchaseAcceptanceSubList().get(0).getSpec());
        vo.setCompany(entity.getPurchaseAcceptanceSubList().get(0).getCompany());
        vo.setPurchasePrice(entity.getPurchaseAcceptanceSubList().get(0).getPurchasePrice());
        vo.setContractNum(entity.getPurchaseAcceptanceSubList().get(0).getContractNum());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseAcceptanceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchaseAcceptanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchaseAcceptanceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseAcceptanceVO>> queryList(@RequestBody QueryParam param) {

        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("acceptancePsn");
        param.getFuzzyFields().add("acceptanceDate");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();

            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.valueOf(param.getParams().get("orgId").getValue().toString())), true, "查询失败，获取当前本下组织信息失败。");
        }

        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<PurchaseAcceptanceEntity> page = service.queryPage(param,false);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseAcceptanceVO.class));
        List<PurchaseAcceptanceVO> records = pageData.getRecords();
        for (PurchaseAcceptanceVO record : records) {
            PurchaseAcceptanceEntity entity = service.selectById(record.getId());
            if(CollectionUtils.isNotEmpty(entity.getPurchaseAcceptanceSubList())) {
                record.setEquipmentCode(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentCode());
                record.setEquipmentType(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentType());
                record.setEquipmentName(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentName());
                record.setSpec(entity.getPurchaseAcceptanceSubList().get(0).getSpec());
                record.setCompany(entity.getPurchaseAcceptanceSubList().get(0).getCompany());
                record.setPurchasePrice(entity.getPurchaseAcceptanceSubList().get(0).getPurchasePrice());
                record.setContractNum(entity.getPurchaseAcceptanceSubList().get(0).getContractNum());
            }

        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseAcceptanceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PurchaseAcceptance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseAcceptanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseAcceptanceVO>> refPurchaseAcceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("equipmentType");
        fuzzyFields.add("equipmentName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("overageSettleTaxMny", new Parameter(QueryParam.GT, 0));
        IPage<PurchaseAcceptanceVO> page = null;
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                page = service.refPurchaseAcceptanceData(param,contractId,pageNumber,pageSize);
                IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseAcceptanceVO.class));
                return CommonResponse.success("查询参照数据成功！",pageData);
            }else {
                throw new BusinessException("合同ID为空");
            }
        }
        return CommonResponse.success("查询列表数据成功！",null);
     }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refEquipmentDetailedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AcceptAbleContractDetailVO>> refEquipmentDetailedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                      String condition,
                                                                                      String searchObject,
                                                                                      String searchText) {
        Long contractId = null;

        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("cId");
        }
        if(contractId == null){
            throw new BusinessException("请选择合同");
        }

        //查询合同下 已进行设备验收 且设备状态为 闲置和在用的设备
        IPage<AcceptAbleContractDetailVO> pageData= new Page<>(pageNumber, pageSize);
        purchaseAcceptanceSubService.pageAcceptAbleEquipDetail(pageData, contractId, searchText);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
