/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outLedger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorpout.appearance.service.IOutAppearanceService;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.mapper.OutRentParameterMapper;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStopService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRentParameterService")
public class OutRentParameterServiceImpl
extends BaseServiceImpl<OutRentParameterMapper, OutRentParameterEntity>
implements IOutRentParameterService {
    private static final String BILL_CODE = "EQUIP_OUT_STORE_CORP";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IOutRentEquipmentStartService startService;
    @Autowired
    private IOutRentEquipmentStopService stopService;
    @Autowired
    private IOutAppearanceService appearanceService;
    @Autowired
    private IOutRentRentalService rentRentalService;

    @Override
    public void saveOrUpdateOutRentParams(OutRentParameterVO saveOrUpdateVO) {
        OutRentParameterEntity entity = this.generateEntity(saveOrUpdateVO);
        super.saveOrUpdate((Object)entity, false);
    }

    private OutRentParameterEntity generateEntity(OutRentParameterVO saveOrUpdateVO) {
        OutRentParameterEntity codeEntity;
        OutRentParameterEntity entity = (OutRentParameterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRentParameterEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isBlank((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryWrapper checkQuery = new QueryWrapper();
        checkQuery.eq((Object)"code", (Object)entity.getCode());
        if (null != entity.getId()) {
            checkQuery.ne((Object)"id", (Object)entity.getId());
        }
        if (null != (codeEntity = (OutRentParameterEntity)((Object)super.getOne((Wrapper)checkQuery)))) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        return entity;
    }

    @Override
    public void saveOrUpdateOutRentParams(List<OutRentParameterVO> pushParamVOs) {
        this.logger.info("\u63a5\u6536\u5230\u5f85\u4fdd\u5b58\u51fa\u5e93\u53f0\u5e10\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(pushParamVOs));
        ArrayList<String> codelist = new ArrayList<String>(10);
        for (OutRentParameterVO pushParamVO : pushParamVOs) {
            if (StringUtils.isNotBlank((CharSequence)pushParamVO.getCode())) {
                if (codelist.contains(pushParamVO.getCode())) {
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
                }
                codelist.add(pushParamVO.getCode());
            }
            super.saveOrUpdate((Object)this.generateEntity(pushParamVO), false);
        }
    }

    @Override
    public void changeParameter(List<OutRentParameterEntity> parameterList, String sourceType) {
        this.logger.info("\u8fdb\u5165\u8bbe\u5907\u79df\u51fa\u53f0\u8d26\u53d8\u66f4\u65b9\u6cd5\uff0c\u53d8\u66f4\u7c7b\u578b\uff1a{}\uff0c\u53d8\u66f4\u53c2\u6570\uff1a{}", (Object)RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), (Object)JSONObject.toJSONString(parameterList));
        if (CollectionUtils.isEmpty(parameterList)) {
            return;
        }
        HashMap<Long, OutRentParameterEntity> map = new HashMap<Long, OutRentParameterEntity>();
        ArrayList<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<OutRentParameterDetailEntity>();
        for (OutRentParameterEntity entity : parameterList) {
            map.put(entity.getId(), entity);
            for (OutRentParameterDetailEntity detailEntity : entity.getRentParameterDetailList()) {
                detailEntity.setParameterId(entity.getId());
            }
            parameterDetailList.addAll(entity.getRentParameterDetailList());
        }
        QueryParam queryParam = new QueryParam();
        List parameterIdList = parameterList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        queryParam.getParams().put("id", new Parameter("in", parameterIdList));
        List saveList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)saveList)) {
            for (OutRentParameterEntity saveEntity : saveList) {
                OutRentParameterEntity entity = (OutRentParameterEntity)((Object)map.get(saveEntity.getId()));
                saveEntity.setEquipmentState(entity.getEquipmentState());
                saveEntity.setEquipmentStateName(entity.getEquipmentStateName());
                if (RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStartDate(entity.getStartDate());
                } else if (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStopDate(entity.getStopDate());
                } else if (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType)) {
                    saveEntity.setOutDate(entity.getOutDate());
                } else if (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType)) {
                    if (RentOutStatusEnum.\u542f\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStartDate(entity.getOperationDate());
                    } else if (RentOutStatusEnum.\u505c\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStopDate(entity.getOperationDate());
                    } else if (RentOutStatusEnum.\u9000\u573a.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setOutDate(entity.getOperationDate());
                    }
                }
                saveEntity.setOperationDate(new Date());
            }
            super.saveOrUpdateBatch((Collection)saveList);
        }
        if (CollectionUtils.isNotEmpty(parameterDetailList)) {
            this.outRentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
        }
    }

    @Override
    public void cancelParameter(List<Long> parameterIdList, String sourceType, Long sourceId) {
        this.logger.info("\u8fdb\u5165\u8bbe\u5907\u53f0\u8d26\u64a4\u56de\u65b9\u6cd5\uff0c\u64a4\u9500\u7c7b\u578b\uff1a{}\uff0c\u64a4\u9500\u5355\u636eid\uff1a{}\uff0c\u64a4\u9500\u53c2\u6570\uff1a{}", new Object[]{RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, JSONObject.toJSONString(parameterIdList)});
        this.outRentParameterDetailService.delParameterDetail(sourceId, sourceType);
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        detailParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.outRentParameterDetailService.queryList(detailParam, false);
        LinkedHashMap<Long, OutRentParameterDetailEntity> map = new LinkedHashMap<Long, OutRentParameterDetailEntity>();
        for (OutRentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) continue;
            map.put(detailEntity.getParameterId(), detailEntity);
        }
        QueryParam saveParam = new QueryParam();
        saveParam.getParams().put("id", new Parameter("in", parameterIdList));
        List saveList = super.queryList(saveParam, false);
        this.logger.info("\u67e5\u8be2\u5230\u8bbe\u5907\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)saveList));
        for (OutRentParameterEntity saveEntity : saveList) {
            OutRentParameterDetailEntity detailEntity = (OutRentParameterDetailEntity)((Object)map.get(saveEntity.getId()));
            if (OutRentEquipmentStateEnum.\u542f\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                saveEntity.setStartDate(detailEntity.getOperationDate());
                saveEntity.setEquipmentState(OutRentEquipmentStateEnum.\u505c\u7528.getCode());
                saveEntity.setEquipmentStateName(OutRentEquipmentStateEnum.\u505c\u7528.getDescription());
                this.logger.info("\u8bbe\u5907\u72b6\u6001\uff1a{}", (Object)OutRentEquipmentStateEnum.\u505c\u7528.getDescription());
            } else if (OutRentEquipmentStateEnum.\u505c\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                saveEntity.setStopDate(detailEntity.getOperationDate());
                saveEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
                saveEntity.setEquipmentStateName(OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
                this.logger.info("\u8bbe\u5907\u72b6\u6001\uff1a{}", (Object)OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
            } else if (OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(saveEntity.getEquipmentState())) {
                this.logger.info("\u8fdb\u5165\u9000\u573a\u72b6\u6001\u64a4\u56de\u3002saveEntity\u72b6\u6001{}\uff0cdetailEntity\u72b6\u6001{}", (Object)saveEntity.getEquipmentState(), (Object)detailEntity.getEquipmentState());
                saveEntity.setEquipmentState(detailEntity.getEquipmentState());
                if (OutRentEquipmentStateEnum.\u505c\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                    saveEntity.setEquipmentState(OutRentEquipmentStateEnum.\u505c\u7528.getCode());
                    saveEntity.setEquipmentStateName(OutRentEquipmentStateEnum.\u505c\u7528.getDescription());
                } else {
                    saveEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
                    saveEntity.setEquipmentStateName(OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
                }
                saveEntity.setOutDate(detailEntity.getOperationDate());
            }
            saveEntity.setOperationDate(new Date());
        }
        this.logger.info("\u4fee\u6539\u540e\u8bbe\u5907\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)saveList));
        super.saveOrUpdateBatch((Collection)saveList);
        this.logger.info("\u4fee\u6539\u4fdd\u5b58\u540e\u8bbe\u5907\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)super.queryList(saveParam)));
    }

    @Override
    public String removeBySourceId(Long sourceId, String sourceBillType) {
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"source_id", (Object)sourceId);
        delWrapper.eq((Object)"source_bill_type", (Object)sourceBillType);
        List entitys = super.list((Wrapper)delWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entitys)) {
            super.removeByIds((Collection)entitys.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
        }
        return null;
    }

    @Override
    public void checkValidation(List<Long> parameterIdList, String sourceType, Long sourceId, Long contractId, Date myDate) {
        List startEntityList;
        this.logger.info("\u8fdb\u884c\u5355\u636e\u4fdd\u5b58\u524d\u6821\u9a8c\uff0c\u6821\u9a8c\u53c2\u6570\uff1aparameterIdList\uff1a{}\uff0csourceType\uff1a{}\uff0csourceTypeName:{}\uff0csourceId:{}\uff0ccontractId:{}\uff0cmyDate\uff1a{}", new Object[]{JSONObject.toJSONString(parameterIdList), sourceType, RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, contractId, myDate});
        if (CollectionUtils.isEmpty(parameterIdList)) {
            return;
        }
        String sourceTypeName = RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) ? "\u542f\u7528" : (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) ? "\u505c\u7528" : (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType) ? "\u9000\u573a" : (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType) ? "\u79df\u91d1\u8ba1\u7b97" : "")));
        QueryParam parameterParam = new QueryParam();
        parameterParam.getParams().put("id", new Parameter("in", parameterIdList));
        List parameterEntityList = super.queryList(parameterParam, false);
        HashMap<Long, OutRentParameterEntity> parameterEntityMap = new HashMap<Long, OutRentParameterEntity>();
        StringBuilder sb = new StringBuilder();
        for (OutRentParameterEntity entity : parameterEntityList) {
            parameterEntityMap.put(entity.getId(), entity);
            if ((!RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) || !RentOutStatusEnum.\u542f\u7528.getCode().equals(entity.getEquipmentState())) && (!RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) || !RentOutStatusEnum.\u505c\u7528.getCode().equals(entity.getEquipmentState()))) continue;
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]\u3001");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("\u5df2").append(sourceTypeName).append("\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e");
            throw new BusinessException(sb.toString());
        }
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        checkQueryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter("ne", (Object)sourceId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(startEntityList = this.startService.queryList(checkQueryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u542f\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        List stopEntityList = this.stopService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)stopEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u505c\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        List appearanceEntityList = this.appearanceService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)appearanceEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u9000\u573a\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        checkQueryParam.getParams().put("rentalType", new Parameter("eq", (Object)"1"));
        List rentalEntityList = this.rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)rentalEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        QueryParam dateParam = new QueryParam();
        dateParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        dateParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.outRentParameterDetailService.queryList(dateParam, false);
        LinkedHashMap<Long, OutRentParameterDetailEntity> map = new LinkedHashMap<Long, OutRentParameterDetailEntity>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (OutRentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) continue;
            map.put(detailEntity.getParameterId(), detailEntity);
            if (myDate.after(detailEntity.getOperationDate())) continue;
            OutRentParameterEntity entity = (OutRentParameterEntity)((Object)parameterEntityMap.get(detailEntity.getParameterId()));
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]").append(sourceTypeName).append("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e").append(sdf.format(detailEntity.getOperationDate())).append(",");
            if (!RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType)) continue;
            throw new BusinessException(sourceTypeName + "\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + sdf.format(detailEntity.getOperationDate()));
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            throw new BusinessException(sb.toString());
        }
    }

    @Override
    public List<OutRentParameterVO> getRentParameterByContractId(Long contractId, Long sourceId, Date endDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List<Long> parameterIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.checkValidation(parameterIdList, RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode(), sourceId, contractId, endDate);
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        detailParam.getParams().put("operationDate", new Parameter("le", (Object)endDate));
        detailParam.getOrderMap().put("operationDate", "desc");
        detailParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.outRentParameterDetailService.queryList(detailParam, false);
        HashMap map = new HashMap();
        for (OutRentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) {
                ((List)map.get(detailEntity.getParameterId())).add(detailEntity);
                continue;
            }
            ArrayList<OutRentParameterDetailEntity> packList = new ArrayList<OutRentParameterDetailEntity>();
            packList.add(detailEntity);
            map.put(detailEntity.getParameterId(), packList);
        }
        for (OutRentParameterEntity entity : list) {
            List detailEntityList = (List)map.get(entity.getId());
            ArrayList<OutRentParameterDetailEntity> addDetailList = new ArrayList<OutRentParameterDetailEntity>();
            for (OutRentParameterDetailEntity detailEntity : detailEntityList) {
                if (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(detailEntity.getSourceType())) {
                    addDetailList.add(detailEntity);
                    break;
                }
                addDetailList.add(detailEntity);
            }
            addDetailList.sort(Comparator.comparing(OutRentParameterDetailEntity::getOperationDate));
            entity.setRentParameterDetailList(addDetailList);
        }
        return BeanMapper.mapList((Iterable)list, OutRentParameterVO.class);
    }
}

