package com.ejianc.business.proequipmentcorpout.outLedger.service;

import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 租出设备台账服务接口
 *
 * @author CJ
 * @Description: 租出设备台账服务接口
 * @date 2022/10/27 14:27
 */
public interface IOutRentParameterService extends IBaseService<OutRentParameterEntity> {
    /**
     * 保存更新租出设备台账
     *
     * @param pushParamVO
     */
    void saveOrUpdateOutRentParams(OutRentParameterVO pushParamVO);
    /**
     * 保存更新租出设备台账
     *
     * @param pushParamVOs
     */
    void saveOrUpdateOutRentParams(List<OutRentParameterVO> pushParamVOs);

    /**
     * 变更设备台账
     * 设备启用、设备停用、设备退场，更改台账状态，并添加操作记录
     *
     * @param parameterList 设备台账列表
     * @param sourceType    来源类型
     */
    void changeParameter(List<OutRentParameterEntity> parameterList, String sourceType);

    /**
     * 撤销设备台账变更
     *
     * @param parameterIdList 设备台账id列表
     * @param sourceType      变更类型
     * @param sourceId        变更单据id
     */
    void cancelParameter(List<Long> parameterIdList, String sourceType, Long sourceId);

    String removeBySourceId(Long sourceId, String sourceBillType);

    /**
     * 启用单、停用单、退场单保存前校验，校验不通过则抛出异常
     * <p>1.校验单据类型与当前设备状态，设备启用状态无法新增启用单，设备停用状态无法新增停用单</p>
     * <p>2.互斥性校验，启用单、停用单、退场单同一个合同下只能存在一个非生效状态的单据</p>
     * <p>3.日期校验，三个单据的日期状态是滚动向前的，每次新增单据时，需要查询当前单据的时间是否大于数据库中最新的时间</p>
     *
     * @param parameterIdList 需要校验的设备台账id列表
     * @param sourceType      单据类型
     * @param sourceId        单据id
     * @param contractId      合同id
     * @param myDate          校验的时间
     */
    void checkValidation(List<Long> parameterIdList, String sourceType, Long sourceId, Long contractId, Date myDate);


    /**
     * 根据合同id查询当前合同下所有的设备台账
     *
     * @param contractId 合同id
     * @param sourceId   来源id
     * @param endDate    截止日期
     * @return 合同下设备台账
     */
    List<OutRentParameterVO> getRentParameterByContractId(Long contractId, Long sourceId, Date endDate);
}
