package com.ejianc.business.proequipmentcorprent.rent.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同状态
 */
public enum ContractStatusEnum {

    /**
     * 合同状态: 1-未签订
     */
    未签订(1, "未签订"),

    /**
     * 变更状态: 2-变更中
     */
    履约中(2, "履约中"),

    /**
     * 变更状态: 3-已变更
     */
    已终止(3, "已终止"),

    /**
     * 变更状态: 4-变更单据审批通过
     */
    已作废(4, "已作废"),
    已冻结(5, "已冻结"),
    已结束(6, "已结束");

    private Integer code;
    private String description;
    private static Map<Integer, ContractStatusEnum> enumMap = new HashMap<>();

    ContractStatusEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ContractStatusEnum.class).stream().collect(Collectors.toMap(ContractStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
