package com.ejianc.business.proequipmentcorprent.rent.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态
 */
public enum SignatureStatusEnum {

    /**
     * 签章状态：1、未签章
     */
    未签章("1", "未签章"),
    /**
     * 签章状态：2、待乙方签章；
     */
    待乙方签章("2", "待乙方签章"),
    /**
     * 签章状态：3、待甲方签章；
     */
    待甲方签章("3", "待甲方签章"),
    /**
     * 签章状态：4、已签章；
     */
    已签章("4", "已签章"),

    /**
     * 签字状态：5、已退回（已拒签）；
     */
    已退回("5","已退回（已拒签）"),
    /**
     * 签字状态：6、已撤回；
     */
    已撤回("6","已撤回"),
    /**
     * 签字状态：7、已过期；
     */
    已过期("7","已过期"),
    /**
     * 签字状态：8、其他；
     */
    其他("8","其他");

    private String code;
    private String description;
    private static Map<String, SignatureStatusEnum> enumMap = new HashMap<>();

    SignatureStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(SignatureStatusEnum.class).stream().collect(Collectors.toMap(SignatureStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static SignatureStatusEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
