package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("rentAcceptance")
public class RentAcceptanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	@Autowired
	private IRentParameterService parameterService;
	private static final String BILL_TYPE_CODE = "BT220317000000015";//此处需要根据实际修改
	private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck";
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/deleteCheck";//未调整
	private final String OPERATE = "RENT-PROEQUIPMENT-ACCEPTANCE";
	@Autowired
	private IRentParameterDetailService parameterDetailService;
	@Autowired
	private IRentContractService contractService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProSupplierApi proSupplierApi;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentContractService outRentContractService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		List<RentParameterEntity> parameterList = new ArrayList<>();
		RentAcceptanceEntity rentAcceptanceEntity = rentAcceptanceService.selectById(billId);
		List<RentAcceptanceSubEntity> acceptanceSubList = rentAcceptanceEntity.getRentAcceptanceSubList();
		RentContractEntity contractEntity = contractService.selectById(rentAcceptanceEntity.getContractId());
		for (RentAcceptanceSubEntity e : acceptanceSubList) {
			RentParameterEntity parameter = new RentParameterEntity();
			// 验收信息
			parameter.setContractId(rentAcceptanceEntity.getContractId());//合同id
			parameter.setContractName(rentAcceptanceEntity.getContractName()); // 合同名称
			parameter.setEngineeringId(rentAcceptanceEntity.getEngineeringId()); // 工程id
			parameter.setEngineeringName(rentAcceptanceEntity.getEngineeringName()); // 工程名称
			parameter.setSupplierId(rentAcceptanceEntity.getSupplierId()); // 供应商id
			parameter.setSupplierName(rentAcceptanceEntity.getSupplierName()); // 供应商名称
			parameter.setProjectId(rentAcceptanceEntity.getProjectId()); // 项目id
			parameter.setProjectCode(rentAcceptanceEntity.getProjectCode()); // 项目code
			parameter.setProjectName(rentAcceptanceEntity.getProjectName()); // 项目名称
			parameter.setAcceptanceId(rentAcceptanceEntity.getId()); // 验收单id
			parameter.setAcceptanceDate(rentAcceptanceEntity.getAcceptanceDate()); // 验收日期
			parameter.setSourceId(rentAcceptanceEntity.getId()); // 来源id
			// 合同信息
			parameter.setOrgId(contractEntity.getOrgId()); // 组织id
			parameter.setOrgName(contractEntity.getOrgName()); // 组织名称
			parameter.setParentOrgId(contractEntity.getParentOrgId());
			parameter.setParentOrgCode(contractEntity.getParentOrgCode());
			parameter.setParentOrgName(contractEntity.getParentOrgName());
			parameter.setRentHarborType(contractEntity.getRentHarborType().equals("内租") ? 1:2);
			// 设备信息
			parameter.setAcceptanceName(rentAcceptanceEntity.getCode());
			parameter.setCheckBeforeId(e.getCheckBeforeId());
			parameter.setCheckBeforeName(e.getCheckBeforeName());

			parameter.setFactoryCode(e.getFactoryCode()); // 设备出厂编码
			parameter.setCategoryId(e.getCategoryId()); // 设备类别id
			parameter.setCategoryName(e.getCategoryName()); // 设备类别名称
			parameter.setSpec(e.getSpecs()); // 规格型号
			parameter.setUnitName(e.getUnitName()); // 计量单位

			parameter.setStartDate(rentAcceptanceEntity.getAcceptanceDate());

			parameter.setPlanIntoDate(e.getPlanIntoDate()); // 计划进厂日期
			parameter.setPlanOutDate(e.getPlanOutDate()); // 计划出厂日期
			parameter.setProductionManufactor(e.getProductionManufactor()); // 生产厂家
			parameter.setMemo(e.getMemo()); // 备注
			parameter.setEquipmentCode(e.getEquipmentCode()); // 设备编号
			parameter.setEquipmentId(e.getEquipmentId()); // 设备id
			parameter.setName(e.getName()); // 设备id
			parameter.setNum(e.getNum());
			parameter.setRentNum(e.getNum()); // 租赁数量
			parameter.setRentTypeId(e.getRentTypeId()); // 租赁方式id
			parameter.setRentTypeName(e.getRentTypeName()); // 租赁方式名称
			parameter.setAcceptanceDetailId(e.getId()); // 验收单明细id
			parameter.setEquipmentName(e.getName()); // 设备名称
			parameter.setPrice(e.getPrice()); // 有税单价
			parameter.setNotTaxPrice(e.getNotTaxPrice()); // 无税单价
			parameter.setMeterRentDate(e.getMeterRentDate()); // 计租日期
			parameter.setOperationDate(new Date()); // 操作日期
			parameter.setQuantitiesNum(e.getQuantitiesNum() == null ? BigDecimal.ZERO : new BigDecimal(e.getQuantitiesNum()));
//			parameter.setEquipmentCost(); // 设备费用

			RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
			//storeType; // 入库方式，0-收料入库 闲置-停用，1-直入直出  再用-启用
			switch (rentAcceptanceEntity.getStoreType()){// UseType 使用状态1-闲置,2-再用
				case "0":
					parameter.setUseType(1);
					parameter.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
					detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
					break;
				case "1":
					parameter.setUseType(2);
					parameter.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
					detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
					break;
			}
			detailEntity.setOperationDate(e.getMeterRentDate());
			detailEntity.setSourceId(rentAcceptanceEntity.getId());
			detailEntity.setSourceType(RentParameterTypeEnum.验收单.getCode());
			List<RentParameterDetailEntity> detailEntityList = new ArrayList<>();
			detailEntityList.add(detailEntity);

			parameter.setRentParameterDetailList(detailEntityList);
			parameterList.add(parameter);
		}
		logger.info("处理台账主表数据：{}", JSONObject.toJSONString(parameterList));
		parameterService.saveOrUpdateBatch(parameterList);
		List<RentParameterDetailEntity> addParameterDetailList = new ArrayList<>();
		for (RentParameterEntity entity : parameterList) {
			List<RentParameterDetailEntity> detailEntityList = entity.getRentParameterDetailList();
			for (RentParameterDetailEntity detailEntity : detailEntityList) {
				detailEntity.setParameterId(entity.getId());
			}
			addParameterDetailList.addAll(detailEntityList);
		}
		logger.info("处理台账子表数据：{}", JSONObject.toJSONString(addParameterDetailList));
		parameterDetailService.saveOrUpdateBatch(addParameterDetailList);
		/*--------*/
		//如果是设备验收直入直出，则生成出库台账数据
		if("1".equals(rentAcceptanceEntity.getStoreType())) {
			//推送租出台账用
			RentAcceptanceEntity rentAcceptanceVO = BeanMapper.map(rentAcceptanceEntity, RentAcceptanceEntity.class);

			OutRentContractEntity contract = outRentContractService.selectById(rentAcceptanceVO.getOutContractId());
			if(null == contract) {
				throw new BusinessException("未查询到id-["+rentAcceptanceVO.getOutContractId()+"]匹配的租出合同信息！");
			}
			for (RentAcceptanceSubEntity subVo : acceptanceSubList) {
				OutRentParameterVO pushParamVO = null;
				try {
					pushParamVO = BeanConvertorUtil.convert(rentAcceptanceVO, OutRentParameterVO.class);
					logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));
				} catch (Exception e) {
					logger.error("出库单推送租出设备台账失败, 出库转换台账单异常: ", e);
					return CommonResponse.error("出库单推送租出设备台账失败！");
				}
//设备基本信息
				pushParamVO.setCategoryId(subVo.getCategoryId());
				pushParamVO.setCategoryName(subVo.getCategoryName());
				pushParamVO.setEquipmentId(subVo.getEquipmentId());
				pushParamVO.setEquipmentCode(subVo.getEquipmentCode());
				pushParamVO.setEquipmentName(subVo.getName());
				pushParamVO.setUnitName(subVo.getUnitName());
				pushParamVO.setProductionManufactor(subVo.getProductionManufactor());
				//组织项目信息
				pushParamVO.setProjectId(contract.getProjectId());
				pushParamVO.setProjectCode(contract.getProjectCode());
				pushParamVO.setProjectName(contract.getProjectName());
				//项目部
				pushParamVO.setOutOrgId(contract.getOutOrgId());
				pushParamVO.setOutOrgCode(contract.getOutOrgCode());
				pushParamVO.setOutOrgName(contract.getOutOrgName());
				pushParamVO.setParentOrgId(contract.getParentOrgId());
				pushParamVO.setParentOrgName(contract.getParentOrgName());
				pushParamVO.setParentOrgCode(contract.getParentOrgCode());
				//租赁方
				pushParamVO.setFirstPartyId(contract.getPartyId());
				pushParamVO.setFirstPartyName(contract.getPartyName());
				//单据审批状态设置为生效
				pushParamVO.setBillState(1);
				//计租日期
				pushParamVO.setMeterRentDate(subVo.getMeterRentDate());
				//计租方式
				pushParamVO.setMeterRentType(contract.getMeterRentType());
				pushParamVO.setRentHarborType(contract.getRentHarborType());
				//设备状态
				pushParamVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
				pushParamVO.setEquipmentStateName(OutRentEquipmentStateEnum.启用.getDescription());
				//使用状态- 在用
				pushParamVO.setUseType(2);
				//使用项目-- 从出库单的项目信息获取
				pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
				pushParamVO.setUseProjectId(pushParamVO.getProjectId());
				pushParamVO.setUseProjectName(pushParamVO.getProjectName());
				pushParamVO.setUseOrgCode(pushParamVO.getUseOrgCode());
				pushParamVO.setUseOrgName(pushParamVO.getUseOrgName());
				pushParamVO.setUseOrgId(pushParamVO.getUseOrgId());
				//租出单位
				pushParamVO.setOrgId(contract.getOrgId());
				pushParamVO.setOrgName(contract.getOrgName());
				pushParamVO.setOrgCode(contract.getOrgCode());

				//合同税率
				pushParamVO.setContractId(contract.getId());
				pushParamVO.setContractName(contract.getContractName());
				pushParamVO.setContractCode(contract.getContractCode());
				pushParamVO.setContractTaxRate(contract.getContractTax());

				//合同供应商
				pushParamVO.setSupplierId(contract.getSupplierId());
				pushParamVO.setSupplierName(contract.getSupplierName());
				pushParamVO.setSourceId(rentAcceptanceVO.getId());
				pushParamVO.setSourceBillType(RentOutParamSourceBillTypeEnum.设备验收直入直出.getCode());
				//设备出厂编码
				pushParamVO.setFactoryCode(subVo.getFactoryCode());
				//设备台账Id
//				pushParamVO.setEquipLedgerId(subVo.getId());
				//设备台账出厂编码
				pushParamVO.setEquipLedgerFactoryCode(subVo.getFactoryCode());

				//验收单Id
				pushParamVO.setAcceptanceId(rentAcceptanceVO.getId());
				pushParamVO.setAcceptanceDetailId(subVo.getId());
				//验收日期
				pushParamVO.setAcceptanceDate(rentAcceptanceVO.getAcceptanceDate());
				//出库日期
				pushParamVO.setOutstoreDate(rentAcceptanceVO.getAcceptanceDate());

				OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
				paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
				paramDetailVO.setOperationDate(rentAcceptanceVO.getAcceptanceDate());
				paramDetailVO.setSourceId(subVo.getId());
				paramDetailVO.setSourceType(OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE); //出库单
				List<OutRentParameterDetailVO> paramSubList =new ArrayList<>();
				paramSubList.add(paramDetailVO);
				pushParamVO.setRentParameterDetailList(paramSubList);
				logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));
				outRentParameterService.saveOrUpdateOutRentParams(pushParamVO);
			}
		}
		//推送供方验收单处理
		rentAcceptanceEntity.setCheckState(1);
		PushAppearanceVO supplierPushCheckVO = BeanMapper.map(rentAcceptanceEntity, PushAppearanceVO.class);
		List<PushAppearanceSubVO> pushAppearanceSubVOList = BeanMapper.mapList(rentAcceptanceEntity.getRentAcceptanceSubList(),PushAppearanceSubVO.class);
		supplierPushCheckVO.setRentAcceptanceDetailList(pushAppearanceSubVOList);
		supplierPushCheckVO.setSourceId(rentAcceptanceEntity.getId());
		List<PushAppearanceSubVO> checkDetailList = supplierPushCheckVO.getRentAcceptanceDetailList();
		for (PushAppearanceSubVO supplierPushCheckDetailVO : checkDetailList){
			supplierPushCheckDetailVO.setSourceId(rentAcceptanceEntity.getId());
			supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
			supplierPushCheckDetailVO.setId(null);
		}
		//设置单据当前系统信息
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
//			throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
		}
		else {
			// TODO 供方页面完成放开
			//设置当前系统ID
//			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
//			logger.info("dataInfo:"+dataInfo);
//			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
//			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
//			if (!cooperateResp.isSuccess()) {
//				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE_CODE, cooperateResp.getMsg());
//			}
//			else {
//				boolean b = rentAcceptanceService.pushBillToSupCenter(dataInfo, rentAcceptanceEntity.getSupplierId(),
//						rentAcceptanceEntity.getId(), BILL_TYPE_CODE, cooperateResp.getData(), PUSH_SAVE_URL);
//				if (!b) {
//					logger.error("推送供方失败！单据信息：{}", dataInfo);
//				}
//				else {
//					rentAcceptanceEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//				}
//			}
		}

		rentAcceptanceService.updateById(rentAcceptanceEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentAcceptanceEntity entity =rentAcceptanceService.selectById(billId);
		EquipmentNewDateVO equipmentNewDateVO =parameterService.selectAbandonDate(entity.getContractId(),entity.getAcceptanceDate());
		if(equipmentNewDateVO != null){
			if(!entity.getId().equals(equipmentNewDateVO.getId())){
				return CommonResponse.error("弃审失败:请先弃审设备" + equipmentNewDateVO.getType() + "单据在弃审本单据");
			}
		}
		List<RentAcceptanceSubEntity> rentAcceptanceSubList = entity.getRentAcceptanceSubList();
		if(CollectionUtils.isNotEmpty(rentAcceptanceSubList)){
			for (RentAcceptanceSubEntity rentAcceptanceSubEntity : rentAcceptanceSubList) {
				if(rentAcceptanceSubEntity.getCheckAfterFlag()==1){
					return CommonResponse.error("弃审失败:有被安装后验收的明细！");
				}
			}
		}
		if("1".equals(entity.getStoreType())) {
			List<Long> subIds = entity.getRentAcceptanceSubList().stream().map(RentAcceptanceSubEntity::getId).collect(Collectors.toList());
			QueryWrapper<OutRentParameterDetailEntity> detailQuery = new QueryWrapper<>();
			if(CollectionUtils.isNotEmpty(subIds)){
				detailQuery.in("source_id", subIds);
				detailQuery.ne("source_type", OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE);

				List<OutRentParameterDetailEntity> list = outRentParameterDetailService.list(detailQuery);
				if(CollectionUtils.isNotEmpty(list)) {
					return CommonResponse.error("弃审失败，设备已进行下游业务！");
				}

				String result = outRentParameterService.removeBySourceId(entity.getId(), RentOutParamSourceBillTypeEnum.设备验收直入直出.getCode());
				if(StringUtils.isNotBlank(result)) {
					return CommonResponse.error("弃审失败，删除租出台账失败，原因："+result);
				}
			}
		}
// TODO 供方页面完成放开
//		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
//			//推送供方
//			//对单据进行加锁
//			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//			if (!ejcCloudSystemCode.isSuccess()) {
//				throw new BusinessException("获取当前系统编码失败！");
//			}
//			Map<String,Object> map = new HashMap<>();
//			map.put("sourceId",billId);
//			map.put("systemId",ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(map);
//			Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
//					entity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
//			if (!updateSupplierStatus){
//				throw new BusinessException("单据推送失败！");
//			}
//			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//			rentAcceptanceService.saveOrUpdate(entity,false);
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentAcceptanceEntity entity =rentAcceptanceService.selectById(billId);
		parameterService.deleteAcceptanceId(entity.getId());

		return CommonResponse.success();
	}

}
