package com.ejianc.business.proequipmentcorpout.outLedger.service.impl;

import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.mapper.OutRentParameterDetailMapper;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/10/28 17:06
 */
@Service("outRentParameterDetailService")
public class OutRentParameterDetailServiceImpl extends BaseServiceImpl<OutRentParameterDetailMapper, OutRentParameterDetailEntity> implements IOutRentParameterDetailService {

    @Override
    public void delParameterDetail(Long sourceId, String sourceType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.EQ, sourceType));
        List<OutRentParameterDetailEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            super.removeByIds(list.stream().map(OutRentParameterDetailEntity::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public void delParameterDetailList(List<Long> sourceIds, String sourceType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIds));
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.EQ, sourceType));
        List<OutRentParameterDetailEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            super.removeByIds(list.stream().map(OutRentParameterDetailEntity::getId).collect(Collectors.toList()));
        }
    }
}
