package com.ejianc.business.proequipmentcorpout.proxy.service.impl;

import com.ejianc.business.proequipmentcorpout.proxy.vo.ProxyContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorpout.proxy.mapper.ProxyContractMapper;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;

/**
 * 设备公司租出线-合同授权委托书
 * 
 * @author generator
 * 
 */
@Service("proxyContractService")
public class ProxyContractServiceImpl extends BaseServiceImpl<ProxyContractMapper, ProxyContractEntity> implements IProxyContractService{
    private static final String BILL_CODE = "PROXY_CONTRACT ";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public ProxyContractVO saveOrUpdate(ProxyContractVO saveOrUpdateVO) {
        ProxyContractEntity entity = BeanMapper.map(saveOrUpdateVO, ProxyContractEntity.class);
        if(StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ProxyContractVO.class);
    }
}
