package com.ejianc.business.proequipmentcorprent.rent.service;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentSettlementEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentRentalVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettlementVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentalSumVo;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 租金计算主表
 *
 * @author generator
 */
public interface IRentRentalService extends IBaseService<RentRentalEntity> {

    /**
     * 保存租金计算单据
     *
     * @param vo 租金机选
     * @return 保存结果
     */
    RentRentalVO saveRental(RentRentalVO vo);

    /**
     * 修改租金计算结算标志
     *
     * @param ids   租金计算单据id
     * @param state 标志
     * @return 修改结果
     */
    boolean updateRentalSettlementState(List<Long> ids, Integer state);

    /**
     * 实际成本关联保存
     *
     * @param rentRentalVO 租金计算VO
     * @return 保存结果
     */
    CommonResponse<RentRentalVO> pushCost(RentRentalVO rentRentalVO);

    /**
     * 租金计算推送实际成本
     *
     * @param rentRentalEntity 租金计算实体
     */
    void costPush(RentRentalEntity rentRentalEntity);

    /**
     * 租金自动计算
     *
     * @param vo 需要合同id，租金计算日期
     * @return 计算后结果
     */
    RentRentalVO automaticRental(RentRentalVO vo);

    /**
     * 批量删除单据
     *
     * @param vos 需要删除的单据信息
     */
    void delRental(List<RentRentalVO> vos);

    /**
     * 根据合同id查询审批通过的租金计算金额
     *
     * @param contractId 合同id
     * @return 租金计算金额
     */
    RentalSumVo queryRentalMnyByContractId(Long contractId);

}
