package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordSubService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁设备台账
 *
 * @author generator
 */
@Controller
@RequestMapping("rentParameter")
public class RentParameterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRentParameterService service;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IUseRecordSubService useRecordSubService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentParameterVO> saveOrUpdate(@RequestBody RentParameterVO saveOrUpdateVO) {
        RentParameterEntity entity = BeanMapper.map(saveOrUpdateVO, RentParameterEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        RentParameterVO vo = BeanMapper.map(entity, RentParameterVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentParameterVO> queryDetail(Long id) {
        RentParameterEntity entity = service.selectById(id);
        RentParameterVO vo = BeanMapper.map(entity, RentParameterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentParameterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RentParameterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RentParameterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("equipmentState")){
            param.getParams().put("equipmentState", new Parameter(QueryParam.NE, RentEquipmentStateEnum.退场.getCode()));
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        List<RentParameterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<RentParameterVO> listVo = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, RentParameterVO.class);
            listVo.forEach(vo -> {
//                类型
                vo.setRentHarborTypeName(vo.getRentHarborType() == 1 ? "内租" : "外租");
                //设备状态:1--进场,2--启用,3--停用,4--退场
                if (vo.getEquipmentState() == 1){
                    vo.setEquipmentStateName("进场");
                }
                if (vo.getEquipmentState() == 2){
                    vo.setEquipmentStateName("启用");
                }
                if (vo.getEquipmentState() == 3){
                    vo.setEquipmentStateName("停用");
                }
                if (vo.getEquipmentState() == 4){
                    vo.setEquipmentStateName("退场");
                }
                if (null!=vo.getUseType()){
                    switch (vo.getUseType()){
                        case 1:vo.setUseTypeName("在用");break;
                        case 2:vo.setUseTypeName("在用");break;
                    }
                }
            });
        }
        beans.put("records", listVo);
        ExcelExport.getInstance().export("rentParameter-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentParameterList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentParameterList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.getLong("contractId")));
            }
            if(null != _con.get("equipmentState")) {
                param.getParams().put("equipmentState", new Parameter(QueryParam.IN, _con.getString("equipmentState")));
            }
            if(null != _con.get("neEquipmentState")) {
                param.getParams().put("equipmentState", new Parameter(QueryParam.NE, _con.getInteger("neEquipmentState")));
            }
            if(null != _con.get("useType")) {
                param.getParams().put("useType", new Parameter(QueryParam.IN, _con.getString("useType")));
            }
        }

        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));
        for(RentParameterVO p : pageData.getRecords()) {
            p.setEquipmentStateName(RentEquipmentStateEnum.getEnumByCode(p.getEquipmentState()).getDescription());
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照（进场-启用设备）
     * @Return void
     */
    @RequestMapping(value = "/refRentParameterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentParameterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能必须传！");
        }

        param.getParams().put("equipmentState", new Parameter(QueryParam.NE, "4"));//启用,停用，待启用，停租

        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));
        pageData.getRecords().forEach(e->{
            if(e.getEquipmentState().equals(RentEquipmentStateEnum.启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.待启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.待启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停租.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停租.getDescription());
            }
        });
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 参照（停用设备）
     * @Return void
     */
    @RequestMapping(value = "/refRentParameterStopData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentParameterStopData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能必须传！");
        }

        param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, "3"));//查询不是停用的设备
        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));
        pageData.getRecords().forEach(e->{
            if(e.getEquipmentState().equals(RentEquipmentStateEnum.启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.待启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.待启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停租.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停租.getDescription());
            }
        });

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryContractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> queryContractList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");

        Long contractId = null;
        if (param.getParams().get("contractId") != null) {
            contractId = Long.parseLong((String) param.getParams().get("contractId").getValue());
        } else {
            throw new BusinessException("请选择合同");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 参照（设备启用参照）
     * @Return void 用于设备停用
     */
    @RequestMapping(value = "/refRentEquipmentStart", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentStart(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        /** 租户隔离 */
        Long contractId = null;
        Integer entranceRentFlag = 2; //是否退场停用  1-是  2-否
        List<Integer> entranceList = new ArrayList<>();
        entranceList.add(2);
        entranceList.add(3);
        param.getParams().put("rentTypeId", new Parameter(QueryParam.IN, "1,2"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
            entranceRentFlag = _con.getInteger("entranceRentFlag");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能必须传！");
        }

//        param.getParams().put("useType", new Parameter(QueryParam.EQ, "2"));//在用

        if(1==entranceRentFlag){
            //退场停用
            param.getParams().put("equipmentState", new Parameter(QueryParam.IN, entranceList));//停用，启用
        }else if(2==entranceRentFlag){
            param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, "2"));//启用
        }
        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));
        pageData.getRecords().forEach(e->{
            if(e.getEquipmentState().equals(RentEquipmentStateEnum.启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.待启用.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.待启用.getDescription());
            }else if(e.getEquipmentState().equals(RentEquipmentStateEnum.停租.getCode())){
                e.setEquipmentStateName(RentEquipmentStateEnum.停租.getDescription());
            }
        });
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照（设备停用参照）
     * @Return void 用于设备启用
     */
    @RequestMapping(value = "/refRentEquipmentStop", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentStop(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        Long contractId = null;
        Integer entranceRentFlag = 2; //是否初次进场计租   1-是  2-否
        param.getParams().put("rentTypeId", new Parameter(QueryParam.IN, "1,2"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
            entranceRentFlag = _con.getInteger("entranceRentFlag");
        }

        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能为空！");
        }
//        param.getParams().put("useType", new Parameter(QueryParam.EQ, "2"));//在用
        if(1==entranceRentFlag){
            //初次进场启用
            param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, "5"));//待启用
        }else if(2==entranceRentFlag){
            param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, "3"));//停用
        }

        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentParameterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照（工程量）
     * @Return void 用于设备使用记录
     */
    @RequestMapping(value = "/refRentEquipmentQuantities", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentQuantities(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        /** 租户隔离 */
        Long contractId = null;
        String flag = null;
        param.getParams().put("rentTypeId", new Parameter(QueryParam.EQ, "3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
            flag = _con.getString("flag");
        }

        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能必须传！");
        }
        RentContractEntity rentContractEntity = rentContractService.selectById(contractId);
        param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, "2"));//启用,和进场设备

        IPage<RentParameterEntity> page = service.queryPage(param, false);
        IPage<RentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RentParameterVO> rentParameterVOS = BeanMapper.mapList(page.getRecords(), RentParameterVO.class);
        if(CollectionUtils.isNotEmpty(rentParameterVOS) && null!=rentContractEntity){
            for (RentParameterVO rentParameterVO : rentParameterVOS) {
                rentParameterVO.setContractTaxRate(rentContractEntity.getContractTax());
            }
        }
        pageData.setRecords(rentParameterVOS);
        if ("1".equals(flag)) {
            List<Long> ids = new ArrayList<>();
            for (RentParameterVO vo : pageData.getRecords()) {
                ids.add(vo.getId());
            }
            if(CollectionUtils.isNotEmpty(ids)){
                QueryParam useRecordParam = new QueryParam();
                useRecordParam.getParams().put("equipmentId", new Parameter(QueryParam.IN, ids));
                List<UseRecordSubEntity> useRecordSubEntities = useRecordSubService.queryList(useRecordParam);
                for(RentParameterVO vo : pageData.getRecords()){
                    for(UseRecordSubEntity entity : useRecordSubEntities){
                        if(vo.getId().equals(entity.getEquipmentId())){
                            if(vo.getCumulativeWorkload() == null){
                                vo.setCumulativeWorkload(entity.getBillingWorkload());
                            }else{
                                vo.setCumulativeWorkload(vo.getCumulativeWorkload().add(entity.getBillingWorkload()));
                            }
                        }
                    }
                }
            }
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> test() throws ParseException {
        Long id = 560782506967318602L;
        String time = "2022-03-21";

        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        date = formatter.parse(time);
        return service.selectValidationNewDate(id, date, null);
    }
}
