package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentDayDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentPlanService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentMonthDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentQuantitiesDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentEquipmentPlanVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentPlanEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("rentEquipmentPlan") 
public class RentEquipmentPlanBpmServiceImpl implements ICommonBusinessService {
	 @Autowired
	 private IRentEquipmentPlanService planService;
	 @Autowired
	 private IRentDayDetailedService dayDetailedService;
	 @Autowired
	 private IRentMonthDetailedService monthDetailedService;
	 @Autowired
	 private IRentQuantitiesDetailedService quantitiesDetailedService;
	 @Autowired
	 private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("到了。。。。。。。。。。。。。。。。。。");
		RentEquipmentPlanEntity planEntity =planService.selectById(billId);
		if(CollectionUtils.isNotEmpty(planEntity.getRentEquipmentPlanSubList())){
			List<Long> batchIds = planEntity.getRentEquipmentPlanSubList().stream().map(RentEquipmentPlanSubEntity::getId).collect(Collectors.toList());
			//判断是否有日租引用
			List<RentDayDetailedEntity> dayList= this.queryRentDayList(batchIds);
			if(CollectionUtils.isNotEmpty(dayList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
			//判断是否有月租引用
			List<RentMonthDetailedEntity> monthList = this.queryRentMonthList(batchIds);
			if(CollectionUtils.isNotEmpty(monthList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
			//判断是否有工程量引用
			List<RentQuantitiesDetailedEntity> quantitiesList = this.queryRentQuantitiesList(batchIds);
			if(CollectionUtils.isNotEmpty(quantitiesList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}

			// 参数是单据类型编码字符串 根据需求是否打开下面代码
			// 如果是待采购，则不判断是否引用
			if (RentPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(planEntity.getBiddingState())) {
				return CommonResponse.success();
			}
			CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
			if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
				return CommonResponse.error("单据被引用不能撤回！");
			}
			for (Long i:batchIds){
				CommonResponse<String> resps = billTypeApi.checkQuote(billTypeCode, i);
				if (!resps.isSuccess()) {
					return CommonResponse.error("单据被引用不能撤回！");
				}
			}
		}

		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("resp。。。。。。。。。。。。。。。。。。{}{}",billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+resp.isSuccess()+"----"+resp.getMsg());


		if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
			return CommonResponse.error("单据被引用不能撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 查询日租明细是否包含
	 * @param batchIds
	 * @return
	 */
	public List<RentDayDetailedEntity> queryRentDayList(List<Long> batchIds){
		QueryWrapper<RentDayDetailedEntity> query = new QueryWrapper<RentDayDetailedEntity>();
		query.in("source_id", batchIds);
		query.eq("dr", 0);
		return dayDetailedService.list(query);
	}

	/**
	 * 查询月租明细
	 * @param batchIds
	 * @return
	 */
	public List<RentMonthDetailedEntity> queryRentMonthList(List<Long> batchIds){
		QueryWrapper<RentMonthDetailedEntity> query = new QueryWrapper<RentMonthDetailedEntity>();
		query.in("source_id", batchIds);
		query.eq("dr", 0);
		return monthDetailedService.list(query);
	}

	/**
	 * 查询工程量
	 * @param batchIds
	 * @return
	 */
	public List<RentQuantitiesDetailedEntity> queryRentQuantitiesList(List<Long> batchIds){
		QueryWrapper<RentQuantitiesDetailedEntity> query = new QueryWrapper<RentQuantitiesDetailedEntity>();
		query.in("source_id", batchIds);
		query.eq("dr", 0);
		return quantitiesDetailedService.list(query);
	}
}
