package com.ejianc.business.proequipmentcorpout.contract.controller;

import com.alibaba.fastjson.JSONObject;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/outRentContractFileUpdate/")
public class OutRentContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRentContractService contractService;

    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IOutRentContractChangeService changeService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        logger.info("@@@@@@@@@@@@@",updateData.getLong("billId"));
        OutRentContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        //contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFile(updateData.getString("fileOnlinePath"));
        //contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);
        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO(); // 签章中的合同vo
        if(contractBillTypeStr.equals(billType)){
            OutRentContractEntity contract = contractService.selectById(billId);
            Assert.notNull(contract, "查询不到主合同详情");
            cv.setContractId(contract.getId());
            cv.setContractName(contract.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(OutRentConstants.BILL_TYPE_OUT_CONTRACT);
        }
        else {
            OutRentContractChangeEntity contractChange = changeService.selectById(billId);
            cv.setContractId(contractChange.getId());
            cv.setContractName(contractChange.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(OutRentConstants.BILL_TYPE_OUT_CONTRACT_CHANGE);
        }
        cvs.add(cv);

//        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureManageApi.previewContract(billId, Arrays.asList(new String[]{SignatureStatusEnum.已签章.getCode()}));
        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("为获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if(contractBillTypeStr.equals(billType)) {
            OutRentContractEntity contract = contractService.selectById(billId);
            contract.setSignedFileId(signedFileInfo.getFileId());
            contractService.saveOrUpdate(contract, false);
        } else {
            OutRentContractChangeEntity contractChange = changeService.selectById(billId);
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            changeService.saveOrUpdate(contractChange, false);
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }

    @GetMapping(value = "getBillDataJson")
    public CommonResponse<OutRentContractVO> getBillDataJson(@RequestParam Long id) {
        logger.info("到了。。。。。。。。。。");
        OutRentContractEntity contract = contractService.selectById(id);
        OutRentContractVO vo = BeanMapper.map(contract, OutRentContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getRentDayDetailedList())) {
            vo.getRentDayDetailedList().forEach(item -> {
                item.setDayRentPriceStr(null != item.getDayRentPrice() ? priceFmt.format(item.getDayRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopRentPriceStr(null != item.getStopRentPriceStr() ? priceFmt.format(item.getStopRentPriceStr()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDayRentNotTaxPriceStr(null != item.getDayRentNotTaxPrice() ? mnyFmt.format(item.getDayRentNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setStopRentNotTaxPriceStr(null != item.getStopRentNotTaxPrice() ? priceFmt.format(item.getStopRentNotTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));

            });
        }
        if(CollectionUtils.isNotEmpty(vo.getRentMonthDetailedList())) {
            vo.getRentMonthDetailedList().forEach(item -> {
                item.setMonthRentPriceStr(null != item.getMonthRentPrice() ? priceFmt.format(item.getMonthRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopRentPriceStr(null != item.getStopRentPrice() ? priceFmt.format(item.getStopRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setMonthRentNotTaxPriceStr(null != item.getMonthRentNotTaxPrice() ? mnyFmt.format(item.getMonthRentNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setInsufficientMonthNotTaxRentPriceStr(null != item.getInsufficientMonthNotTaxRentPrice() ? priceFmt.format(item.getInsufficientMonthNotTaxRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
                item.setNotTaxStopPriceStr(null != item.getNotTaxStopPriceStr() ? priceFmt.format(item.getNotTaxStopPriceStr()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getRentQuantitiesDetailedList())) {
            vo.getRentQuantitiesDetailedList().forEach(item -> {
                item.setQuantitiesPriceStr(null != item.getQuantitiesPrice() ? priceFmt.format(item.getQuantitiesPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxQuantitiesPriceStr(null != item.getNotTaxQuantitiesPrice() ? mnyFmt.format(item.getNotTaxQuantitiesPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
            });
        }

        if(CollectionUtils.isNotEmpty(vo.getRentOtherDetailedList())) {
            vo.getRentOtherDetailedList().forEach(item -> {
                item.setPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxAmountStr(null != item.getTaxAmount() ? mnyFmt.format(item.getTaxAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxPriceStr(null != item.getNotTaxPrice() ? mnyFmt.format(item.getNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
                item.setNotTaxAmountStr(null != item.getNotTaxAmount() ? priceFmt.format(item.getNotTaxAmount()) : priceFmt.format(BigDecimal.ZERO));

            });
        }
        if(CollectionUtils.isNotEmpty(vo.getRentContractPaymentClauseList())) {
            vo.getRentContractPaymentClauseList().forEach(item -> {
                item.setPaymentRatioStr(null != item.getPaymentRatio() ? priceFmt.format(item.getPaymentRatio()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        return CommonResponse.success(vo);
    }
}
