package com.ejianc.business.proequipmentcorpout.outStore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.SignStatusEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreDetailService;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * out-出库单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outStore")
public class OutStoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EQUIP_OUT_STORE_CORP";

    @Autowired
    private IOutStoreService service;
    @Autowired
    private IOutStoreDetailService outStoreDetailService;
    @Autowired
    private IOutOrderDetailService outOrderDetailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProxyContractService proxyContractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO saveOrUpdateVO) {
        //进场即计租 校验必须大于最大单据日期
        if(Integer.valueOf("1").equals(saveOrUpdateVO.getEntranceRentFlag())) {
            service.validateTime(saveOrUpdateVO);
        }
    	OutStoreEntity entity = BeanMapper.map(saveOrUpdateVO, OutStoreEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //库存可用数量：取计租数量，根据库存的计量数量X转换系数  实时计算；如没有转换系数，显示【未设置转换系数】，如子表存在材料未设置转换系数，单据不可保存；
       /* List<OutStoreDetailEntity> delDetail  = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entity.getOutStoreDetailList())){
            List<OutStoreDetailEntity> outRmatDeliveryDetailList = entity.getOutStoreDetailList();
            delDetail = outRmatDeliveryDetailList.stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
            if(null==delDetail){
                delDetail  = new ArrayList<>();
            }

            outOrderDeliveryService.delete(delDetail,null);//订单删除回写

            boolean b = outRmatDeliveryDetailList.stream().anyMatch(e -> e.getTransScale() == null);
            if (b){
                throw new BusinessException("部分材料未设置转换系数,不能保存");
            }
        }*/
        entity.setSupplierSignStatus(SignStatusEnum.未签字.getCode());
    	//设置委托代理人id
        if(null!=entity.getProxyContractId()){
            ProxyContractEntity proxyContractEntity = proxyContractService.selectById(entity.getProxyContractId());
            if(null != proxyContractEntity) {
                entity.setProxyEmployeeId(proxyContractEntity.getProxyEmployeeId());
                entity.setProxyEmployeeName(proxyContractEntity.getProxyEmployeeName());
            }
        }
        //订单回写
        if(Integer.valueOf(0).equals(entity.getSourceType())) {
            //租赁来源为采购 回写订单
            outOrderDetailService.saveOrUpdateNum(entity.getOutStoreDetailList());
        }
        if(Integer.valueOf("0").equals(entity.getEntranceRentFlag())) {
            //非进场即计租 则清空出库单主表、子表的计租日期
            entity.setRentDate(null);
            for(OutStoreDetailEntity outStoreDetail : entity.getOutStoreDetailList()) {
                outStoreDetail.setRentDetailDate(null);
            }
        }

    	service.saveOrUpdate(entity, false);

    	OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
    	OutStoreEntity entity = service.selectById(id);
    	OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        //回写订单
        List<Long> ids = vos.stream().map(OutStoreVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<OutStoreDetailEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.in(OutStoreDetailEntity::getDeliveryId, ids);
        //只查询来源于采购订单下的设备列表
        listWrapper.eq(OutStoreDetailEntity::getSourceType, 0);
        List<OutStoreDetailEntity> outStoreDetailEntities = outStoreDetailService.list(listWrapper);
        if(CollectionUtils.isNotEmpty(outStoreDetailEntities)) {
            outOrderDetailService.deleteNum(outStoreDetailEntities);
        }
        service.removeByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutStoreEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<OutStoreVO> outStoreVOS = BeanMapper.mapList(list, OutStoreVO.class);
        if (CollectionUtils.isNotEmpty(list)) {
            outStoreVOS = BeanMapper.mapList(list, OutStoreVO.class);
            outStoreVOS.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
//                入库方式，0-收料入库，1-直入直出
                vo.setSupplierSignStatusName(((null==vo.getSupplierSignStatus() || vo.getSupplierSignStatus() == 0 )? "未签字" : "已签字"));
            });
        }

        beans.put("records", outStoreVOS);
        ExcelExport.getInstance().export("outStore-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refOutRmatDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutRmatDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                    String condition,
                                                                    String searchObject,
                                                                    String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
