package com.ejianc.business.proequipmentcorppur.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorppur.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.proequipmentcorppur.purchaseplan.mapper.PurchasePlanMapper;
import com.ejianc.business.proequipmentcorppur.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备采购-采购计划服务实现类
 *
 * @author generator
 */
@Service("purchasePlanService")
public class PurchasePlanServiceImpl extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity> implements IPurchasePlanService {
    @Autowired
    private PurchasePlanMapper mapper;

    @Override
    public void saveOrUpdates(PurchasePlanEntity entity) {

        List<PurchasePlanDetailedEntity> listbs = entity.getDetailList();
        if(CollectionUtil.isNotEmpty(listbs)) {
            Map<Long, Long> idMap = new HashMap<>();
            for (PurchasePlanDetailedEntity cdEntity : listbs) {
                //设置计划编码
                cdEntity.setPlanCode(entity.getBillCode());
                //设置剩余可申请数量
                cdEntity.setRemainingNum(cdEntity.getPlanNum());
                //初始化已申请数量
                cdEntity.setAppliedNum(0L);
                if (null == cdEntity.getParentId()) {
                    idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
                }
            }
            for (PurchasePlanDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
            }
        }
        super.saveOrUpdate(entity, false);
    }

    @Override
    public List<PurchasePlanVO> queryPlanListByOrgId(Long orgId) {
        QueryWrapper<PurchasePlanEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        List<PurchasePlanEntity> entityList = super.list(query);
        List<PurchasePlanVO> list = BeanMapper.mapList(entityList, PurchasePlanVO.class);
        return list;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    @Override
    public Boolean checkSameBillCode(PurchasePlanVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchasePlanEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchasePlanEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchasePlanEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchasePlanEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
       if (StringUtils.isEmpty(PurchasePlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<PurchasePlanEntity> entityList = (List<PurchasePlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (PurchasePlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】已采购完成！");
                    }
                    entity.setPlanState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

}
