package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentTotalPlanHistoryEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentTotalPlanHistorySubEntity;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentTotalPlanHistoryMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentTotalPlanHistoryService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentTotalPlanHistorySubService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentTotalPlanHistorySubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentTotalPlanHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 租赁设备总计划-历史记录主表
 * 
 * @author generator
 * 
 */
@Service("rentTotalPlanHistoryService")
public class RentTotalPlanHistoryServiceImpl extends BaseServiceImpl<RentTotalPlanHistoryMapper, RentTotalPlanHistoryEntity> implements IRentTotalPlanHistoryService{
    @Autowired
    private IRentTotalPlanHistorySubService rentTotalPlanHistorySubService;
    @Override
    public RentTotalPlanHistoryVO queryDetailByChangeId(Long id) {
        RentTotalPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<RentTotalPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            RentTotalPlanHistoryVO historyVo = BeanMapper.map(historyEntity, RentTotalPlanHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            List<RentTotalPlanHistorySubEntity> historyDetailEntities = rentTotalPlanHistorySubService.queryList(queryParam, false);

            if (historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<RentTotalPlanHistorySubVO> rentTotalPlanHistorySubVOS = BeanMapper.mapList(historyDetailEntities, RentTotalPlanHistorySubVO.class);
                List<RentTotalPlanHistorySubVO> rentTotalPlanHistorySubVOS1 = com.ejianc.business.proequipmentcorprent.vo.util.TreeNodeBUtil.buildTree(rentTotalPlanHistorySubVOS);
                historyVo.setRentTotalPlanHistorySubList(rentTotalPlanHistorySubVOS1);
            }
            return historyVo;
        }
        return null;
    }
}
