/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentEquipmentStart")
public class RentEquipmentStartBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220221000000003";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
    private final String OPERATE = "RENT-PROEQUIPMENT-START";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity entity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart", RequestMethod.POST, entity.getSupplierId().toString(), "RENT-PROEQUIPMENT-START", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.rentEquipmentStartService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        for (RentEquipmentStartSubEntity subEntity : subEntityList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStartDate(subEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
            parameterEntity.setUseType(1);
            if (1 == startEntity.getEntranceRentFlag()) {
                this.logger.info("\u8bbe\u7f6e\u8ba1\u79df\u65e5\u671f\uff1a" + subEntity.getTypeDate());
                parameterEntity.setMeterRentDate(subEntity.getTypeDate());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
                queryParam.getOrderMap().put("createTime", "desc");
                List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                    RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0));
                    detailEntity.setOperationDate(subEntity.getTypeDate());
                    this.rentParameterDetailService.updateById((Object)detailEntity);
                }
            } else {
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
                detailEntity.setSourceId(startEntity.getId());
                detailEntity.setOperationDate(subEntity.getTypeDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
            }
            parameterList.add(parameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
        this.rentEquipmentStartService.updateById((Object)startEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        EquipmentNewDateVO equipmentNewDateVO = this.rentParameterService.selectAbandonDate(startEntity.getContractId(), startEntity.getTypeDate());
        if (equipmentNewDateVO != null && !startEntity.getId().equals(equipmentNewDateVO.getId())) {
            return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25:\u8bf7\u5148\u5f03\u5ba1\u8bbe\u5907" + equipmentNewDateVO.getType() + "\u5355\u636e\u5728\u5f03\u5ba1\u672c\u5355\u636e"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
        ArrayList<RentParameterEntity> rentParameterEntityList = new ArrayList<RentParameterEntity>();
        if (1 == startEntity.getEntranceRentFlag()) {
            for (RentEquipmentStartSubEntity subEntity : subEntityList) {
                RentParameterEntity parameterEntity = (RentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
                parameterEntity.setStartDate(null);
                parameterEntity.setMeterRentDate(null);
                parameterEntity.setOperationDate(new Date());
                parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
                rentParameterEntityList.add(parameterEntity);
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
                queryParam.getOrderMap().put("createTime", "asc");
                List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
                if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
                RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0));
                detailEntity.setOperationDate(null);
                this.rentParameterDetailService.updateById((Object)detailEntity);
            }
            if (CollectionUtils.isNotEmpty(rentParameterEntityList)) {
                this.rentParameterService.updateBatchById(rentParameterEntityList);
            }
        } else {
            ArrayList<Long> parameterIdList = new ArrayList<Long>();
            for (RentEquipmentStartSubEntity subEntity : subEntityList) {
                parameterIdList.add(subEntity.getSourceId());
            }
            this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode(), startEntity.getId());
        }
        startEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.rentEquipmentStartService.saveOrUpdate((Object)startEntity, false);
        return CommonResponse.success();
    }
}

