/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentEquipmentStopMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.PushRentEquipmentStopSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.PushRentEquipmentStopVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="rentEquipmentStopService")
public class RentEquipmentStopServiceImpl
extends BaseServiceImpl<RentEquipmentStopMapper, RentEquipmentStopEntity>
implements IRentEquipmentStopService {
    @Autowired
    private RentEquipmentStopMapper rentEquipmentStopMapper;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private JedisPool jedisPool;
    private static final String BILL_TYPE = "BT220221000000004";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/stopUse/card";
    private final String OPERATE = "EQUIPMENT-RENT-STOP";
    private SessionManager sessionManager;

    @Override
    public RentEquipmentStopEntity selectByEquipmentStop(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"bill_state", (Object)"0");
        List list = this.rentEquipmentStopMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RentEquipmentStopEntity entity = (RentEquipmentStopEntity)((Object)list.get(0));
            return entity;
        }
        return null;
    }

    @Override
    @Transactional
    public void saveOrUpdates(RentEquipmentStopEntity entity) {
        entity.setType(2);
        RentAcceptanceEntity validaAcceptanceEntity = this.rentAcceptanceService.selectByContractId(entity.getContractId());
        if (validaAcceptanceEntity != null && !entity.getContractId().equals(validaAcceptanceEntity.getContractId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u9a8c\u6536\u5355\u636e");
        }
        RentEquipmentStartEntity vStartEntity = this.rentEquipmentStartService.selectByContractIdEquipmentStart(entity.getContractId());
        if (vStartEntity != null && vStartEntity.getContractId() != entity.getContractId()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8bbe\u5907\u542f\u7528\u5355\u636e");
        }
        RentEquipmentStopEntity stopEntity = this.selectByEquipmentStop(entity.getContractId());
        if (stopEntity != null && !stopEntity.getId().equals(entity.getId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u505c\u7528\u5355\u636e");
        }
        CommonResponse<String> commonResponse = this.rentParameterService.selectValidationNewDate(entity.getContractId(), entity.getTypeDate(), entity.getId());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        if (CollectionUtils.isNotEmpty(entity.getRentEquipmentStopSubList())) {
            EquipmentNewDateVO subDate = this.rentParameterService.selectValidationNewDateSub(entity.getContractId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (RentEquipmentStopSubEntity stopSubEntity : entity.getRentEquipmentStopSubList()) {
                if (subDate == null || stopSubEntity.getTypeDate().getTime() >= subDate.getPerformDate().getTime()) continue;
                throw new BusinessException("\u8bbe\u5907\u6e05\u5355\u65e5\u671f\u4e0d\u662f\u6700\u65b0\u65e5\u671f,\u6700\u65b0\u65e5\u671f:" + sdf.format(subDate.getPerformDate()));
            }
        }
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        RentEquipmentStopEntity entity = (RentEquipmentStopEntity)((Object)super.selectById((Serializable)id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u542f\u7528\u5355\u3002 \u8bf7\u5148\u5230\u4f9b\u5e94\u5546\u5e93\u2014\u751f\u6210\u534f\u540c\u8d26\u53f7\u518d\u8fdb\u884c\u534f\u540c\u64cd\u4f5c\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            PushRentEquipmentStopVO supplierPushCheckVO = (PushRentEquipmentStopVO)BeanMapper.map((Object)((Object)entity), PushRentEquipmentStopVO.class);
            supplierPushCheckVO.setSourceId(entity.getId());
            List pushRentEquipmentStopSubVOS = BeanMapper.mapList(entity.getRentEquipmentStopSubList(), PushRentEquipmentStopSubVO.class);
            for (PushRentEquipmentStopSubVO supplierPushCheckDetailVO : pushRentEquipmentStopSubVOS) {
                supplierPushCheckDetailVO.setSourceId(entity.getId());
                supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                supplierPushCheckDetailVO.setId(null);
            }
            supplierPushCheckVO.setEquipmentStopDetailList(pushRentEquipmentStopSubVOS);
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                return CommonResponse.error((String)("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg()));
            }
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            boolean pushResult = this.rentAcceptanceService.pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), PUSH_SAVE_URL);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            super.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proEquipments/stopUse/card", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        RentEquipmentStopEntity checkEntity = (RentEquipmentStopEntity)((Object)super.selectById((Serializable)((Object)billId)));
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220221000000004::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"EQUIPMENT-RENT-STOP", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "EQUIPMENT-RENT-STOP");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "EQUIPMENT-RENT-STOP");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

