package com.ejianc.business.proequipmentcorppur.purchaseApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.mapper.PurchaseApplyMapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 设备采购-采购申请
 *
 * @author generator
 */
@Service("purchaseApplyService")
public class PurchaseApplyServiceImpl extends BaseServiceImpl<PurchaseApplyMapper, PurchaseApplyEntity> implements IPurchaseApplyService {
    @Autowired
    private PurchaseApplyMapper mapper;

    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;

    @Autowired
    private IPurchaseApplyDetailedService purchaseApplyDetailedService;

    @Override
    public void saveOrUpdates(PurchaseApplyEntity entity) {
        List<PurchaseApplyDetailedEntity> listbs = entity.getDetailList();

        if(CollectionUtil.isNotEmpty(listbs)){
            List<Long> planSubIds = new ArrayList<>();
            StringBuilder equipmentTypes = new StringBuilder();
            Map<Long, Long> idMap = new HashMap<>();
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                planSubIds.add(cdEntity.getSourceId());
                if(!"del".equals(cdEntity.getRowState())) {
                    equipmentTypes.append(cdEntity.getEquipmentName()).append(",");
                }
                if (null == cdEntity.getParentId()) {
                    idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
                }
            }

            //查询出对应的计划子项
            PurchasePlanDetailedEntity tmp = null;
            QueryWrapper<PurchasePlanDetailedEntity> planSubQuery = new QueryWrapper<>();
            planSubQuery.in("id", planSubIds);
            List<PurchasePlanDetailedEntity> planSubList = purchasePlanDetailedService.list(planSubQuery);
            Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(PurchasePlanDetailedEntity::getId, item -> item));

            if(null != entity.getId()) {
                //单据更新
                PurchaseApplyEntity dbEntity = super.selectById(entity.getId());
                for(PurchaseApplyDetailedEntity cdEntity : dbEntity.getDetailList()) {
                    tmp =planSubMap.get(cdEntity.getSourceId());
                    tmp.setAppliedNum(tmp.getAppliedNum() - cdEntity.getPlanNum());
                    tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
                }
            }

            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
                if(!"del".equals(cdEntity.getRowState())) {
                    tmp =planSubMap.get(cdEntity.getSourceId());
                    tmp.setAppliedNum(tmp.getAppliedNum() + cdEntity.getPlanNum());
                    tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
                }
            }

            //更新计划子表
            boolean updateResult = purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
            if(!updateResult) {
                throw new BusinessException("保存失败，更新计划已申请数量失败！");
            }
            entity.setEquipmentTypes(equipmentTypes.substring(0, equipmentTypes.length()-1));
        }

        super.saveOrUpdate(entity, false);
    }

    @Override
    public List<PurchaseApplyVO> queryApplyListByOrgId(Long orgId) {
        QueryWrapper<PurchaseApplyEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        List<PurchaseApplyEntity> entities = super.list(query);
        return BeanMapper.mapList(entities, PurchaseApplyVO.class);
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    @Override
    public Boolean checkSameBillCode(PurchaseApplyVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseApplyEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseApplyEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseApplyEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseApplyEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void updateBatApplyByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(PurchasePlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<PurchaseApplyEntity> entityList = (List<PurchaseApplyEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (PurchaseApplyEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】已采购完成！");
                    }
                    entity.setPlanState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    @Override
    public void removeBatch(List<Long> applyIds) {
        QueryWrapper<PurchaseApplyDetailedEntity> detailQuery = new QueryWrapper<>();
        detailQuery.in("apply_id", applyIds);
        detailQuery.eq("dr", 0);
        List<PurchaseApplyDetailedEntity> detailList = purchaseApplyDetailedService.list(detailQuery);


        PurchasePlanDetailedEntity tmp = null;
        QueryWrapper<PurchasePlanDetailedEntity> planSubQuery = new QueryWrapper<>();
        planSubQuery.in("id", detailList.stream().map(PurchaseApplyDetailedEntity::getSourceId).collect(Collectors.toList()));
        List<PurchasePlanDetailedEntity> planSubList = purchasePlanDetailedService.list(planSubQuery);
        Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(PurchasePlanDetailedEntity::getId, item -> item));

        for(PurchaseApplyDetailedEntity detail : detailList) {
            tmp = planSubMap.get(detail.getSourceId());
            tmp.setAppliedNum(tmp.getAppliedNum() - detail.getPlanNum());
            tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
        }

        //更新计划子表
        boolean updateResult = purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
        if(!updateResult) {
            throw new BusinessException("更新计划已申请数量失败！");
        }
        super.removeByIds(applyIds, false);
    }

}
