package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.rent.mapper.RentParameterDetailMapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 租赁设备台账明细
 *
 * @author generator
 */
@Service("rentParameterDetailService")
public class RentParameterDetailServiceImpl extends BaseServiceImpl<RentParameterDetailMapper,
        RentParameterDetailEntity> implements IRentParameterDetailService {

    /**
     * 根据sourceId,sourceType删除明细
     *
     * @param sourceId   来源id
     * @param sourceType 来源类型
     */
    @Override
    public void delParameterDetail(Long sourceId, String sourceType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.EQ, sourceType));
        List<RentParameterDetailEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            super.removeByIds(list.stream().map(RentParameterDetailEntity::getId).collect(Collectors.toList()));
        }
    }

    /**
     * 查询上次租金自动计算日期
     *
     * @param parameterIdList 设备台账列表
     * @return 上次租金计算日期
     */
    @Override
    public Date getMaxOperationDate(List<Long> parameterIdList) {
        if (CollectionUtils.isNotEmpty(parameterIdList)) {
            String parameterIds = StringUtils.join(",", parameterIdList);
            return baseMapper.getMaxOperationDate(parameterIds);
        }
        return null;
    }
}
