package com.ejianc.business.proequipmentcorpout.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderDetailEntity;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.mapper.OutOrderMapper;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.CommonConstant;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreDetailService;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁订单
 *
 * @author generator
 *
 */
@Service("outOrderService")
public class OutOrderServiceImpl extends BaseServiceImpl<OutOrderMapper, OutOrderEntity> implements IOutOrderService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutOrderDetailService detailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    /*TODO 待修改*/
    @Autowired
    private IOutRentContractService outContractService;
    @Autowired
    private IOutStoreDetailService outStoreDetailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IRentReceiptsApi receiptsApi;



    private final String FILE_TYPE = "outOrder";


    private static final String OPERATE = "ORDER_BILL_SYNC";
    private static final String BILL_TYPE = "EJCBT202210000055";
    private static final String BILL_NAME = "租出订单";

    /**
     * 保存施工方推送的订单数据
     * @return 保存结果
     */
    @Override
    public void saveOrder(OutOrderVO saveOrUpdateVO) {
        logger.info("进入订单保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", saveOrUpdateVO);
        for (OutOrderDetailVO outOrderDetailVO : saveOrUpdateVO.getOutOrderDetailList()) {
            outOrderDetailVO.setUnitName(outOrderDetailVO.getUnit());
        }
        OutOrderEntity entity = BeanMapper.map(saveOrUpdateVO, OutOrderEntity.class);
        if (CollectionUtils.isEmpty(entity.getOutOrderDetailList())) {
            throw new BusinessException("明细列表不能为空！");
        }
        OutOrderEntity orderEntity = super.selectById(saveOrUpdateVO.getId());
        // 同一个订单重复推送，则是抛出异常
        if (null != orderEntity) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(orderEntity));
        }
        entity.setOrderFlag(CommonConstant.ORDER_FlAG_NO);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveState(CommonConstant.ORDER_RECEIVE_WAIT);
        // 处理附件
        CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(saveOrUpdateVO.getId().toString(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(),
                saveOrUpdateVO.getId().toString(), BILL_TYPE, FILE_TYPE);
        if (!copyContractFileResp.isSuccess()) {
            logger.info("同步附件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    , saveOrUpdateVO.getId(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId(), BILL_TYPE, FILE_TYPE, copyContractFileResp.getMsg());
            logger.info("同步附件失败，错误信息：" + copyContractFileResp.getMsg());
        }

        OutRentContractEntity outContractEntity = outContractService.selectById(entity.getContractId());
        if(null==outContractEntity){
            throw new BusinessException("查询合同失败！");
        }
        List<Long> collect = entity.getOutOrderDetailList().stream().map(item -> item.getEquipmentId()).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(collect)) {
            CommonResponse<List<EquipmentVO>> listCommonResponse = shareEquipmentApi.queryEquipmentItemByIds(collect);
            if(!listCommonResponse.isSuccess()){
                throw new BusinessException("查询设备档案失败！");
            }
            Map<Long, EquipmentVO> data = listCommonResponse.getData().stream().collect(Collectors.toMap(EquipmentVO::getId, Function.identity(), (v1, v2) -> v2));
            for (OutOrderDetailEntity outRmatOrderDetailEntity : entity.getOutOrderDetailList()) {
                if(data.containsKey(outRmatOrderDetailEntity.getEquipmentId())){
                    outRmatOrderDetailEntity.setUnitMId(data.get(outRmatOrderDetailEntity.getEquipmentId()).getUnitId());
                    outRmatOrderDetailEntity.setUnitMName(data.get(outRmatOrderDetailEntity.getEquipmentId()).getUnitName());
                }
            }
        }
        entity.setRentHarborType(outContractEntity.getRentHarborType());
        entity.setRentOrgId(outContractEntity.getRentOrgId());
        entity.setRentOrgCode(outContractEntity.getRentOrgCode());
        entity.setRentOrgName(outContractEntity.getRentOrgName());
        entity.setRentProjectAddr(outContractEntity.getRentProjectAddr());
        entity.setRentProjectCode(outContractEntity.getRentProjectCode());
        entity.setRentProjectId(outContractEntity.getRentProjectId());
        entity.setRentProjectName(outContractEntity.getRentProjectName());
        entity.setRentProjectType(outContractEntity.getRentProjectType());
        entity.setOutOrgId(outContractEntity.getOutOrgId());
        entity.setOutOrgCode(outContractEntity.getOutOrgCode());
        entity.setOutOrgName(outContractEntity.getOutOrgName());
        boolean flag = super.saveOrUpdate(entity, false);
        if(!flag){
            throw new BusinessException("保存失败！");
        }
        logger.info("保存成功，订单保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    /**
     * 施工方撤回时删除订单
     *
     * @param vo 需要删除的订单
     * @return 删除结果
     */
    @Override
    public void deleteOrder(OutOrderVO vo) {
        logger.info("进入施工方撤回订单接口>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (null == vo.getId()) {
            throw new BusinessException("订单信息不存在");
        }
        OutOrderEntity orderEntity = super.selectById(vo.getId());
        if (null == orderEntity) {
            throw new BusinessException("订单信息不存在");
        }
        if (!CommonConstant.ORDER_RECEIVE_WAIT.equals(orderEntity.getReceiveState())) {
            throw new BusinessException("订单已被处理，无法删除！");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(orderEntity.getId(), BILL_TYPE, FILE_TYPE, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = baseMapper.deleteOrder(vo.getId()) && detailService.deleteOrderDetailByOrderId(vo.getId());
        if(!flag){
            throw new BusinessException("删除失败！");
        }
        logger.info("施工方撤回订单成功<<<<<<<<<<<<<<<<<<<<<<<");
    }

    /**
     * 施工方关闭订单
     *
     * @param vo 需要关闭订单
     * @return 关闭订单
     */
    @Override
    public String updateOrderCloseFlag(OutOrderVO vo) {
        logger.info("进入施工方关闭订单接口>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (null == vo.getId()) {
            throw new BusinessException("订单信息不存在");
        }
        OutOrderEntity orderEntity = super.selectById(vo.getId());
        if (CommonConstant.ORDER_FlAG_YES.equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("订单已被关闭！");
        }
        StringBuilder errorBillCode = new StringBuilder();
        // 查询是否存在未生效的送货单
//         查询是否存在审批未通过或审批通过待验收的送货单，
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, orderEntity.getId()));
        List<OutStoreDetailEntity> orderDeliveryEntities = outStoreDetailService.queryList(queryParam);
        Map<Long, List<OutStoreDetailEntity >> collect = orderDeliveryEntities.stream().collect(Collectors.groupingBy(OutStoreDetailEntity::getDeliveryId));
        if(MapUtils.isNotEmpty(collect)){
            Set<Long> longs = collect.keySet();
            List<Integer> integers = new ArrayList<>();
            integers.add(1);
            integers.add(3);
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter(QueryParam.IN, longs));
            param.getParams().put("billState", new Parameter(QueryParam.NE,integers));
            List<OutStoreEntity> outDeliveryEntities = outStoreService.queryList(param);
            if(CollectionUtils.isNotEmpty(outDeliveryEntities)){
                errorBillCode.append("发货单[");
                logger.error("存在未生效的送货单，送货单信息：{}", JSONObject.toJSONString(outDeliveryEntities));
                for (OutStoreEntity outDeliveryEntity : outDeliveryEntities) {
                    errorBillCode.append(outDeliveryEntity.getBillCode()).append(",");
                }
                errorBillCode.delete(errorBillCode.length() - 1,errorBillCode.length());
                errorBillCode.append("]还未完成验收或关闭，不能关闭订单");
                throw new BusinessException(errorBillCode.toString());
            }
        }
        // 校验都通过，则修改为已关闭
        orderEntity.setOrderFlag(CommonConstant.ORDER_FlAG_YES);
        boolean b = super.saveOrUpdate(orderEntity, false);
        if(!b){
            throw new BusinessException("订单关闭异常！");
        }
        logger.info("施工方关闭订单成功>>>>>>>>>>>>>>>>>>>");
        return errorBillCode.toString();
    }



    /**
     * 接收、拒收订单
     *
     * @param saveOrUpdateVO 订单详情
     * @return 保存结果
     */
    @Override
    public OutOrderVO saveOrUpdate(OutOrderVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("订单信息不存在");
        }
        if (saveOrUpdateVO.getReceiveState() == null
                || CommonConstant.ORDER_RECEIVE_STATE.get(saveOrUpdateVO.getReceiveState()) == null) {
            throw new BusinessException("接收类型不正确");
        }
        // 重新查询订单数据，页面上只需要传入少量数据即可
        OutOrderEntity entity = super.selectById(saveOrUpdateVO.getId());
        entity.setSupOperatorName(saveOrUpdateVO.getSupOperatorName());
        entity.setSupOperateTime(saveOrUpdateVO.getSupOperateTime());
        entity.setSupOperatorPhone(saveOrUpdateVO.getSupOperatorPhone());
        entity.setSupOperatorUserCode(saveOrUpdateVO.getSupOperatorUserCode());
        entity.setReceiveReason(saveOrUpdateVO.getReceiveReason()); // 不予接收原因
        entity.setReceiveState(saveOrUpdateVO.getReceiveState());
        // 如果不是不予接收，则清单列表不能为空
        if (!CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState())
                && CollectionUtils.isEmpty(saveOrUpdateVO.getOutOrderDetailList())) {
            throw new BusinessException("清单列表不能为空！");
        }
        // 页面上传入的接收数量
        Map<Long, BigDecimal> voReceiveMap = new HashMap<>();
        for (OutOrderDetailVO detailVO : saveOrUpdateVO.getOutOrderDetailList()) {
            voReceiveMap.put(detailVO.getId(),detailVO.getReceiveNumsSum());
        }
        // 对材料清单进行处理，赋默认值
        if (CollectionUtils.isNotEmpty(entity.getOutOrderDetailList())) {
            for (OutOrderDetailEntity detail : entity.getOutOrderDetailList()) {
                // 全部接收，接收数量等于订单数量
                if (CommonConstant.ORDER_RECEIVE_ALL.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(detail.getOrderNumsSum());
                }
                // 部分接收，接收数量取传入的接收数量
                else if (CommonConstant.ORDER_RECEIVE_PART.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(ComputeUtil.safeAdd(voReceiveMap.get(detail.getId()),BigDecimal.ZERO));
                }
                // 不予接收默认值0
                else if (CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(BigDecimal.ZERO);
                }
                // 未发货数量等于接收数量
                detail.setNotDeliveredNumsSum(detail.getReceiveNumsSum());
                // 发货数量等于0
                detail.setDeliverNumsSum(BigDecimal.ZERO);
            }
            entity.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
        }

        // 通知项目方订单接收状态
        logger.info("开始通知施工方订单信息>>>>>>>>>>>>>>>>>>>");
        OutOrderVO vo = new OutOrderVO();
        vo.setId(entity.getId());
        vo.setReceiveState(entity.getReceiveState());
        List<OutOrderDetailVO> detailList = new ArrayList<>();
        for (OutOrderDetailEntity detail : entity.getOutOrderDetailList()) {
            OutOrderDetailVO detailVO = new OutOrderDetailVO();
            detailVO.setId(detail.getId());
            detailVO.setOrderId(detail.getOrderId());
            detailVO.setReceiveNumsSum(detail.getReceiveNumsSum());
            detailList.add(detailVO);
        }
        vo.setOutOrderDetailList(BeanMapper.mapList(detailList,OutOrderDetailVO.class));
        vo.setRentOrderDetailList(BeanMapper.mapList(detailList,OutOrderDetailVO.class));
        logger.info("推送数据："+JSONObject.toJSONString(vo));
        CommonResponse<String> response = receiptsApi.receiptsSync(JSONObject.parseObject(JSONObject.toJSONString(vo)), RentReceiptsEnum.租赁订单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        logger.info("通知施工方订单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        super.saveOrUpdate(entity, false);
        OutOrderVO orderVO = BeanMapper.map(entity, OutOrderVO.class);
        return orderVO;
    }
}
