/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractAsyncService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentDayDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentMonthDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentOtherDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentQuantitiesDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractEquipmentAllVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentDayDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentMonthDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentOtherDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentQuantitiesDetailedVO;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRentContract"})
public class OutRentContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITenderSubApi tenderApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    int unOccupyState = 0;
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private final String ENTITY_REF_CODE = "rent-contract";
    private static final String BILL_CODE = "RENT_CONTRACT";
    @Autowired
    private IOutRentContractService service;
    @Autowired
    private IOutRentContractChangeService rentContractChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IOutRentDayDetailedService rentDayDetailedService;
    @Autowired
    private IOutRentMonthDetailedService rentMonthDetailedService;
    @Autowired
    private IOutRentQuantitiesDetailedService rentQuantitiesDetailedService;
    @Autowired
    private IOutRentOtherDetailedService rentOtherDetailedService;
    @Autowired
    private IOutRentContractAsyncService outRentContractAsyncService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentContractVO> saveOrUpdate(@RequestBody OutRentContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return this.service.saveOrUpdate(saveOrUpdateVO, authority, false);
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return CommonResponse.success((String)"\u8bbe\u5907\u516c\u53f8\u79df\u5165\u79df\u8d41\u5408\u540c\u6ca1\u6709\u76ee\u6807\u6210\u672c");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentContractVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRentContractVO contractVO : vos) {
                OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.service.selectById(contractVO.getId()));
                if (contractEntity.getId() != null && contractEntity.getTargetResultId() != null) {
                    this.service.updateTargetResult(contractEntity, 1);
                }
                if (!OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_IN.equals(contractEntity.getRentType()) || contractEntity.getProxyContractId() == null) continue;
                this.service.updateProxyContract(contractEntity.getProxyContractId(), 1);
            }
        }
        this.service.removeByIds(vos.stream().map(OutRentContractVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OutRentContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        HashMap beans = new HashMap();
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(vo -> {
                if (StringUtils.isBlank((String)vo.getContractPerformanceState().toString())) {
                    vo.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    vo.setContractPerformanceState(PerformanceStatusEnum.getEnumByCode(vo.getContractPerformanceState().toString()).getDescription());
                }
                if (StringUtils.isBlank((String)vo.getSignatureState())) {
                    vo.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    vo.setSignatureState(SignatureStatusEnum.getEnumByCode(vo.getSignatureState()).getDescription());
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("outRentContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentContractVO>> refRentContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("contractPerformanceState", new Parameter("eq", (Object)"2"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        Long orgId = null;
        Integer rentHarborType = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
            rentHarborType = _con.getInteger("rentHarborType");
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (rentHarborType != null) {
            param.getParams().put("rentHarborType", new Parameter("eq", (Object)rentHarborType));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        String valueData = this.service.getContractFilingCode();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if ("1".equals(valueData)) {
                if (_con.containsKey((Object)"filingType") && "1".equals(_con.getString("filingType"))) {
                    param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
                }
            } else if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
            }
        } else if ("2".equals(valueData)) {
            param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), OutRentContractVO.class);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (OutRentContractVO vo : voList) {
                vo.setRentHarborTypeName(OutRentConstants.getOutContractRentHarborTypeMap(vo.getRentHarborType()));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentContractVO> saveOrUpdateSupplement(@RequestBody OutRentContractVO OutRentContractVO2, HttpServletRequest req) {
        if (OutRentContractVO2.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String authority = req.getHeader("authority");
        OutRentContractVO vo = this.service.saveOrUpdateSupplement(OutRentContractVO2, authority);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)vo);
    }

    @RequestMapping(value={"/updateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentContractVO> updateContract() {
        String s = "567266021388451898,567268093148135439,568013122045083682,568015335932952669,568373325273890852,568375174412501068,568382439739752524,568385701528338455,568387464750825535,568390102187901012,568391150323499097,568399777797111902,568446820783620134,568458653338828873,568460486820102239,568461300997423160,568462913203994692,568464873323888736,568465871354331171,568466737016733707,568467681741766741,568469048673828890,568469806626504749,568470954875944998,568761557476048988,568801254365593676,568805433700122688,568831024637804572,568844426219225121,569106882380300326,569111737501089853,569121279815319561,569545615197995061,569546961527635976,569548461075202140,569549410237808733,569557806982758467,569560431589457976,569850928962863185,569851746831171614,572384553180729389,573065421977161815,1519211246524104706,1519317550792572930,1519319308713459714,1519321190655721474,1520223664933257217,1520228207783919617,1520231010019393537,1520285716301299713,1520289874995658754,1520291134058610689,1522460613341429761,567023290854539336,567028014022524986";
        List<String> list1 = Arrays.asList(s.split(","));
        for (String ss : list1) {
            Long id = Long.parseLong(ss);
            OutRentContractEntity OutRentContractEntity2 = (OutRentContractEntity)((Object)this.service.selectById(id));
            OutRentContractVO map = (OutRentContractVO)BeanMapper.map((Object)((Object)OutRentContractEntity2), OutRentContractVO.class);
            this.service.pushContract(map);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/pushContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentContractVO> pushContract(@RequestParam Long id) {
        OutRentContractEntity OutRentContractEntity2 = (OutRentContractEntity)((Object)this.service.selectById(id));
        OutRentContractVO map = (OutRentContractVO)BeanMapper.map((Object)((Object)OutRentContractEntity2), OutRentContractVO.class);
        this.service.pushContract(map);
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f");
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentContractVO> addConvertByConId(Long contractId) {
        OutRentContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            boolean filingFlag = this.service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error((String)"\u5408\u540c\u672a\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
            }
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        OutRentContractEntity OutRentContractEntity2 = (OutRentContractEntity)((Object)this.service.selectById(id));
        if (OutRentContractEntity2 != null) {
            OutRentContractEntity2.setContractPerformanceState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            OutRentContractEntity2.setSignatureState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            OutRentContractEntity2.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)OutRentContractEntity2);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentContractVO> querySupplementRecord(Long id) {
        OutRentContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refRentContractEquipmentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentContractEquipmentAllVO>> refRentContractEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        Long contractId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (contractId = (_con = JSONObject.parseObject((String)condition)).getLong("contractId")) == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (contractId != null) {
            param.put("contractId", contractId);
        }
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if (queryParam.getOrderMap().get("createTime") != null) {
            param.put("createTime", queryParam.getOrderMap().get("createTime"));
        }
        if (param.get("pageIndex") != null) {
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            param.put("searchText", queryParam.getSearchText());
        }
        IPage<OutRentContractEquipmentAllVO> page = this.service.queryEquipmentSubList(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List OutRentContractEquipmentAllVOS = BeanMapper.mapList((Iterable)page.getRecords(), OutRentContractEquipmentAllVO.class);
        pageData.setRecords(OutRentContractEquipmentAllVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRentContractVO>> queryListAll(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractType());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractType(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)"EJCBT202210000058");
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @ApiOperation(value="\u65e5\u79df\u660e\u7ec6\u53c2\u7167")
    @RequestMapping(value={"/refRentContractDayDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentDayDetailedVO>> refRentContractDayDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("dayFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("pid", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.rentDayDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), OutRentDayDetailedVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutRentDayDetailedVO vo : list) {
                vo.setMeterRentTypeName("\u65e5\u79df");
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6708\u79df\u660e\u7ec6\u53c2\u7167")
    @RequestMapping(value={"/refRentContractMonthDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentMonthDetailedVO>> refRentContractMonthDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("monthFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("pid", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.rentMonthDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), OutRentMonthDetailedVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutRentMonthDetailedVO vo : list) {
                vo.setMeterRentTypeName("\u6708\u79df");
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5de5\u7a0b\u91cf\u79df\u660e\u7ec6\u53c2\u7167")
    @RequestMapping(value={"/refRentContractQuantitiesDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentQuantitiesDetailedVO>> refRentContractQuantitiesDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("quantitiesFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("pid", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.rentQuantitiesDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), OutRentQuantitiesDetailedVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutRentQuantitiesDetailedVO vo : list) {
                vo.setMeterRentTypeName("\u5de5\u7a0b\u91cf\u79df");
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5176\u4ed6\u8d39\u7528\u660e\u7ec6\u53c2\u7167")
    @RequestMapping(value={"/refRentContractOtherDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentOtherDetailedVO>> refRentContractOtherDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("pid", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.rentOtherDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), OutRentOtherDetailedVO.class);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billType", required=false) String billType, @RequestParam(value="billId", required=false) Long billId, @RequestParam(value="type", required=false) String type) {
        String msg = this.service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody OutRentContractVO contractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)new ParamsCheckVO());
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        Object c = null;
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)new ParamsCheckVO());
    }

    @RequestMapping(value={"/queryPaymentApplyList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = this.service.queryPaymentApplyList(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/asyncWatermarkById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> asyncWatermarkById(@RequestParam(value="id") Long id) {
        this.outRentContractAsyncService.asyncWatermarkById(id);
        return CommonResponse.success((String)"\u6c34\u5370\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkContractFiling"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = this.service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u65e0\u6cd5\u65b0\u589e");
    }
}

