/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outStore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.SignStatusEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreDetailService;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outStore"})
public class OutStoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "EQUIP_OUT_STORE_CORP";
    @Autowired
    private IOutStoreService service;
    @Autowired
    private IOutStoreDetailService outStoreDetailService;
    @Autowired
    private IOutOrderDetailService outOrderDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProxyContractService proxyContractService;
    @Autowired
    private IOutRentParameterService outRentParameterService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO saveOrUpdateVO) {
        Object proxyContractEntity;
        OutStoreEntity entity;
        if (Integer.valueOf("1").equals(saveOrUpdateVO.getEntranceRentFlag())) {
            this.service.validateTime(saveOrUpdateVO);
        }
        if ((entity = (OutStoreEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutStoreEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ArrayList<String> equipFactoryCode = new ArrayList<String>();
        ArrayList<Long> detailIds = new ArrayList<Long>();
        ArrayList<Long> storeEquipIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getOutStoreDetailList())) {
            List<OutStoreDetailEntity> repeatStoreList;
            List repeatList;
            for (OutStoreDetailVO detail : saveOrUpdateVO.getOutStoreDetailList()) {
                if ("del".equals(detail.getRowState())) continue;
                if (equipFactoryCode.contains(detail.getEquipLeaveFactoryCode())) {
                    return CommonResponse.error((String)"\u8bbe\u5907\u51fa\u5382\u7f16\u7801\u91cd\u590d\uff01");
                }
                equipFactoryCode.add(detail.getEquipLeaveFactoryCode());
                if (null != detail.getId()) {
                    detailIds.add(detail.getId());
                }
                if (null == detail.getStoreEquipId()) continue;
                if (storeEquipIds.contains(detail.getStoreEquipId())) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u51fa\u5e93\u8bbe\u5907\u5217\u8868\u5173\u8054\u4e86\u91cd\u590d\u7684\u4ed3\u5e93\u8bbe\u5907\uff01");
                }
                storeEquipIds.add(detail.getStoreEquipId());
            }
            QueryWrapper detailQuery = new QueryWrapper();
            detailQuery.in((Object)"equip_leave_factory_code", equipFactoryCode);
            detailQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            detailQuery.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            if (CollectionUtils.isNotEmpty(detailIds)) {
                detailQuery.notIn((Object)"id", detailIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)(repeatList = this.outStoreDetailService.list((Wrapper)detailQuery)))) {
                String repeatCode = repeatList.stream().map(OutStoreDetailEntity::getEquipLeaveFactoryCode).collect(Collectors.joining(","));
                return CommonResponse.error((String)("\u8bbe\u5907\u51fa\u5382\u7f16\u7801\u3010" + repeatCode + "\u3011\u91cd\u590d"));
            }
            QueryWrapper outPQuery = new QueryWrapper();
            outPQuery.in((Object)"factory_code", equipFactoryCode);
            outPQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            outPQuery.in((Object)"equipment_state", (Object[])new Integer[]{2, 3, 5, 6});
            outPQuery.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List outPRepeatList = this.outRentParameterService.list((Wrapper)outPQuery);
            if (CollectionUtils.isNotEmpty((Collection)outPRepeatList)) {
                String repeatCode = outPRepeatList.stream().map(OutRentParameterEntity::getFactoryCode).collect(Collectors.joining(","));
                return CommonResponse.error((String)("\u8bbe\u5907\u51fa\u5382\u7f16\u7801\u3010" + repeatCode + "\u3011\u91cd\u590d\uff0c\u8bbe\u5907\u51fa\u5e93\u53f0\u5e10\u4e2d\u5df2\u5b58\u5728"));
            }
            if (CollectionUtils.isNotEmpty(storeEquipIds) && CollectionUtils.isNotEmpty(repeatStoreList = this.outStoreDetailService.queryRepeatList(storeEquipIds, saveOrUpdateVO.getId()))) {
                String repeatStoreEquipFactoryCodes = repeatStoreList.stream().map(OutStoreDetailEntity::getStoreEquipCode).collect(Collectors.joining(","));
                return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u6709\u51fa\u5e93\u5355\u5173\u8054\u4e86\u51fa\u5382\u7f16\u7801\u4e3a\u3010" + repeatStoreEquipFactoryCodes + "\u3011\u7684\u4ed3\u5e93\u8bbe\u5907"));
            }
        }
        entity.setSupplierSignStatus(SignStatusEnum.\u672a\u7b7e\u5b57.getCode());
        if (null != entity.getProxyContractId() && null != (proxyContractEntity = (ProxyContractEntity)((Object)this.proxyContractService.selectById(entity.getProxyContractId())))) {
            entity.setProxyEmployeeId(((ProxyContractEntity)((Object)proxyContractEntity)).getProxyEmployeeId());
            entity.setProxyEmployeeName(((ProxyContractEntity)((Object)proxyContractEntity)).getProxyEmployeeName());
        }
        if (Integer.valueOf(0).equals(entity.getSourceType())) {
            this.outOrderDetailService.saveOrUpdateNum(entity.getOutStoreDetailList());
        }
        if (Integer.valueOf("0").equals(entity.getEntranceRentFlag())) {
            entity.setRentDate(null);
            for (OutStoreDetailEntity outStoreDetail : entity.getOutStoreDetailList()) {
                outStoreDetail.setRentDetailDate(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(id));
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.in(OutStoreDetailEntity::getDeliveryId, ids);
        listWrapper.eq(OutStoreDetailEntity::getSourceType, (Object)0);
        List outStoreDetailEntities = this.outStoreDetailService.list((Wrapper)listWrapper);
        if (CollectionUtils.isNotEmpty((Collection)outStoreDetailEntities)) {
            this.outOrderDetailService.deleteNum(outStoreDetailEntities);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else if (((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List outStoreVOS = BeanMapper.mapList((Iterable)list, OutStoreVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            outStoreVOS = BeanMapper.mapList((Iterable)list, OutStoreVO.class);
            outStoreVOS.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setSupplierSignStatusName(null == vo.getSupplierSignStatus() || vo.getSupplierSignStatus() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57");
            });
        }
        beans.put("records", outStoreVOS);
        ExcelExport.getInstance().export("outStore-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutRmatDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutRmatDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

