/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outrent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentSettlementEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettleRecordVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettlementVO;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentRentalVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRentSettlement"})
@Api(value="\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u4e3b\u8868", tags={"\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u4e3b\u8868"})
public class OutRentSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RENT_SETTLE";
    @Autowired
    private IOutRentSettlementService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/equipmentRent/card";
    private final String billTypeCode = "EJCBT202204000006";

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u5355\u636e\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u5206\u4eab\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("EJCBT202204000006");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"EJCBT202204000006", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushResult);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "EJCBT202204000006", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proEquipments/equipmentRent/card", null);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentSettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutRentSettlementVO saveOrUpdateVO) {
        OutRentSettlementVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentSettlementVO> queryDetail(@RequestParam Long id) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(id));
        OutRentSettlementVO vo = (OutRentSettlementVO)BeanMapper.map((Object)((Object)entity), OutRentSettlementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u79df\u91d1\u5355\u636e")
    @RequestMapping(value={"/queryRental"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentRentalVO>> queryRental(@RequestParam Long contractId, @RequestParam(value="settleDate") String settleDate) {
        List<RentRentalEntity> rentalEntityList = this.service.queryRental(contractId, settleDate);
        List voList = BeanMapper.mapList(rentalEntityList, RentRentalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u79df\u91d1\u6570\u636e\u6210\u529f\uff01", (Object)voList);
    }

    @ApiOperation(value="\u540c\u6b65\u7ed3\u7b97\u6c60\u63a5\u53e3")
    @RequestMapping(value={"/syncSettle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(id));
        boolean pool = this.service.pushSettleToPool((OutRentSettlementVO)BeanMapper.map((Object)((Object)entity), OutRentSettlementVO.class));
        if (!pool) {
            throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentSettlementVO> pushCost(@RequestBody OutRentSettlementVO vo) {
        return this.service.pushCost(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u8fd1\u4e00\u6b21\u7ed3\u7b97\u65e5\u671f\u548c\u7ed3\u7b97\u91d1\u989d\u3001\u7ed3\u7b97\u6b21\u6570")
    @RequestMapping(value={"/getDateMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return this.service.getDateMny(contractId);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentSettlementVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRentSettlementVO outRentSettlementVO : vos) {
            }
        }
        this.service.delete(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRentSettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else if (((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<OutRentSettlementVO> settlementVOS = new ArrayList<OutRentSettlementVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutRentSettlementEntity entity : list) {
                OutRentSettlementVO map = (OutRentSettlementVO)BeanMapper.map((Object)((Object)entity), OutRentSettlementVO.class);
                switch (entity.getRentHarborType()) {
                    case 0: {
                        map.setRentHarborTypeName("\u5916\u79df");
                        break;
                    }
                    case 1: {
                        map.setRentHarborTypeName("\u5185\u79df");
                    }
                }
                switch (entity.getSettlementType()) {
                    case 0: {
                        map.setSettlementTypeName("\u8fc7\u7a0b");
                        break;
                    }
                    case 1: {
                        map.setSettlementTypeName("\u6700\u7ec8");
                    }
                }
                switch (entity.getSignStatus()) {
                    case 0: {
                        map.setSignStatusName("\u672a\u7b7e\u5b57");
                        break;
                    }
                    case 1: {
                        map.setSignStatusName("\u5df2\u7b7e\u5b57");
                    }
                }
                switch (entity.getBillState()) {
                    case 0: {
                        map.setBillStateName("\u81ea\u7531\u6001");
                        break;
                    }
                    case 1: {
                        map.setBillStateName("\u5df2\u63d0\u4ea4");
                        break;
                    }
                    case 2: {
                        map.setBillStateName("\u5ba1\u6279\u4e2d");
                        break;
                    }
                    case 3: {
                        map.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                        break;
                    }
                    case 4: {
                        map.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                        break;
                    }
                    case 5: {
                        map.setBillStateName("\u5ba1\u6279\u4e2d");
                    }
                }
                settlementVOS.add(map);
            }
        }
        HashMap<String, ArrayList<OutRentSettlementVO>> beans = new HashMap<String, ArrayList<OutRentSettlementVO>>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("OutRentSettlement-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refRentSettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentSettlementVO>> refRentSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OutRentSettlementVO rentSettlementVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(rentSettlementVO));
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return this.service.pushTargetCost(id);
    }

    @GetMapping(value={"/queryDetailRecord"})
    @ResponseBody
    public CommonResponse<OutRentSettleRecordVO> queryDetailRecord(Long id) {
        OutRentSettleRecordVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

