/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractClauseEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractDetailEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractOtherCostEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractPaymentEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractRelieveEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.mapper.ContractMapper;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractDetailService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractRelieveService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.utils.TreeNodeBUtil;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractDetailVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractRelieveVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.proequipmentcorprent.rent.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractRelieveService contractRelieveService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    private static final String BILL_CODE = "AC_MDGP";
    private static final String BILL_CODE_YNJT = "AC_MDGP_YNJT01";
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private ITenderSubApi tenderApi;
    int unOccupyState = 0;
    int occupyState = 1;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    private static final String GenerateSourceType = "ACQT10086";
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-w9M68894";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority) {
        ContractEntity contract;
        CommonResponse orgResponse;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), ContractEntity.class));
        if (entity.getOrgId() != null && (StringUtils.isEmpty((CharSequence)entity.getOrgCode()) || StringUtils.isEmpty((CharSequence)entity.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(entity.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            entity.setOrgCode(orgVO.getCode());
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    entity.setParentOrgId(parentOrgVO.getId());
                    entity.setParentOrgCode(parentOrgVO.getCode());
                    entity.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                entity.setParentOrgId(entity.getOrgId());
                entity.setParentOrgCode(entity.getOrgCode());
                entity.setParentOrgName(entity.getOrgName());
            }
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            entity.setFilingRef(0);
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
            this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
        } else {
            Object oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(((ContractEntity)((Object)oldContractEntity)).getTargetResultId())) {
                this.tenderApi.updateById(((ContractEntity)((Object)oldContractEntity)).getTargetResultId(), Integer.valueOf(this.unOccupyState));
                this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
            }
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(((ContractEntity)((Object)oldContractEntity)).getBillCode());
            }
        }
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            switch (this.GenerateBillCodeType) {
                case "common": {
                    CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                    if (!billCode.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setBillCode((String)billCode.getData());
                    break;
                }
                case "ynjt": {
                    CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                    if (!billCodeFirstPart.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(Integer.valueOf(4));
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                    commonSNVO.setSourceType(GenerateSourceType);
                    CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setBillCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                }
            }
        } else if (this.checkSameBillCode((ContractVO)((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class))).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        this.resetPid(entity.getDetailList());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        super.saveOrUpdate((Object)entity, false);
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/otherSubList/card?id=" + entity.getId() + "&cardType=otherSubDirectCard";
        ExecutionVO executionVO = this.service.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class)), linkUrl, entity.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return this.queryDetail(entity.getId());
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
    }

    @Override
    public ContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        ContractVO contractVO = (ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree(contractVO.getDetailList()));
        }
        return contractVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        contractVO.setSupplementNum(supplementEntities.size());
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        } else {
            contractVO.setEditFlag(false);
        }
        return contractVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)((Object)vo), (Object)data);
            data.setSourceType(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setContractPropertyName(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyName());
            data.setPcCardUrl("/ejc-proequipment-frontend/#/otherSubList/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=otherSubDirectCard&performanceStatus=" + vo.getPerformanceStatus());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (ContractVO contractVO2 : vos) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)), "", contractEntity.getContractType());
                totalExecutionVOList.add(executionVO.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        vos.forEach(contractVO -> {
            ContractEntity contractEntity = (ContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse tender = this.tenderApi.updateById(contractEntity.getTargetResultId(), Integer.valueOf(this.unOccupyState));
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        });
        this.service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        List supplementList = this.service.queryList(param, false);
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            contractVO.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVO.getId() == null) {
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), ContractEntity.class));
            this.clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(contractVO.getBillCode());
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());
            entity.setDraftType(contractVO.getDraftType());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), ContractPaymentEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), ContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        this.resetPid(entity.getDetailList());
        entity.setFilingRef(0);
        this.service.saveOrUpdate((Object)entity, false);
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/otherSubList/supplementCard?id=" + entity.getId();
        ExecutionVO executionVO = this.service.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class)), linkUrl, entity.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return this.queryDetail(entity.getId());
    }

    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = this.service.saveOrUpdate((Object)contractEntity, false);
        if (!deleteContractFileResult.booleanValue()) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        if (contractVO.getId() == null) {
            totalVO.setSourceId(Long.valueOf(IdWorker.getId()));
        } else {
            totalVO.setSourceId(contractVO.getId());
        }
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setBillType(BillTypeEnum.\u5b89\u62c6\u5408\u540c\u4e3b\u8868.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(contractVO.getProjectId());
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO) {
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), ContractEntity.class));
        String linkUrl = this.BaseHost + "ejc-proequiment-frontend/#/otherSubList/card?id=" + entity.getId() + "&cardType=otherSubDirectCard";
        String billType = BillTypeEnum.\u5b89\u62c6\u5408\u540c\u4e3b\u8868.getCode();
        ExecutionVO executionVO = this.service.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class)), linkUrl, entity.getContractType());
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = this.service.queryDetail(id);
        String linkUrl = this.BaseHost + "ejc-proequiment-frontend/#/otherSubList/card?id=" + contractVO.getId() + "&cardType=otherSubDirectCard";
        String billType = BillTypeEnum.\u5b89\u62c6\u5408\u540c\u4e3b\u8868.getCode();
        ExecutionVO executionVO = this.service.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)contractVO), ContractVO.class)), linkUrl, contractVO.getContractType());
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        ExecutionVO executionVO;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)id)).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        Boolean flag = true;
        if (list.size() > 0) {
            flag = false;
            ChangeEntity changeEntity = (ChangeEntity)((Object)list.get(0));
            String changeLinkUrl = this.BaseHost + "ejc-proequipment-frontend/#/otherSubList/changeCard?id=" + changeEntity.getId() + "&cardType=otherSubCard";
            executionVO = this.changeService.targetCost((ChangeVO)((Object)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class)), changeLinkUrl, changeEntity.getContractType());
        } else {
            flag = true;
            String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/otherSubList/card?id=" + id + "&cardType=otherSubDirectCard";
            ContractVO contractVO = this.service.queryDetail(id);
            executionVO = this.service.targetCost(contractVO, linkUrl, contractVO.getContractType());
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5355\u636e\u7c7b\u578b" + (flag != false ? "\u4e3b\u5408\u540c" : "\u53d8\u66f4\u5408\u540c"));
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        QueryWrapper relieveEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)relieveEntityQueryWrapper.eq((Object)"contract_id", (Object)id)).eq((Object)"dr", (Object)0)).in((Object)"bill_state", new Object[]{1, 3})).orderByDesc((Object)"create_time");
        List relieveEntityList = this.contractRelieveService.list((Wrapper)relieveEntityQueryWrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            ContractRelieveEntity entity = (ContractRelieveEntity)((Object)relieveEntityList.get(0));
            ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(entity.getContractId()));
            String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/contractRelieve/card?id=" + entity.getId();
            ExecutionVO executionVO1 = this.contractRelieveService.targetCost((ContractRelieveVO)((Object)BeanMapper.map((Object)((Object)entity), ContractRelieveVO.class)), linkUrl, contractEntity.getContractType());
            this.logger.info("\u89e3\u9664\u5355\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
            CommonResponse response1 = this.executionApi.aggPush(executionVO1);
            if (!response.isSuccess()) {
                throw new BusinessException("\u89e3\u9664\u5355\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response1.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(ContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (ContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u534f\u8bae\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(contractEntity.getFilingStatus());
    }
}

