package com.ejianc.business.proequipmentcorpout.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceEntity;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceSubEntity;
import com.ejianc.business.proequipmentcorpout.appearance.service.IOutAppearanceService;
import com.ejianc.business.proequipmentcorpout.appearance.vo.OutAppearanceSubVO;
import com.ejianc.business.proequipmentcorpout.appearance.vo.OutAppearanceVO;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("outAppearance")
public class OutAppearanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IOutAppearanceService service;
	@Autowired
	private IOutRentParameterService rentParameterService;
	@Autowired
	private IRentParameterService parameterService;
	@Autowired
	private IAssetService assetService;
	@Autowired
	private IRentReceiptsApi receiptsApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OutAppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e,false);

		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutAppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
				|| BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(userContext.getUserCode());
			e.setCommitUserName(userContext.getUserName());
		}


		List<OutRentParameterEntity> parameterList = new ArrayList<>();
		List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		for (OutAppearanceSubEntity subEntity : appearanceSubList) {
//			// 主表赋值
			OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setOutDate(e.getAppearanceDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());//启动状态
			parameterEntity.setEquipmentStateName(RentEquipmentStateEnum.退场.getDescription());//退场状态
			// 处理子表
			if (!OutRentEquipmentStateEnum.停租.getCode().equals(subEntity.getState())){
				//退场时，  如果选择设备是停租状态的话，不再插入子表数据   否则 和原逻辑不变
				List<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<>();
				OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.退场单.getCode());
				detailEntity.setSourceId(e.getId());
				detailEntity.setOperationDate(subEntity.getRentEndDate());
				detailEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());
				detailEntity.setParameterId(subEntity.getSourceId());
				parameterDetailList.add(detailEntity);

				parameterEntity.setRentParameterDetailList(parameterDetailList);
			}
			parameterList.add(parameterEntity);


			//TODO 判断数据类型是自购还是租赁  回写对应台账状态
			OutRentParameterEntity outRentParameterEntity = rentParameterService.getById(subEntity.getSourceId());
			int type = outRentParameterEntity.getSourceType();
			if(0==type){
				//自购
				AssetEntity assetEntity = assetService.selectById(outRentParameterEntity.getEquipLedgerId());
				assetEntity.setEquipmentStatus(3);//闲置
				assetService.updateById(assetEntity);
			}else{
				//租赁
				RentParameterEntity rentParameterEntity = parameterService.selectById(outRentParameterEntity.getEquipLedgerId());
				rentParameterEntity.setUseType(1);//闲置
				parameterService.updateById(rentParameterEntity);
			}
		}
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.退场单.getCode());

		if(e.getRentHarborType() == 1) { //内租 推项目验收
			OutAppearanceVO outAppearanceVO = BeanMapper.map(e, OutAppearanceVO.class);

			//设置项目方需要字段
			//将租出单位信息赋值给组织
			outAppearanceVO.setOrgId(e.getOutOrgId());
			outAppearanceVO.setOrgName(e.getOutOrgName());
			outAppearanceVO.setOrgCode(e.getOutOrgCode());


			logger.info("outAppearanceVO：{}", JSONObject.toJSONString(outAppearanceVO));
			outAppearanceVO.setAppearanceSubList(BeanMapper.mapList(e.getAppearanceSubList(), OutAppearanceSubVO.class));
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(outAppearanceVO), RentReceiptsEnum.退场单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}

		service.saveOrUpdate(e, false);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutAppearanceEntity entity = service.selectById(billId);
		if(entity.getNotSignature()){
			throw new BusinessException("已签字不能撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutAppearanceEntity e = service.selectById(billId);
		List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		List<Long> parameterIdList = appearanceSubList.stream().filter(item -> OutRentEquipmentStateEnum.停租.getCode() != item.getState()).map(OutAppearanceSubEntity::getSourceId).collect(Collectors.toList());
		List<Long> parameterStopRentIdList = appearanceSubList.stream().filter(item -> OutRentEquipmentStateEnum.停租.getCode() == item.getState()).map(OutAppearanceSubEntity::getSourceId).collect(Collectors.toList());
		if (CollectionUtils.isNotEmpty(parameterIdList)){
			rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.退场单.getCode(), e.getId());
		}
		if (CollectionUtils.isNotEmpty(parameterStopRentIdList)){
			UpdateWrapper<OutRentParameterEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.in("id", parameterStopRentIdList);
			updateWrapper.set("equipment_state", RentEquipmentStateEnum.退场.getCode());
			updateWrapper.set("equipment_state_name", RentEquipmentStateEnum.退场.getDescription());
			updateWrapper.set("out_date", null);
			updateWrapper.set("operation_date", new Date());
			rentParameterService.update(updateWrapper);
		}


		for (OutAppearanceSubEntity subEntity : appearanceSubList) {
			OutRentParameterEntity outRentParameterEntity = rentParameterService.getById(subEntity.getSourceId());
			int type = outRentParameterEntity.getSourceType();
			if(0==type){
				//自购
				AssetEntity assetEntity = assetService.selectById(outRentParameterEntity.getEquipLedgerId());
				assetEntity.setEquipmentStatus(1);//在用
				assetService.updateById(assetEntity);
			}else{
				//租赁
				RentParameterEntity rentParameterEntity = parameterService.selectById(outRentParameterEntity.getEquipLedgerId());
				rentParameterEntity.setUseType(2);//在用
				parameterService.updateById(rentParameterEntity);
			}
		}

		if(e.getRentHarborType() == 1) { //内租 推项目验收
			CommonResponse<String> response = receiptsApi.delReceipts(e.getId(), RentReceiptsEnum.退场单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}
		service.saveOrUpdate(e,false);
		return CommonResponse.success();
	}

}
