package com.ejianc.business.proequipmentcorpout.constants;

import java.util.HashMap;
import java.util.Map;

public class OutRentConstants {

    /** ------------------------------单据编码区域开始--------------------------------------------*/

    /** 设备公司租出-合同单据编码 */
    public static final String BILL_TYPE_OUT_CONTRACT = "EJCBT202210000058";
    /** 设备公司租出-合同变更单据编码 */
    public static final String BILL_TYPE_OUT_CONTRACT_CHANGE = "EJCBT202210000059";
    /** 设备公司租出-合同记录单据编码 */
    public static final String BILL_TYPE_OUT_CONTRACT_RECORD = "EJCBT202210000062";
    /** 设备公司租出-合同解除单据编码 */
    public static final String BILL_TYPE_OUT_CONTRACT_RELIEVE = "EJCBT202210000061";

    /** 设备公司租出-租金计算 */
    public static final String BILL_TYPE_OUT_RENTAL = "EJCBT202211000001";
    /** ------------------------------单据编码区域结束--------------------------------------------*/

    /** ------------------------------单据编码生成规则区域开始--------------------------------------------*/
    /** 设备公司租出-合同单据编码 */
    public static final String BILL_CODE_OUT_CONTRACT = "OUT_RENTCORP_CONTRACT";
    /** 设备公司租出-合同单据编码（云南建投） */
    public static final String BILL_CODE_OUT_CONTRACT_YNJT = "OUT_RENTCORP_CONTRACT";
    /** 设备公司租出-合同解除单据编码 */
    public static final String BILL_CODE_OUT_CONTRACT_RELIEVE = "OUT_RENTCORP_RELIEVE";

    /** 设备公司租出-租金计算 */
    public static final String BILL_CODE_OUT_RENTAL = "OUT_RENTCORP_RENTAL";
    /** ------------------------------单据编码生成规则区域结束--------------------------------------------*/

    /** ------------------------------文件类型区域开始--------------------------------------------*/
    /** 设备公司租出-合同附件类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT = "proRentContractFile";
    /** 设备公司租出-合同水印附件类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT_WATER = "equipmentCorpOutRent";
    /** 设备公司租出-合同变更附件类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT_CHANGE = "EJCBT202210000059";
    /** 设备公司租出-合同记录附件类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT_RECORD = "proRentContractRecordFile";
    /** 设备公司租出-合同附件管理类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT_ATT = "proRentContract";
    /** 设备公司租出-合同记录附件管理类型 */
    public static final String FILE_SOURCE_TYPE_OUT_CONTRACT_RECORD_ATT = "proRentContractRecord";
    /** ------------------------------文件类型区域结束--------------------------------------------*/

    /** ------------------------------其他区域开始--------------------------------------------*/
    /**
     * 辅料中心租出合同-外租
     */
    public static final Integer OUT_CONTRACT_RENT_HARBOR_TYPE_OUT = 0;
    /**
     * 辅料中心租出合同-内租
     */
    public static final Integer OUT_CONTRACT_RENT_HARBOR_TYPE_IN = 1;
    public static final Map<Integer, String> outContractRentHarborTypeMap = new HashMap<>();
    static {
        outContractRentHarborTypeMap.put(OUT_CONTRACT_RENT_HARBOR_TYPE_OUT, "外租");
        outContractRentHarborTypeMap.put(OUT_CONTRACT_RENT_HARBOR_TYPE_IN, "内租");
    }
    public static String getOutContractRentHarborTypeMap(Integer rentHarborType) {
        return outContractRentHarborTypeMap.get(rentHarborType);
    }

    /**
     * 推送设备租赁：新增
     */
    public static final Integer PUSH_RENT_OPT_TYPE_ADD = 1;
    /**
     * 推送设备租赁：删除
     */
    public static final Integer PUSH_RENT_OPT_TYPE_DEL = 2;
    /**推送设备租赁单据：合同  */
    public static final String PUSH_RENT_OPT_BILL_CONTRACT = "contract";
    /**推送设备租赁单据：合同变更  */
    public static final String PUSH_RENT_OPT_BILL_CONTRACT_CHANGE = "contractChange";
    /**推送设备租赁单据：合同解除  */
    public static final String PUSH_RENT_OPT_BILL_CONTRACT_RELIEVE = "contractRelieve";
    /**推送设备租赁单据：合同冻结  */
    public static final String PUSH_RENT_OPT_BILL_CONTRACT_FREEZE = "contractFreeze";

    /** ------------------------------其他区域开始--------------------------------------------*/
}
