package com.ejianc.business.proequipmentcorpout.outrent.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.appearance.service.IOutAppearanceService;
import com.ejianc.business.proequipmentcorpout.constants.OutRentStatusTypeEnum;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStopService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/api/proequipmentcorpout/")
@Api(value = "设备公司租出API接口", tags = {"设备公司租出API接口"})
public class OutCorpApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRentEquipmentStartService outRentEquipmentStartService;
    @Autowired
    private IOutRentEquipmentStopService outRentEquipmentStopService;
    @Autowired
    private IOutAppearanceService outAppearanceService;
    @Autowired
    private IOutRentSettlementService outRentSettlementService;


    @ApiOperation("设备公司签字回写接口")
    @RequestMapping(value = "/updateBillSupSignSyncInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateBillSupSignSyncInfo(@RequestBody Map<String,String> map, String type) {
        logger.info("进入设备公司签字回写接口！");
        logger.info("单据名称："+type+"数据信息--"+JSONObject.toJSONString(map));
        String msg = "该单据未定义！";
        switch (OutRentStatusTypeEnum.getEnumByName(type)){
            case 租出启用单: msg = outRentEquipmentStartService.updateBillSupSignSync(map);break;
            case 租出停用单: msg = outRentEquipmentStopService.updateBillSupSignSync(map);break;
            case 租出退场单: msg = outAppearanceService.updateBillSupSignSync(map);break;
            case 租出结算单: msg = outRentSettlementService.updateBillSupSignSync(map);break;
            default:
                return CommonResponse.error("单据名称："+type+"签字未定义！");
        }
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
}
