package com.ejianc.business.proequipmentcorpout.rental.controller;

import java.io.Serializable;

import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;


/**
 * 租金计算主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRentRental")
@Api(value = "租金计算主表", tags = {"租金计算主表"})
public class OutRentRentalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi iOrgApi;



    @Autowired
    private IOutRentRentalService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRentRentalVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutRentRentalVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveRental(saveOrUpdateVO));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentRentalVO> queryDetail(@RequestParam Long id) {
    	OutRentRentalEntity entity = service.selectById(id);
    	OutRentRentalVO vo = BeanMapper.map(entity, OutRentRentalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRentRentalVO> pushCost(@RequestBody OutRentRentalVO vo) {
//        return service.pushCost(vo);
        return CommonResponse.success("没有实际成本推送！", vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentRentalVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (OutRentRentalVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
//        service.removeByIds(vos.stream().map(OutRentRentalVO::getId).collect(Collectors.toList()),true);
        service.delRental(vos);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRentRentalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {
            //pc端
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            //移动端 需要取orgId的本下
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutRentRentalEntity> page = service.queryPage(param,false);
        IPage<OutRentRentalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentRentalVO.class));
        setDefaultName(pageData.getRecords());
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 默认赋值名称
     *
     * @param list 需要赋值的列表
     */
    private void setDefaultName(List<OutRentRentalVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (OutRentRentalVO vo : list) {
                vo.setSettlementStateName(RentalSettlementStateEnum.getEnumByCode(vo.getSettlementState())
                        .getDescription());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("审核中");
                }
                if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("审核中");
                }
                vo.setRentHarborTypeName(OutRentConstants.getOutContractRentHarborTypeMap(vo.getRentHarborType()));
            }
        }
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<OutRentRentalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OutRentRentalVO> voList = BeanMapper.mapList(list, OutRentRentalVO.class);
        setDefaultName(voList);
        beans.put("records", voList);
        ExcelExport.getInstance().export("OutRentRental-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOutRentRentalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentRentalVO>> refOutRentRentalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("meterRentTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("settlementState", new Parameter(QueryParam.EQ, RentalSettlementStateEnum.未结算.getCode()));
//        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(),
                        BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            else {
                throw new BusinessException("合同信息不能为空！");
            }
        }
        else {
            throw new BusinessException("合同信息不能为空！");
        }

        IPage<OutRentRentalEntity> page = service.queryPage(param, false);
        IPage<OutRentRentalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentRentalVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 租金自动计算
     *
     * @param vo 参数
     * @return 计算结果
     */
    @RequestMapping(value = "/automaticRental", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRentRentalVO> automaticRental(@RequestBody OutRentRentalVO vo) {
        OutRentRentalVO outRentRentalVO = service.automaticRental(vo);
        return CommonResponse.success("租金自动计算成功！", outRentRentalVO);
    }
}
