package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceEntity;
import com.ejianc.business.proequipmentcorprent.appearance.service.IAppearanceService;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.*;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.rent.mapper.RentParameterMapper;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁设备台账
 *
 * @author generator
 */
@Service("rentParameterService")
public class RentParameterServiceImpl extends BaseServiceImpl<RentParameterMapper, RentParameterEntity> implements IRentParameterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RentParameterMapper rentParameterMapper;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    /** 启用单据 */
    @Autowired
    private IRentEquipmentStartService startService;
    /** 停用单据 */
    @Autowired
    private IRentEquipmentStopService stopService;
    /** 设备退场 */
    @Autowired
    private IAppearanceService appearanceService;
    /** 设备租金计算 */
    @Autowired
    private IRentRentalService rentRentalService;

    /**
     * 查询操作日期最多的一条数据
     *
     * @param contractId
     * @return
     */
    public RentParameterEntity selectByContractIdOrderTime(Long contractId, Long acceptanceId) {
        QueryWrapper<RentParameterEntity> query = new QueryWrapper<RentParameterEntity>();
        query.eq("contract_id", contractId);
        if (acceptanceId != null) {
            query.eq("acceptance_id", acceptanceId);
        }
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE
                .getBillStateCode());
        query.orderByDesc("operation_date");
        List<RentParameterEntity> list = rentParameterMapper.selectList(query);

        if (CollectionUtils.isNotEmpty(list)) {
            RentParameterEntity entity = list.get(0);
            return entity;
        }

        return null;
    }

    /**
     * 验证单据是否最新日期
     *
     * @param contractId
     * @param myDate
     * @return
     */
    public CommonResponse<String> selectValidationNewDate(Long contractId, Date myDate, Long id) {
        List<EquipmentNewDateVO> list = rentParameterMapper
                .queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            if (id == null) {
                if (dateVO.getNum() > 1) {
                    return CommonResponse
                            .error("日期不能小于" + dateVO.getType() + "单据中的创建日期" + sdf.format(dateVO.getPerformDate()));
                }
                else {
                    return CommonResponse.error("日期不能小于" + dateVO.getType() + "单据中的" + dateVO.getType() + "日期" + sdf
                            .format(dateVO.getPerformDate()));
                }
            }
            else {
                if (!id.equals(dateVO.getId())) {
                    if (dateVO.getNum() > 1) {
                        return CommonResponse
                                .error("日期不能小于" + dateVO.getType() + "单据中的创建日期" + sdf.format(dateVO.getPerformDate()));
                    }
                    else {
                        return CommonResponse.error("日期不能小于" + dateVO.getType() + "单据中的" + dateVO.getType() + "日期" + sdf
                                .format(dateVO.getPerformDate()));
                    }
                }
            }

        }
        return CommonResponse.success();
    }

    /**
     * 弃审调用
     * @param contractId
     * @param myDate
     * @return
     */
    public EquipmentNewDateVO selectAbandonDate(Long contractId, Date myDate) {
        List<EquipmentNewDateVO> list = rentParameterMapper.queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);

        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            return dateVO;
        }
        return null;
    }

    /**
     * 根据验收单id删除台账数据
     * @param acceptanceId
     */
    public void deleteAcceptanceId(Long acceptanceId) {
        QueryWrapper<RentParameterEntity> deleteWrapper = new QueryWrapper<RentParameterEntity>();
        deleteWrapper.eq("acceptance_id", acceptanceId);
        List<RentParameterEntity> entitys = super.list(deleteWrapper);
        if(CollectionUtils.isNotEmpty(entitys)) {
            super.removeByIds(entitys.stream().map(RentParameterEntity::getId).collect(Collectors.toList()), false);
        }
//        rentParameterMapper.delete(deleteWrapper);
    }

    @Override
    public EquipmentNewDateVO selectValidationNewDateList(Long contractId, Date myDate, Long id) {
        List<EquipmentNewDateVO> list = rentParameterMapper.queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            if(id == null){
                return dateVO;
            }else{
                if(!id.equals(dateVO.getId())){
                    return  dateVO;
                }
            }
        }
        return null;
    }

    @Override
    public EquipmentNewDateVO selectValidationNewDateSub(Long contractId) {
        List<EquipmentNewDateVO> list = rentParameterMapper
                .queryNewDateList(InvocationInfoProxy.getTenantid(), contractId);
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            return dateVO;
        }
        return null;
    }

    /**
     * 变更设备台账
     * 设备启用、设备停用、设备退场，更改台账状态，并添加操作记录
     *
     * @param parameterList 设备台账列表
     * @param sourceType    来源类型
     */
    @Override
    public void changeParameter(List<RentParameterEntity> parameterList, String sourceType) {
        logger.info("进入设备台账变更方法，变更类型：{}，变更参数：{}", RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(),
                JSONObject.toJSONString(parameterList));
        if (CollectionUtils.isEmpty(parameterList)) {
            return;
        }
        // 对数据进行初始化处理
        Map<Long, RentParameterEntity> map = new HashMap<>();
        List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
        for (RentParameterEntity entity : parameterList) {
            map.put(entity.getId(), entity);
            // 给子表赋值父表id
            for (RentParameterDetailEntity detailEntity : entity.getRentParameterDetailList()) {
                detailEntity.setParameterId(entity.getId());
            }
            parameterDetailList.addAll(entity.getRentParameterDetailList());
        }
        // 查询当前库中已有的数据
        QueryParam queryParam = new QueryParam();
        List<Long> parameterIdList = parameterList.stream().map(RentParameterEntity::getId)
                .collect(Collectors.toList());
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, parameterIdList));
        List<RentParameterEntity> saveList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(saveList)) {
            for (RentParameterEntity saveEntity : saveList) {
                // 变更台账记录
                RentParameterEntity entity = map.get(saveEntity.getId());
                saveEntity.setEquipmentState(entity.getEquipmentState());
                if (RentParameterTypeEnum.启用单.getCode().equals(sourceType)) {
                    saveEntity.setStartDate(entity.getStartDate());
                    if(null!=entity.getMeterRentDate()){
                        saveEntity.setMeterRentDate(entity.getMeterRentDate());
                    }
                }
                else if (RentParameterTypeEnum.停用单.getCode().equals(sourceType)) {
                    saveEntity.setStopDate(entity.getStopDate());
                }
                else if (RentParameterTypeEnum.退场单.getCode().equals(sourceType)) {
                    saveEntity.setOutDate(entity.getOutDate());
                }
                else if(RentParameterTypeEnum.租金计算.getCode().equals(sourceType)){
                    if (RentEquipmentStateEnum.启用.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStartDate(entity.getOperationDate());
                    }
                    else if (RentEquipmentStateEnum.停用.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStopDate(entity.getOperationDate());
                    }
                    else if (RentEquipmentStateEnum.退场.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setOutDate(entity.getOperationDate());
                    }
                }
                saveEntity.setOperationDate(new Date());
            }
            logger.info("插入数据------"+JSONObject.toJSONString(saveList));
            super.saveOrUpdateBatch(saveList);
        }
        if (CollectionUtils.isNotEmpty(parameterDetailList)) {
            // 插入操作记录
            rentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
        }
    }

    /**
     * 撤销设备台账变更
     *
     * @param parameterIdList 设备台账id列表
     * @param sourceType      变更类型
     * @param sourceId        变更单据id
     */
    @Override
    public void cancelParameter(List<Long> parameterIdList, String sourceType, Long sourceId) {
        logger.info("进入设备台账撤回方法，撤销类型：{}，撤销单据id：{}，撤销参数：{}",
                RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId,
                JSONObject.toJSONString(parameterIdList));
        // 删除台账操作记录
        rentParameterDetailService.delParameterDetail(sourceId, sourceType);
        // 查询删除后最后一条操作记录状态及时间
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
        detailParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RentParameterDetailEntity> parameterDetailList = rentParameterDetailService.queryList(detailParam, false);
        Map<Long, RentParameterDetailEntity> map = new LinkedHashMap<>();
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            // 因为是按照时间倒序排序，因此每个操作记录第一次进入map时，都是最后一次操作记录
            if (!map.containsKey(detailEntity.getParameterId())) {
                map.put(detailEntity.getParameterId(), detailEntity);
            }
        }
        QueryParam saveParam = new QueryParam();
        saveParam.getParams().put("id", new Parameter(QueryParam.IN, parameterIdList));
        List<RentParameterEntity> saveList = super.queryList(saveParam, false);
        for (RentParameterEntity saveEntity : saveList) {
            RentParameterDetailEntity detailEntity = map.get(saveEntity.getId());
            saveEntity.setEquipmentState(detailEntity.getEquipmentState());
            if (RentEquipmentStateEnum.启用.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setStartDate(detailEntity.getOperationDate());
                saveEntity.setStopDate(null);
            }
            else if (RentEquipmentStateEnum.停用.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setStopDate(detailEntity.getOperationDate());
            }
            else if (RentEquipmentStateEnum.退场.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setOutDate(detailEntity.getOperationDate());
            }
            // 操作时间修改为撤销时间
            saveEntity.setOperationDate(new Date());
        }
        super.saveOrUpdateBatch(saveList);
    }

    /**
     * 启用单、停用单、退场单保存前校验，校验不通过则抛出异常
     * <p>1.校验单据类型与当前设备状态，设备启用状态无法新增启用单，设备停用状态无法新增停用单</p>
     * <p>2.互斥性校验，启用单、停用单、退场单同一个合同下只能存在一个非生效状态的单据</p>
     * <p>3.日期校验，三个单据的日期状态是滚动向前的，每次新增单据时，需要查询当前单据的时间是否大于数据库中最新的时间（必须大于验收日期）</p>
     *
     * @param parameterIdList 需要校验的设备台账id列表
     * @param sourceType      单据类型
     * @param sourceId        单据id
     * @param contractId      合同id
     * @param myDate          校验的时间
     */
    @Override
    public void checkValidation(List<Long> parameterIdList, String sourceType, Long sourceId, Long contractId,
                                Date myDate) {
        logger.info("进行单据保存前校验，校验参数：parameterIdList：{}，sourceType：{}，sourceTypeName:{}，sourceId:{}，" +
                        "contractId:{}，myDate：{}", JSONObject.toJSONString(parameterIdList), sourceType,
                RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, contractId, myDate);
        if (CollectionUtils.isEmpty(parameterIdList)) {
            return;
        }
        String sourceTypeName;
        if (RentParameterTypeEnum.启用单.getCode().equals(sourceType)) {
            sourceTypeName = "启用";
        }
        else if (RentParameterTypeEnum.停用单.getCode().equals(sourceType)) {
            sourceTypeName = "停用";
        }
        else if (RentParameterTypeEnum.退场单.getCode().equals(sourceType)) {
            sourceTypeName = "退场";
        }
        else if (RentParameterTypeEnum.租金计算.getCode().equals(sourceType)) {
            sourceTypeName = "租金计算";
        }
        else {
            sourceTypeName = "";
        }
        QueryParam parameterParam = new QueryParam();
        parameterParam.getParams().put("id", new Parameter(QueryParam.IN, parameterIdList));
        List<RentParameterEntity> parameterEntityList = super.queryList(parameterParam, false);
        Map<Long,RentParameterEntity> parameterEntityMap = new HashMap<>();
        StringBuilder sb = new StringBuilder();
        /*
         * 1.状态校验
         */
        for (RentParameterEntity entity : parameterEntityList) {
            parameterEntityMap.put(entity.getId(),entity);
            if ((RentParameterTypeEnum.启用单.getCode().equals(sourceType)
                    && RentEquipmentStateEnum.启用.getCode().equals(entity.getEquipmentState()))
                    || (RentParameterTypeEnum.停用单.getCode().equals(sourceType)
                    && RentEquipmentStateEnum.停用.getCode().equals(entity.getEquipmentState()))) {
                sb.append("设备[").append(entity.getEquipmentName()).append("]、");
            }
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("已").append(sourceTypeName).append("，无法新增单据");
            throw new BusinessException(sb.toString());
        }
        // 未抛出异常，进行第二个校验
        /*
         *  2.互斥性校验
         */
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        checkQueryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        // 修改的时候排除当前id
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter(QueryParam.NE, sourceId));
        }
        List<RentEquipmentStartEntity> startEntityList = startService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(startEntityList)) {
            throw new BusinessException("存在未生效的启用单，无法新增单据！");
        }
        List<RentEquipmentStopEntity> stopEntityList = stopService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(stopEntityList)) {
            throw new BusinessException("存在未生效的停用单，无法新增单据！");
        }
        List<AppearanceEntity> appearanceEntityList = appearanceService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(appearanceEntityList)) {
            throw new BusinessException("存在未生效的退场单，无法新增单据！");
        }
        // 只校验是否存在自动租金计算
        checkQueryParam.getParams().put("rentalType",new Parameter(QueryParam.EQ,"1"));
        List<RentRentalEntity> rentalEntityList = rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(rentalEntityList)) {
            throw new BusinessException("存在未生效的租金计算单，无法新增单据！");
        }
        /*
         * 3.日期校验
         */
        QueryParam dateParam = new QueryParam();
        dateParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
        dateParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RentParameterDetailEntity> parameterDetailList = rentParameterDetailService.queryList(dateParam, false);
        Map<Long, RentParameterDetailEntity> map = new LinkedHashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            // 因为是按照时间倒序排序，因此每个操作记录第一次进入map时，都是最后一次操作记录
            if (!map.containsKey(detailEntity.getParameterId())) {
                map.put(detailEntity.getParameterId(), detailEntity);
                // 如果传入时间在操作时间之前，则抛出异常
                if (!myDate.after(detailEntity.getOperationDate())) {
                    RentParameterEntity entity = parameterEntityMap.get(detailEntity.getParameterId());
                    sb.append("设备[").append(entity.getEquipmentName()).append("]")
                            .append(sourceTypeName).append("日期不能小于")
                            .append(sdf.format(detailEntity.getOperationDate())).append(",");
                    // 租金计算直接抛出
                    if (RentParameterTypeEnum.租金计算.getCode().equals(sourceType)) {
                        throw new BusinessException(sourceTypeName + "日期不能小于" + sdf.format(detailEntity.getOperationDate()));
                    }
                }
            }
        }


        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            throw new BusinessException(sb.toString());
        }
    }


    /**
     * 启用单、停用单、退场单保存前校验，校验不通过则抛出异常
     * <p>1.校验单据类型与当前设备状态，设备启用状态无法新增启用单，设备停用状态无法新增停用单</p>
     * <p>2.互斥性校验，启用单、停用单、退场单同一个合同下只能存在一个非生效状态的单据</p>
     * <p>3.日期校验，三个单据的日期状态是滚动向前的，每次新增单据时，需要查询当前单据的时间是否大于数据库中最新的时间（必须大于验收日期）</p>
     *
     * @param parameterIdList 需要校验的设备台账id列表
     * @param sourceType      单据类型
     * @param sourceId        单据id
     * @param contractId      合同id
     * @param myDate          校验的时间
     */
    @Override
    public void checkValidationSub(List<Long> parameterIdList, Map<Long,Date> detailMap,String sourceType, Long sourceId, Long contractId,
                                Date myDate) {
        logger.info("进行单据保存前校验，校验参数：parameterIdList：{}，sourceType：{}，sourceTypeName:{}，sourceId:{}，" +
                        "contractId:{}，myDate：{}", JSONObject.toJSONString(parameterIdList), sourceType,
                RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, contractId, myDate);
        if (CollectionUtils.isEmpty(parameterIdList)) {
            return;
        }
        String sourceTypeName;
        if (RentParameterTypeEnum.启用单.getCode().equals(sourceType)) {
            sourceTypeName = "启用";
        }
        else if (RentParameterTypeEnum.停用单.getCode().equals(sourceType)) {
            sourceTypeName = "停用";
        }
        else if (RentParameterTypeEnum.退场单.getCode().equals(sourceType)) {
            sourceTypeName = "退场";
        }
        else if (RentParameterTypeEnum.租金计算.getCode().equals(sourceType)) {
            sourceTypeName = "租金计算";
        }
        else {
            sourceTypeName = "";
        }
        QueryParam parameterParam = new QueryParam();
        parameterParam.getParams().put("id", new Parameter(QueryParam.IN, parameterIdList));
        List<RentParameterEntity> parameterEntityList = super.queryList(parameterParam, false);
        Map<Long,RentParameterEntity> parameterEntityMap = new HashMap<>();
        StringBuilder sb = new StringBuilder();
        /*
         * 1.状态校验
         */
        for (RentParameterEntity entity : parameterEntityList) {
            parameterEntityMap.put(entity.getId(),entity);
            if ((RentParameterTypeEnum.启用单.getCode().equals(sourceType)
                    && RentEquipmentStateEnum.启用.getCode().equals(entity.getEquipmentState()))
                    || (RentParameterTypeEnum.停用单.getCode().equals(sourceType)
                    && RentEquipmentStateEnum.停用.getCode().equals(entity.getEquipmentState()))) {
                sb.append("设备[").append(entity.getEquipmentName()).append("]、");
            }
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("已").append(sourceTypeName).append("，无法新增单据");
            throw new BusinessException(sb.toString());
        }
        // 未抛出异常，进行第二个校验
        /*
         *  2.互斥性校验
         */
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        checkQueryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        // 修改的时候排除当前id
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter(QueryParam.NE, sourceId));
        }
        List<RentEquipmentStartEntity> startEntityList = startService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(startEntityList)) {
            throw new BusinessException("存在未生效的启用单，无法新增单据！");
        }
        List<RentEquipmentStopEntity> stopEntityList = stopService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(stopEntityList)) {
            throw new BusinessException("存在未生效的停用单，无法新增单据！");
        }
        List<AppearanceEntity> appearanceEntityList = appearanceService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(appearanceEntityList)) {
            throw new BusinessException("存在未生效的退场单，无法新增单据！");
        }
        // 只校验是否存在自动租金计算
        checkQueryParam.getParams().put("rentalType",new Parameter(QueryParam.EQ,"1"));
        List<RentRentalEntity> rentalEntityList = rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty(rentalEntityList)) {
            throw new BusinessException("存在未生效的租金计算单，无法新增单据！");
        }
        /*
         * 3.日期校验
         */
        QueryParam dateParam = new QueryParam();
        dateParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
        dateParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RentParameterDetailEntity> parameterDetailList = rentParameterDetailService.queryList(dateParam, false);
        Map<Long, RentParameterDetailEntity> map = new LinkedHashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            // 因为是按照时间倒序排序，因此每个操作记录第一次进入map时，都是最后一次操作记录
            if (!map.containsKey(detailEntity.getParameterId())) {
                map.put(detailEntity.getParameterId(), detailEntity);
                // 如果传入时间在操作时间之前，则抛出异常
                if(detailMap.containsKey(detailEntity.getParameterId())&&null!=detailMap.get(detailEntity.getParameterId())){
                    myDate = detailMap.get(detailEntity.getParameterId());//使用子表日期校验  如果为空，则用主表日期
                }
                if (!myDate.after(detailEntity.getOperationDate())) {
                    RentParameterEntity entity = parameterEntityMap.get(detailEntity.getParameterId());
                    sb.append("设备[").append(entity.getEquipmentName()).append("]")
                            .append(sourceTypeName).append("日期不能小于")
                            .append(sdf.format(detailEntity.getOperationDate())).append(",");
                    // 租金计算直接抛出
                    if (RentParameterTypeEnum.租金计算.getCode().equals(sourceType)) {
                        throw new BusinessException(sourceTypeName + "日期不能小于" + sdf.format(detailEntity.getOperationDate()));
                    }
                }
            }
        }




        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            throw new BusinessException(sb.toString());
        }
    }
    /**
     * 根据合同id查询当前合同下所有的设备台账，如果有做过租金计算，则去上次租金计算日期到当次租金计算日期数据，
     * 如果未做过租金计算，则取入场日期到当次租金计算日期数据
     *
     * @param contractId 合同id
     * @param sourceId   来源id
     * @param endDate    截止日期
     * @return 合同下设备台账
     */
    @Override
    public List<RentParameterVO> getRentParameterByContractId(Long contractId, Long sourceId, Date endDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("equipmentState", new Parameter(QueryParam.NE, RentEquipmentStateEnum.待启用.getCode()));//排除待启用
        List<RentParameterEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(list)) return null;
        List<Long> parameterIdList = list.stream().map(RentParameterEntity::getId).collect(Collectors.toList());
//        Date startDate = rentParameterDetailService.getMaxOperationDate(parameterIdList);
        // 进行日期校验
        this.checkValidation(parameterIdList, RentParameterTypeEnum.租金计算.getCode(), sourceId, contractId, endDate);
        // 查询字表，按照操作时间降序排序
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
//        detailParam.getOrderMap().put("createTime", QueryParam.DESC);
//        if(startDate != null){
//            detailParam.getParams().put("operationDate", new Parameter(QueryParam.GE, startDate));
//        }
        detailParam.getParams().put("operationDate", new Parameter(QueryParam.LE, endDate));
        detailParam.getOrderMap().put("operationDate", QueryParam.DESC);
        detailParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RentParameterDetailEntity> parameterDetailList = rentParameterDetailService.queryList(detailParam, false);
        // 组装查询结果
        Map<Long, List<RentParameterDetailEntity>> map = new HashMap<>();
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) {
                map.get(detailEntity.getParameterId()).add(detailEntity);
            }
            else {
                List<RentParameterDetailEntity> packList = new ArrayList<>();
                packList.add(detailEntity);
                map.put(detailEntity.getParameterId(), packList);
            }
        }
        List<RentParameterDetailEntity> addDetailList;
        for (RentParameterEntity entity : list) {
            List<RentParameterDetailEntity> detailEntityList = map.get(entity.getId());
            // 对明细结果进行截取，取上次租金计算日期到当次租金计算日期数据
            // 因查询倒序排序，循环到类型为租金计算时，截取数据
            addDetailList = new ArrayList<>();
            for (RentParameterDetailEntity detailEntity : detailEntityList) {
                if (RentParameterTypeEnum.租金计算.getCode().equals(detailEntity.getSourceType())) {
                    // 添加上次租金计算日期，做起始日期
                    // edit by sunyj 取上次租金计算日期+1  做开始时间
                    detailEntity.setOperationDate(calculationDay(detailEntity.getOperationDate(),1));
                    addDetailList.add(detailEntity);
                    break;
                }
                else {
                    addDetailList.add(detailEntity);
                }
            }
            // 对数据按操作日期做升序排序
            addDetailList.sort(Comparator.comparing(RentParameterDetailEntity::getOperationDate));
            entity.setRentParameterDetailList(addDetailList);
        }
        return BeanMapper.mapList(list, RentParameterVO.class);
    }

    /**
     * 计算日期，加几天或者减几天  整数  往后推,负数往前移动
     *
     * @param date 需要计算的日期
     * @param days 计算天数
     * @return 计算结果
     */
    private Date calculationDay(Date date, Integer days) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, days); //把日期往后增加一天,整数  往后推,负数往前移动
        return calendar.getTime(); //这个时间就是日期往后推一天的结果
    }
    /**
     * 出厂编码重复校验
     * @return
     */
    @Override
    public Boolean selectAppearanceCodeList(String factoryCode){
        List<RentParameterVO> list = baseMapper.selectAppearanceCodeList(factoryCode);
        if(CollectionUtils.isNotEmpty(list)){
            return true;
        }
        return false;
    }
}
