/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentChangeContractClauseEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentChangeContractPaymentEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentChangeDayDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentChangeMonthDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentChangeOtherDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractClauseEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractPaymentClauseEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractRecordEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentDayDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentOtherDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.ContractStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractChangeMapper;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractMapper;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractClauseService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractPaymentClauseService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractRecordService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentDayDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentMonthDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentOtherDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentQuantitiesDetailedService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeContractClauseVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeContractPaymentVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeDayDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeMonthDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeOtherDetailedVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentChangeQuantitiesVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="outRentContractChangeService")
public class OutRentContractChangeServiceImpl
extends BaseServiceImpl<OutRentContractChangeMapper, OutRentContractChangeEntity>
implements IOutRentContractChangeService {
    @Autowired
    private IOutRentContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractRecordService contractRecordService;
    @Autowired
    private IOutRentContractService outRentContractService;
    @Autowired
    private IOutRentContractRecordService outRentContractRecordService;
    private static final String BILL_CHANGE_CODE = "OutRent_CONTRACT_CHANGE";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IOutRentDayDetailedService outRentDayDetailedService;
    @Autowired
    private IOutRentMonthDetailedService outRentMonthDetailedService;
    @Autowired
    private IOutRentQuantitiesDetailedService outRentQuantitiesDetailedService;
    @Autowired
    private IOutRentOtherDetailedService outRentOtherDetailedService;
    @Autowired
    private IOutRentContractClauseService contractClauseService;
    @Autowired
    private OutRentContractMapper outRentContractMapper;
    @Autowired
    private IOutRentContractPaymentClauseService contractPaymentService;
    private final String CONTRACT_RECORD_REFCODE = "proSubContractRecord";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private final String CONTRACT_REFCODE = "proSubContract";
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    private static final String CHECK_PARAM_CODE = "P-4i7sNe70";
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";

    @Override
    public OutRentContractChangeVO saveOrUpdates(OutRentContractChangeVO outRentContractChangeVO) {
        OutRentContractChangeEntity changeEntity;
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.contractService.getById(outRentContractChangeVO.getContractId()));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(OutRentContractChangeEntity::getContractId, (Object)outRentContractChangeVO.getMainContractId());
        if (outRentContractChangeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)outRentContractChangeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(OutRentContractChangeEntity::getSignatureState, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(OutRentContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (CollectionUtils.isNotEmpty((Collection)outRentContractChangeVO.getAttachIds()) && null != outRentContractEntity.getContractFileId()) {
            outRentContractChangeVO.getAttachIds().remove(outRentContractChangeVO.getContractFileId());
        }
        if ((changeEntity = (OutRentContractChangeEntity)((Object)BeanMapper.map((Object)outRentContractChangeVO, OutRentContractChangeEntity.class))).getId() == null) {
            changeEntity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setCode(changeEntity.getCode() + "10" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setCode(changeEntity.getCode() + "1" + changeEntity.getChangeVersion());
            }
            this.clearDetailList(changeEntity);
        }
        changeEntity.setChangeContractName(changeEntity.getContractName());
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveOrUpdateContract(changeEntity);
        this.outRentContractService.pushContractToRent(JSONObject.toJSONString((Object)((Object)changeEntity)), OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, "contractChange");
        OutRentContractChangeVO changeVO = (OutRentContractChangeVO)BeanMapper.map((Object)((Object)changeEntity), OutRentContractChangeVO.class);
        return changeVO;
    }

    @Override
    public OutRentContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(contractId));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            OutRentContractChangeEntity change = (OutRentContractChangeEntity)((Object)this.selectById(contractEntity.getChangeId()));
            OutRentContractChangeVO vo = (OutRentContractChangeVO)BeanMapper.map((Object)((Object)change), OutRentContractChangeVO.class);
            return vo;
        }
        OutRentContractVO vo = (OutRentContractVO)BeanMapper.map((Object)((Object)contractEntity), OutRentContractVO.class);
        OutRentContractChangeVO changeVO = (OutRentContractChangeVO)BeanMapper.map((Object)vo, OutRentContractChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setMainContractId(contractEntity.getId());
        changeVO.setMainContractCode(contractEntity.getCode());
        changeVO.setMainContractName(contractEntity.getContractName());
        changeVO.setBeforeChangeTax(contractEntity.getContractAmountTax());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        changeVO.setWatermarkContractFileId(null);
        this.resetSub(changeVO);
        return changeVO;
    }

    public void resetSub(OutRentContractChangeVO changeVO) {
        List paymentList;
        List contractList;
        List quantitiesList;
        List otherList;
        List monthList;
        List dayList = changeVO.getRentDayDetailedList();
        if (CollectionUtils.isNotEmpty((Collection)dayList)) {
            dayList.forEach(dayDetailed -> {
                dayDetailed.setSrcTblId(dayDetailed.getId());
                dayDetailed.setId(Long.valueOf(IdWorker.getId()));
                dayDetailed.setBeforeDayRentPrice(dayDetailed.getDayRentPrice());
                dayDetailed.setBeforeRentNum(dayDetailed.getRentNum());
                dayDetailed.setBeforeStopRentPrice(dayDetailed.getStopRentPrice());
                dayDetailed.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(monthList = changeVO.getRentMonthDetailedList()))) {
            monthList.forEach(monthDetailed -> {
                monthDetailed.setSrcTblId(monthDetailed.getId());
                monthDetailed.setId(Long.valueOf(IdWorker.getId()));
                monthDetailed.setChangeId(monthDetailed.getId());
                monthDetailed.setBeforeDayTaxPrice(monthDetailed.getDayTaxPrice());
                monthDetailed.setBeforeInsufficientMonthDayRentPrice(monthDetailed.getInsufficientMonthDayRentPrice());
                monthDetailed.setBeforeMonthRentPrice(monthDetailed.getMonthRentPrice());
                monthDetailed.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(otherList = changeVO.getRentOtherDetailedList()))) {
            otherList.forEach(otherDetailed -> {
                otherDetailed.setSrcTblId(otherDetailed.getId());
                otherDetailed.setId(Long.valueOf(IdWorker.getId()));
                otherDetailed.setBeforeNotTaxAmount(otherDetailed.getNotTaxAmount());
                otherDetailed.setBeforeNotTaxPrice(otherDetailed.getNotTaxPrice());
                otherDetailed.setBeforeNum(otherDetailed.getNum());
                otherDetailed.setBeforePrice(otherDetailed.getPrice());
                otherDetailed.setBeforeTax(otherDetailed.getTax());
                otherDetailed.setBeforeTaxAmount(otherDetailed.getTaxAmount());
                otherDetailed.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(quantitiesList = changeVO.getRentQuantitiesDetailedList()))) {
            quantitiesList.forEach(quantities -> {
                quantities.setSrcTblId(quantities.getId());
                quantities.setId(Long.valueOf(IdWorker.getId()));
                quantities.setBeforeQuantitiesNum(quantities.getQuantitiesNum());
                quantities.setBeforeQuantitiesPrice(quantities.getQuantitiesPrice());
                quantities.setBeforeRentNum(quantities.getRentNum());
                quantities.setBeforeTax(quantities.getTax());
                quantities.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractList = changeVO.getRentContractClauseList()))) {
            contractList.forEach(item -> {
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(paymentList = changeVO.getRentContractPaymentClauseList()))) {
            paymentList.forEach(item -> {
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }
    }

    @Transactional
    public void saveOrUpdateContract(OutRentContractChangeEntity changeEntity) {
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.contractService.getById(changeEntity.getContractId()));
        outRentContractEntity.setChangeCode(changeEntity.getCode());
        outRentContractEntity.setChangeDate(changeEntity.getChangeDate());
        outRentContractEntity.setChangeId(changeEntity.getId());
        outRentContractEntity.setChangeStatus(2);
        outRentContractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        outRentContractEntity.setChangeFile(changeEntity.getChangeFile());
        outRentContractEntity.setBeforeChangeMny(outRentContractEntity.getContractMny());
        outRentContractEntity.setAfterChangeMny(changeEntity.getChangeMny());
        outRentContractEntity.setChangeVersion(changeEntity.getChangeVersion());
        outRentContractEntity.setChangingMny((changeEntity.getChangeMny() != null ? changeEntity.getChangeMny() : BigDecimal.ZERO).subtract(changeEntity.getChangeTax() != null ? changeEntity.getChangeTax() : BigDecimal.ZERO));
        outRentContractEntity.setChangeContractSignatureStatus(Integer.valueOf(changeEntity.getSignatureState()));
        outRentContractEntity.setChangeFile(changeEntity.getChangeFile());
        this.contractService.saveOrUpdate((Object)outRentContractEntity);
    }

    @Override
    public OutRentContractChangeVO queryDetailRecord(Long id) {
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(id));
        OutRentContractChangeVO changeVO = new OutRentContractChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("signature_state", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = OutRentContractChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), OutRentContractChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        Boolean isEditFlag = null;
        String contractPerformanceState = contractEntity.getContractPerformanceState();
        Integer changeStatus = contractEntity.getChangeStatus();
        String signatureState = contractEntity.getSignatureState();
        isEditFlag = contractPerformanceState.equals(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode()) || contractPerformanceState.equals(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()) || contractPerformanceState.equals(PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode()) || changeStatus.equals(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        changeVO.setEditFlag(isEditFlag);
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(OutRentContractChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(OutRentContractChangeEntity::getSignatureState, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(OutRentContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        Object resp = null;
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)this.selectById(changeBillId));
        OutRentContractVO contractVO = this.outRentContractService.queryDetail(changeEntity.getContractId());
        this.writeBackRecord(changeEntity, contractVO);
        OutRentContractEntity outRentContractEntity = this.writeBackContract(changeEntity, contractVO);
        changeEntity.setSignatureState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        changeEntity.setCommitDate(new Date());
        changeEntity.setEffectiveDate(new Date());
        this.contractChangeService.saveOrUpdate((Object)changeEntity);
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    public void writeBackRecord(OutRentContractChangeEntity changeEntity, OutRentContractVO contractVO) {
        OutRentContractRecordEntity recordEntity = (OutRentContractRecordEntity)((Object)BeanMapper.map((Object)contractVO, OutRentContractRecordEntity.class));
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())) {
            recordEntity.getRentDayDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())) {
            recordEntity.getRentMonthDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())) {
            recordEntity.getRentQuantitiesDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentOtherDetailedList())) {
            recordEntity.getRentOtherDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())) {
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())) {
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), "EJCBT202210000058", "proRentContract", String.valueOf(recordEntity.getId()), "EJCBT202210000062", "proRentContractRecord");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response2 = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), "EJCBT202210000058", "proRentContractFile", String.valueOf(recordEntity.getId()), "EJCBT202210000062", "proRentContractRecordFile");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response2));
        this.outRentContractService.pushContractToRent(JSONObject.toJSONString((Object)((Object)changeEntity)), OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, "contractChange");
    }

    public OutRentContractEntity writeBackContract(OutRentContractChangeEntity changeEntity, OutRentContractVO contractVO) {
        List collect;
        List collect2;
        List collect3;
        List collect4;
        List collect5;
        List dailyOutRentList;
        List collect6;
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)BeanMapper.map((Object)contractVO, OutRentContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setPartyId(changeEntity.getPartyId());
        contractEntity.setPartyName(changeEntity.getPartyName());
        contractEntity.setPartyPhone(changeEntity.getPartyPhone());
        contractEntity.setPartyHandleUser(changeEntity.getPartyHandleUser());
        contractEntity.setPartyHandleUserName(changeEntity.getPartyHandleUserName());
        contractEntity.setPartyUser(changeEntity.getPartyUser());
        contractEntity.setPartyUserName(changeEntity.getPartyUserName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierHandleUser(changeEntity.getSupplierHandleUser());
        contractEntity.setSupplierHandleUserName(changeEntity.getSupplierHandleUserName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplementCode(changeEntity.getSupplementCode());
        contractEntity.setMeterRentType(changeEntity.getMeterRentType());
        contractEntity.setMeterRentTypeName(changeEntity.getMeterRentTypeName());
        contractEntity.setMonthSettlement(changeEntity.getMonthSettlement());
        contractEntity.setMeterDate(changeEntity.getMeterDate());
        contractEntity.setPreventDate(changeEntity.getPreventDate());
        contractEntity.setSignedDate(changeEntity.getSignedDate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFile(changeEntity.getContractFile());
        contractEntity.setChangingRatio(changeEntity.getChangingRatio());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangingTaxMny(null);
        contractEntity.setRentHarborType(changeEntity.getRentHarborType());
        contractEntity.setTargetType(changeEntity.getTargetType());
        contractEntity.setTargetResultId(changeEntity.getTargetResultId());
        contractEntity.setTargetResultName(changeEntity.getTargetResultName());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        if (ListUtil.isNotEmpty((List)contractVO.getRentDayDetailedList()) && CollectionUtils.isNotEmpty(collect6 = contractVO.getRentDayDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.outRentDayDetailedService.removeByIds(collect6);
        }
        if (ListUtil.isNotEmpty((List)(dailyOutRentList = BeanMapper.mapList(changeEntity.getRentDayDetailedList(), OutRentDayDetailedEntity.class)))) {
            for (Object entity : dailyOutRentList) {
                ((OutRentDayDetailedEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((OutRentDayDetailedEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentDayDetailedList(dailyOutRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getRentMonthDetailedList()) && CollectionUtils.isNotEmpty(collect5 = contractVO.getRentMonthDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.outRentMonthDetailedService.removeByIds(collect5);
        }
        List monthOutRentList = BeanMapper.mapList(changeEntity.getRentMonthDetailedList(), OutRentMonthDetailedEntity.class);
        if (ListUtil.isNotEmpty((List)dailyOutRentList)) {
            for (Object entity : monthOutRentList) {
                ((OutRentMonthDetailedEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((OutRentMonthDetailedEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentMonthDetailedList(monthOutRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getRentQuantitiesDetailedList()) && CollectionUtils.isNotEmpty(collect4 = contractVO.getRentQuantitiesDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.outRentQuantitiesDetailedService.removeByIds(collect4);
        }
        List quantitiesDetailedList = BeanMapper.mapList(changeEntity.getRentQuantitiesDetailedList(), OutRentQuantitiesDetailedEntity.class);
        if (ListUtil.isNotEmpty((List)dailyOutRentList)) {
            for (Object entity : quantitiesDetailedList) {
                ((OutRentQuantitiesDetailedEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((OutRentQuantitiesDetailedEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentQuantitiesDetailedList(quantitiesDetailedList);
        if (ListUtil.isNotEmpty((List)contractVO.getRentOtherDetailedList()) && CollectionUtils.isNotEmpty(collect3 = contractVO.getRentOtherDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.outRentOtherDetailedService.removeByIds(collect3);
        }
        List otherDetailedList = BeanMapper.mapList(changeEntity.getRentOtherDetailedList(), OutRentOtherDetailedEntity.class);
        if (ListUtil.isNotEmpty((List)dailyOutRentList)) {
            for (Object entity : otherDetailedList) {
                ((OutRentOtherDetailedEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((OutRentOtherDetailedEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentOtherDetailedList(otherDetailedList);
        if (ListUtil.isNotEmpty((List)contractVO.getRentContractClauseList()) && CollectionUtils.isNotEmpty(collect2 = contractVO.getRentContractClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.contractClauseService.removeByIds(collect2);
        }
        List contractClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractClauseList(), OutRentContractClauseEntity.class);
        if (ListUtil.isNotEmpty((List)dailyOutRentList)) {
            for (Object entity : contractClauseEntityList) {
                ((OutRentContractClauseEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((OutRentContractClauseEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractClauseList(contractClauseEntityList);
        if (ListUtil.isNotEmpty((List)contractVO.getRentContractClauseList()) && CollectionUtils.isNotEmpty(collect = contractVO.getRentContractPaymentClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            this.contractClauseService.removeByIds(collect);
        }
        List paymentClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractPaymentClauseList(), OutRentContractPaymentClauseEntity.class);
        if (ListUtil.isNotEmpty((List)dailyOutRentList)) {
            for (OutRentContractPaymentClauseEntity entity : paymentClauseEntityList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractPaymentClauseList(paymentClauseEntityList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), "EJCBT202210000059", "EJCBT202210000059", String.valueOf(contractEntity.getId()), "EJCBT202210000058", "proRentContractFile");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        return contractEntity;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        OutRentContractChangeEntity entity = (OutRentContractChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFile(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public OutRentContractChangeVO saveOrUpdate(OutRentContractChangeVO saveOrUpdateVO, Boolean isControl) {
        OutRentContractChangeEntity entity;
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(saveOrUpdateVO.getMainContractId()));
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getAttachIds()) && null != outRentContractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(outRentContractEntity.getContractFileId());
        }
        if ((entity = (OutRentContractChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRentContractChangeEntity.class))).getId() == null || entity.getId() == 0L) {
            if (!isControl.booleanValue()) {
                // empty if block
            }
            entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setContractState(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            entity.setFilingRef(0);
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            if (entity.getChangeVersion() < 10) {
                entity.setCode(saveOrUpdateVO.getCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setCode(saveOrUpdateVO.getCode() + "-1-" + entity.getChangeVersion());
            }
            if (!isControl.booleanValue()) {
                this.clearDetailList(entity);
            }
        }
        if (saveOrUpdateVO.getId() == null && !isControl.booleanValue()) {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId())).orderByDesc((Object)"create_time");
            List list = super.list((Wrapper)wrapper);
            ArrayList arrayList = new ArrayList();
        }
        this.contractService.validateContract(saveOrUpdateVO.getMainContractId(), "\u53d8\u66f4\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setContractName(entity.getContractName());
        entity.setChangeContractName(entity.getContractName());
        if (!isControl.booleanValue()) {
            this.saveOrUpdate((Object)entity, false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OutRentContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(OutRentContractEntity::getChangingMny, (Object)entity.getContractMny());
        updateWrapper.set(OutRentContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
        updateWrapper.set(OutRentContractEntity::getChangeCode, (Object)entity.getCode());
        updateWrapper.set(OutRentContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
        updateWrapper.set(OutRentContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(OutRentContractEntity::getChangeDate, (Object)entity.getChangeDate());
        updateWrapper.set(OutRentContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
        updateWrapper.set(OutRentContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureState());
        updateWrapper.set(OutRentContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
        updateWrapper.set(OutRentContractEntity::getChangeContractName, (Object)entity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
        if (!isControl.booleanValue()) {
            this.contractService.update((Wrapper)updateWrapper);
        }
        if (null == entity.getId() && isControl.booleanValue()) {
            entity.setId(IdWorker.getId());
            return (OutRentContractChangeVO)BeanMapper.map((Object)((Object)entity), OutRentContractChangeVO.class);
        }
        return (OutRentContractChangeVO)BeanMapper.map((Object)((Object)entity), OutRentContractChangeVO.class);
    }

    public void deleteOldCost(OutRentContractChangeVO changeVO) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.targetCost(changeVO, null);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u65e7\u76ee\u6807\u6210\u672c\u5931\u8d25\uff01");
        }
    }

    @Override
    public ExecutionVO targetCost(OutRentContractChangeVO changeVO, Long lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getCode());
        totalVO.setBillType("EJCBT202210000058");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLastSourceId(lastSourceId);
        totalVO.setLinkUrl(this.baseHost + "ejc-proequipment-frontend/#/leaseContractcontractChangeCard?id=" + changeVO.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "subContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractBill", targetBillId, targetBillTypeCode, "subContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public void queryBpm(Long billId) {
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(billId));
        if (contractEntity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractEntity.getDraftType())) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                contractEntity.setSignatureState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setEffectiveDate(new Date());
            } else if (null == contractEntity.getContractFileId()) {
                // empty if block
            }
        }
        contractEntity.setCommitDate(new Date());
        contractEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
        contractEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        this.contractService.saveOrUpdate((Object)contractEntity);
    }

    public void clearDetailList(OutRentContractChangeEntity changeEntity) {
        if (ListUtil.isNotEmpty(changeEntity.getRentDayDetailedList())) {
            for (OutRentChangeDayDetailedEntity outRentChangeDayDetailedEntity : changeEntity.getRentDayDetailedList()) {
                outRentChangeDayDetailedEntity.setId(null);
                outRentChangeDayDetailedEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())) {
            for (OutRentChangeMonthDetailedEntity outRentChangeMonthDetailedEntity : changeEntity.getRentMonthDetailedList()) {
                outRentChangeMonthDetailedEntity.setId(null);
                outRentChangeMonthDetailedEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())) {
            for (OutRentChangeMonthDetailedEntity outRentChangeMonthDetailedEntity : changeEntity.getRentMonthDetailedList()) {
                outRentChangeMonthDetailedEntity.setId(null);
                outRentChangeMonthDetailedEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRentOtherDetailedList())) {
            for (OutRentChangeOtherDetailedEntity outRentChangeOtherDetailedEntity : changeEntity.getRentOtherDetailedList()) {
                outRentChangeOtherDetailedEntity.setId(null);
                outRentChangeOtherDetailedEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRentContractPaymentClauseList())) {
            for (OutRentChangeContractPaymentEntity outRentChangeContractPaymentEntity : changeEntity.getRentContractPaymentClauseList()) {
                outRentChangeContractPaymentEntity.setId(null);
                outRentChangeContractPaymentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRentContractClauseList())) {
            for (OutRentChangeContractClauseEntity outRentChangeContractClauseEntity : changeEntity.getRentContractClauseList()) {
                outRentChangeContractClauseEntity.setId(null);
                outRentChangeContractClauseEntity.setContractId(changeEntity.getMainContractId());
            }
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(OutRentContractChangeVO changeVO) {
        OutRentContractChangeVO contractVO1 = this.saveOrUpdate(changeVO, true);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)changeVO.getContractId())).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        ArrayList totalExecutionVOList = new ArrayList();
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        Long lastSourceId = null;
        lastSourceId = list.size() > 0 ? ((OutRentContractChangeEntity)((Object)list.get(0))).getId() : outRentContractEntity.getId();
        ExecutionVO executionVO = this.targetCost(contractVO1, lastSourceId);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        OutRentContractChangeVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.targetCost(contractVO, null);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public OutRentContractChangeVO queryDetail(Long id) {
        OutRentContractChangeEntity entity = (OutRentContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        OutRentContractChangeVO vo = (OutRentContractChangeVO)BeanMapper.map((Object)((Object)entity), OutRentContractChangeVO.class);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)super.selectById((Serializable)billId));
        if (changeEntity != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                this.effectiveSaveWriteContract(billId, changeEntity.getCode(), false);
                return true;
            }
            changeEntity.setSignatureState(String.valueOf(status));
            super.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(OutRentContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureState()));
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
            return true;
        }
        return false;
    }

    @Override
    public ParamsCheckVO checkParams(OutRentContractChangeVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        paramsCheckVOS.addAll(this.checkParamsMny(vo));
        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(OutRentContractChangeVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(OutRentContractChangeVO vo) {
        BigDecimal changeMoney = vo.getChangeMny() == null ? BigDecimal.ZERO : vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny() == null ? BigDecimal.ZERO : vo.getBaseTaxMny();
        BigDecimal totalChangeMoney = changeMoney;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)vo.getContractId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{1, 3});
        query.eq((Object)"signature_state", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        List list = this.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutRentContractChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd((BigDecimal)changeEntity.getChangeMny(), (BigDecimal)totalChangeMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(totalChangeMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalChangeMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(OutRentContractChangeVO vo) {
        CommonResponse billParamByCode;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(OutRentContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        Lambda.ne(BaseEntity::getId, (Object)vo.getContractId());
        List list = this.outRentContractService.list((Wrapper)Lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<OutRentContractChangeVO> contractChangeList = this.outRentContractMapper.getRentContractChangeList(collect);
            Map<Long, OutRentContractChangeVO> map = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public Map queryChangeCompare(Long id) {
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)super.selectById((Serializable)id));
        OutRentContractChangeVO changeCompareVO = (OutRentContractChangeVO)BeanMapper.map((Object)((Object)changeEntity), OutRentContractChangeVO.class);
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.outRentContractService.selectById(changeEntity.getContractId()));
        OutRentContractChangeVO beforeChangeVO = new OutRentContractChangeVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OutRentContractRecordEntity::getChangeId, (Object)id);
            wrapper.eq(OutRentContractRecordEntity::getContractId, (Object)changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List recordEntityList = this.contractRecordService.list((Wrapper)wrapper);
            if (ListUtil.isNotEmpty((List)recordEntityList)) {
                beforeChangeVO = (OutRentContractChangeVO)BeanMapper.map((Object)this.contractRecordService.selectById(((OutRentContractRecordEntity)((Object)recordEntityList.get(0))).getId()), OutRentContractChangeVO.class);
            }
        } else {
            beforeChangeVO = (OutRentContractChangeVO)BeanMapper.map((Object)((Object)contractEntity), OutRentContractChangeVO.class);
            flag = true;
        }
        HashMap<String, OutRentContractChangeVO> returnMap = new HashMap<String, OutRentContractChangeVO>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            Map<Object, Object> beforeOtherMap;
            List otherOutRentList;
            OutRentChangeDayDetailedVO beforeVO;
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentDayDetailedList())) {
                List dailyOutRentList = beforeChangeVO.getRentDayDetailedList();
                Map<Object, Object> beforeDailyMap = new HashMap();
                beforeDailyMap = flag ? dailyOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : dailyOutRentList.stream().collect(Collectors.toMap(OutRentChangeDayDetailedVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentDayDetailedList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeDayDetailedVO)beforeDailyMap.get(vo.getSrcTblId());
                    vo.setBcDayFactoryCode(beforeVO.getDayFactoryCode());
                    vo.setBcDayRentPrice(beforeVO.getDayRentPrice());
                    vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                    vo.setBcRentNum(beforeVO.getRentNum());
                    vo.setBcTax(beforeVO.getTax());
                    vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                    vo.setBcStopRentNotTaxPrice(beforeVO.getStopRentNotTaxPrice());
                    vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                    vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                    vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcTaxMny(beforeVO.getTaxMny());
                    vo.setBcRentDay(beforeVO.getRentDay());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    vo.setBcTaxMoney(beforeVO.getTaxMoney());
                }
                changeCompareVO.setRentDayDetailedList(changeCompareVO.getRentDayDetailedList().stream().filter(daily -> StringUtils.isNotEmpty((CharSequence)daily.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentMonthDetailedList())) {
                List monthOutRentList = beforeChangeVO.getRentMonthDetailedList();
                Map<Object, Object> beforeMonthMap = new HashMap();
                beforeMonthMap = flag ? monthOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : monthOutRentList.stream().collect(Collectors.toMap(OutRentChangeMonthDetailedVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentMonthDetailedList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeMonthDetailedVO)beforeMonthMap.get(vo.getSrcTblId());
                    vo.setBcMonthFactoryCode(beforeVO.getMonthFactoryCode());
                    vo.setBcMonthRentPrice(beforeVO.getMonthRentPrice());
                    vo.setBcInsufficientMonthDayRentPrice(beforeVO.getInsufficientMonthDayRentPrice());
                    vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                    vo.setBcRentNum(beforeVO.getRentNum());
                    vo.setBcTax(beforeVO.getBcTax());
                    vo.setBcMonthRentNotTaxPrice(beforeVO.getMonthRentNotTaxPrice());
                    vo.setBcInsufficientMonthNotTaxRentPrice(beforeVO.getInsufficientMonthNotTaxRentPrice());
                    vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                    vo.setPlanOutDate(beforeVO.getPlanOutDate());
                    vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcEquipmentCode(beforeVO.getEquipmentCode());
                    vo.setBcDayTaxPrice(beforeVO.getDayTaxPrice());
                    vo.setBcTaxMny(beforeVO.getTaxMny());
                    vo.setBcNotTaxMonthPrice(beforeVO.getNotTaxMonthPrice());
                    vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                    vo.setBcNotTaxStopPrice(beforeVO.getNotTaxStopPrice());
                    vo.setBcRentMonth(beforeVO.getRentMonth());
                    vo.setBcRentDay(beforeVO.getRentDay());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    vo.setBcTaxMoney(beforeVO.getTaxMoney());
                }
                changeCompareVO.setRentMonthDetailedList(changeCompareVO.getRentMonthDetailedList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentQuantitiesDetailedList())) {
                List quantitiesOutRentList = beforeChangeVO.getRentQuantitiesDetailedList();
                Map<Object, Object> beforeQuantitiesMap = new HashMap();
                beforeQuantitiesMap = flag ? quantitiesOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : quantitiesOutRentList.stream().collect(Collectors.toMap(OutRentChangeQuantitiesVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentQuantitiesDetailedList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeQuantitiesVO)beforeQuantitiesMap.get(vo.getSrcTblId());
                    vo.setBcQuantitiesFactoryCode(beforeVO.getQuantitiesFactoryCode());
                    vo.setBcQuantitiesNum(beforeVO.getQuantitiesNum());
                    vo.setBcQuantitiesPrice(beforeVO.getQuantitiesPrice());
                    vo.setBcRentNum(beforeVO.getRentNum());
                    vo.setBcTax(beforeVO.getTax());
                    vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                    vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                    vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcNotTaxQuantitiesPrice(beforeVO.getNotTaxQuantitiesPrice());
                    vo.setBcNotTaxQuantitiesMny(beforeVO.getNotTaxQuantitiesMny());
                    vo.setBcRentMny(beforeVO.getRentMny());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    vo.setBcTaxMoney(beforeVO.getTaxMoney());
                }
                changeCompareVO.setRentQuantitiesDetailedList(changeCompareVO.getRentQuantitiesDetailedList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentOtherDetailedList())) {
                otherOutRentList = beforeChangeVO.getRentOtherDetailedList();
                beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeOtherDetailedVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentOtherDetailedList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeOtherDetailedVO)beforeOtherMap.get(vo.getSrcTblId());
                    vo.setBcPrice(beforeVO.getPrice());
                    vo.setBcNum(beforeVO.getNum());
                    vo.setBcTaxAmount(beforeVO.getTaxAmount());
                    vo.setBcNotTaxPrice(beforeVO.getNotTaxPrice());
                    vo.setBcNotTaxAmount(beforeVO.getNotTaxAmount());
                    vo.setBcMemo(beforeVO.getBcMemo());
                    vo.setBcTaxMoney(beforeVO.getTaxMoney());
                }
                changeCompareVO.setRentOtherDetailedList(changeCompareVO.getRentOtherDetailedList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentContractPaymentClauseList())) {
                otherOutRentList = beforeChangeVO.getRentContractPaymentClauseList();
                beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractPaymentVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentContractPaymentClauseList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeContractPaymentVO)beforeOtherMap.get(vo.getSrcTblId());
                    vo.setBcName(beforeVO.getName());
                    vo.setBcPaymentContent(beforeVO.getPaymentContent());
                    vo.setBcPaymentRatio(beforeVO.getPaymentRatio());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setChangeType("2");
                }
                changeCompareVO.setRentContractPaymentClauseList(changeCompareVO.getRentContractPaymentClauseList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRentContractClauseList())) {
                otherOutRentList = beforeChangeVO.getRentContractClauseList();
                beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherOutRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractClauseVO::getSrcTblId, Function.identity()));
                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentContractClauseList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRentChangeContractClauseVO)beforeOtherMap.get(vo.getSrcTblId());
                    vo.setBcName(beforeVO.getName());
                    vo.setBcName(beforeVO.getName());
                    vo.setBcClauseContent(beforeVO.getClauseContent());
                    vo.setChangeType("2");
                }
                changeCompareVO.setRentContractClauseList(changeCompareVO.getRentContractClauseList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }
}

