/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.rental.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractRecordEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentDayDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentDayRecordEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentMonthRecordEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentQuantitiesRecordEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractRecordService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentDayRecordService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentMonthRecordService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentQuantitiesRecordService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentDayRecordVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentMonthRecordVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentQuantitiesRecordVO;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalDayEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalMonthEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorpout.rental.mapper.OutRentRentalMapper;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalDayService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalMonthService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalQuantitiesService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalCacheVO;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentalSumVo;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordEntity;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordService;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordSubService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="outRentRentalService")
public class OutRentRentalServiceImpl
extends BaseServiceImpl<OutRentRentalMapper, OutRentRentalEntity>
implements IOutRentRentalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RENT_TYPE_DAY = "day";
    private static final String RENT_TYPE_MONTH = "month";
    private static final String RENT_TYPE_QUANTITIES = "engineering";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IOutRentParameterService parameterService;
    @Autowired
    private IOutRentContractService contractService;
    @Autowired
    private IOutRentContractRecordService contractRecordService;
    @Autowired
    private IOutRentDayRecordService dayRecordService;
    @Autowired
    private IOutRentMonthRecordService monthRecordService;
    @Autowired
    private IOutRentQuantitiesRecordService quantitiesRecordService;
    @Autowired
    private IUseRecordService useRecordService;
    @Autowired
    private IUseRecordSubService useRecordSubService;
    @Autowired
    private IOutRentRentalDayService outRentRentalDayService;
    @Autowired
    private IOutRentRentalMonthService outRentRentalMonthService;
    @Autowired
    private IOutRentRentalQuantitiesService outRentRentalQuantitiesService;

    @Override
    public OutRentRentalVO saveRental(OutRentRentalVO vo) {
        OutRentRentalEntity entity;
        CommonResponse orgResponse;
        List checkList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (null != vo.getId()) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getParentOrgCode()) && vo.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(vo.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            vo.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (OutRentRentalEntity)((Object)BeanMapper.map((Object)vo, OutRentRentalEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)"OUT_RENTCORP_RENTAL", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSettlementState(RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
        super.saveOrUpdate((Object)entity, false);
        return (OutRentRentalVO)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class);
    }

    @Override
    public boolean updateRentalSettlementState(List<Long> ids, Integer state) {
        this.logger.info("\u4fee\u6539\u79df\u91d1\u8ba1\u7b97\u5355\u636e\u72b6\u6001\uff0c\u5355\u636eid\uff1a{}\uff0c\u4fee\u6539\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(ids), (Object)state);
        if (CollectionUtils.isNotEmpty(ids)) {
            if (null == RentalSettlementStateEnum.getEnumByCode(state)) {
                throw new BusinessException("\u7ed3\u7b97\u6807\u5fd7\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u7ed3\u7b97\u6807\u5fd7");
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List saveEntityList = super.queryList(queryParam, false);
            if (CollectionUtils.isEmpty((Collection)saveEntityList)) {
                return false;
            }
            for (OutRentRentalEntity entity : saveEntityList) {
                entity.setSettlementState(state);
            }
            return super.saveOrUpdateBatch((Collection)saveEntityList);
        }
        return false;
    }

    @Override
    public CommonResponse<OutRentRentalVO> pushCost(OutRentRentalVO outRentRentalVO) {
        OutRentRentalEntity entity = (OutRentRentalEntity)((Object)super.selectById((Serializable)outRentRentalVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)outRentRentalVO.getRentRentalDayList())) {
            List dayEntities = BeanMapper.mapList((Iterable)outRentRentalVO.getRentRentalDayList(), OutRentRentalDayEntity.class);
            entity.setRentRentalDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)outRentRentalVO.getRentRentalMonthList())) {
            List monthEntities = BeanMapper.mapList((Iterable)outRentRentalVO.getRentRentalMonthList(), OutRentRentalMonthEntity.class);
            entity.setRentRentalMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)outRentRentalVO.getRentRentalQuantitiesList())) {
            List quantitiesEntities = BeanMapper.mapList((Iterable)outRentRentalVO.getRentRentalQuantitiesList(), OutRentRentalQuantitiesEntity.class);
            entity.setRentRentalQuantitiesList(quantitiesEntities);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class));
    }

    @Override
    public void costPush(OutRentRentalEntity entity) {
        String oldRelationFlag;
        this.logger.info("\u79df\u91d1\u8ba1\u7b97\u5f00\u59cb\u63a8\u9001\u5b9e\u9645\u6210\u672ccostPush");
        List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<OutRentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentRentalDayEntity outRentRentalDayEntity : dayList) {
                if (null != outRentRentalDayEntity.getSubjectId() && null != outRentRentalDayEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentRentalMonthEntity outRentRentalMonthEntity : monthList) {
                if (null != outRentRentalMonthEntity.getSubjectId() && null != outRentRentalMonthEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentRentalQuantitiesEntity outRentRentalQuantitiesEntity : quantitiesList) {
                if (null != outRentRentalQuantitiesEntity.getSubjectId() && null != outRentRentalQuantitiesEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(oldRelationFlag = entity.getRelationFlag())) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u79df\u91d1\u8ba1\u7b97Id---{}", (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(entity);
        }
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        lambdaUpdateWrapper.set(OutRentRentalEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)lambdaUpdateWrapper);
    }

    private void saveCost(OutRentRentalEntity entity) {
        CostDetailVO costDetailVO2;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<OutRentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentRentalDayEntity outRentRentalDayEntity : dayList) {
                CostDetailVO costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)outRentRentalDayEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(outRentRentalDayEntity.getId());
                costDetailVO2.setHappenTaxMny(outRentRentalDayEntity.getRentDayTaxMny());
                costDetailVO2.setHappenMny(outRentRentalDayEntity.getRentDayMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_DAY");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentRentalMonthEntity outRentRentalMonthEntity : monthList) {
                costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)outRentRentalMonthEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(outRentRentalMonthEntity.getId());
                costDetailVO2.setHappenTaxMny(outRentRentalMonthEntity.getRentMonthTaxMny());
                costDetailVO2.setHappenMny(outRentRentalMonthEntity.getRentMonthMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_MONTH");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentRentalQuantitiesEntity outRentRentalQuantitiesEntity : quantitiesList) {
                costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)outRentRentalQuantitiesEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(outRentRentalQuantitiesEntity.getId());
                costDetailVO2.setHappenTaxMny(outRentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                costDetailVO2.setHappenMny(outRentRentalQuantitiesEntity.getRentQuantitiesMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_QUANTITIES");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            String url = "/ejc-proequipmentcorp-frontend/#/rentalList/card?id=" + entity.getId();
            if ("1".equals(entity.getRentalType())) {
                url = "/ejc-proequipmentcorp-frontend/#/rentalList/automaticCard?id=" + entity.getId();
            }
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(entity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u8bbe\u5907\u79df\u91d1\u8ba1\u7b97.getTypeName());
                costDetailVO2.setSourceBillUrl(url);
                costDetailVO2.setSourceId(entity.getId());
                costDetailVO2.setHappenDate(entity.getRentalDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("TEMP_EQ_ZJ");
                costDetailVO2.setProjectId(entity.getProjectId());
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public void delRental(List<OutRentRentalVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public OutRentalSumVo queryRentalMnyByContractId(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = super.queryList(queryParam, false);
        BigDecimal sumRentalTaxMny = BigDecimal.ZERO;
        BigDecimal sumRentalMny = BigDecimal.ZERO;
        OutRentalSumVo vo = new OutRentalSumVo();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return vo;
        }
        for (OutRentRentalEntity entity : list) {
            sumRentalTaxMny = sumRentalTaxMny.add(entity.getRentTotalTaxMny());
            sumRentalMny = sumRentalMny.add(entity.getRentTotalMny());
        }
        vo.setTotalMny(sumRentalMny);
        vo.setTotalTaxMny(sumRentalTaxMny);
        return vo;
    }

    @Override
    public OutRentRentalVO automaticRental(OutRentRentalVO vo) {
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentalDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long contractId = vo.getContractId();
        Date endDate = vo.getRentalDate();
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u8bbe\u5907\u53f0\u8d26\u4fe1\u606fstart");
        List<OutRentParameterVO> rentParameterList = this.parameterService.getRentParameterByContractId(contractId, vo.getId(), endDate);
        HashMap<Long, OutRentParameterVO> rentParameterVOMap = new HashMap<Long, OutRentParameterVO>();
        if (CollectionUtils.isEmpty(rentParameterList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u8bbe\u5907\u9a8c\u6536\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u8bbe\u5907\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rentParameterList));
        this.logger.info(">>>>\u67e5\u8be2\u5408\u540c\u4fe1\u606fstart");
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(contractId));
        this.logger.info("\u4e3b\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        Map<String, Map<Long, List<OutRentRentalCacheVO>>> contractAllMap = this.getContractRecord(contractId, contractEntity, endDate);
        this.logger.info("<<<<\u67e5\u8be2\u5408\u540c\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(contractAllMap));
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        OutRentRentalEntity entity = new OutRentRentalEntity();
        ArrayList<OutRentRentalDayEntity> outRentRentalDayList = new ArrayList<OutRentRentalDayEntity>();
        ArrayList<OutRentRentalMonthEntity> outRentRentalMonthList = new ArrayList<OutRentRentalMonthEntity>();
        ArrayList<OutRentRentalCacheVO> resultDayList = new ArrayList<OutRentRentalCacheVO>();
        ArrayList<OutRentRentalCacheVO> resultMonthList = new ArrayList<OutRentRentalCacheVO>();
        for (OutRentParameterVO parameterVO : rentParameterList) {
            rentParameterVOMap.put(parameterVO.getId(), parameterVO);
            if (RENT_TYPE_DAY.equals(parameterVO.getMeterRentType())) {
                this.packParameterDetailAndContract2(resultDayList, contractAllMap, parameterVO, RENT_TYPE_DAY, contractEntity.getMonthSettlement());
                continue;
            }
            if (!RENT_TYPE_MONTH.equals(parameterVO.getMeterRentType())) continue;
            this.packParameterDetailAndContract2(resultMonthList, contractAllMap, parameterVO, RENT_TYPE_MONTH, contractEntity.getMonthSettlement());
        }
        this.setRentalDayDetailValue(resultDayList, outRentRentalDayList);
        this.setRentalMonthDetailValue(resultMonthList, outRentRentalMonthList);
        if (null == vo.getId()) {
            entity.setRentalType("1");
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            entity.setSettlementState(RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
            entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        }
        if (CollectionUtils.isNotEmpty(outRentRentalDayList)) {
            outRentRentalDayList.forEach(e -> {
                if (null != e.getSourceId() && rentParameterVOMap.containsKey(e.getSourceId())) {
                    e.setDayFactoryCode(((OutRentParameterVO)rentParameterVOMap.get(e.getSourceId())).getFactoryCode());
                }
            });
        }
        if (CollectionUtils.isNotEmpty(outRentRentalMonthList)) {
            outRentRentalMonthList.forEach(e -> {
                if (null != e.getSourceId() && rentParameterVOMap.containsKey(e.getSourceId())) {
                    e.setMonthFactoryCode(((OutRentParameterVO)rentParameterVOMap.get(e.getSourceId())).getFactoryCode());
                }
            });
        }
        entity.setRentRentalDayList(outRentRentalDayList);
        entity.setRentRentalMonthList(outRentRentalMonthList);
        this.setRentalValue(entity, contractEntity, endDate, vo);
        this.logger.info(">>>>\u4fdd\u5b58\u79df\u91d1\u8ba1\u7b97\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        this.logger.info("\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        return (OutRentRentalVO)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class);
    }

    private void setRentalDayDetailValue(List<OutRentRentalCacheVO> resultList, List<OutRentRentalDayEntity> outRentRentalDayList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        for (OutRentRentalCacheVO vo : resultList) {
            OutRentDayRecordVO recordVO = vo.getRentDayRecord();
            OutRentRentalDayEntity dayEntity = new OutRentRentalDayEntity();
            dayEntity.setSourceDetailId(recordVO.getId());
            dayEntity.setSourceName("\u8bbe\u5907\u79df\u8d41\u65e5\u79df-" + recordVO.getEquipmentCode());
            dayEntity.setSourceType(2);
            dayEntity.setSourceCode(recordVO.getCode());
            dayEntity.setEquipmentName(recordVO.getName());
            dayEntity.setDayFactoryCode(recordVO.getDayFactoryCode());
            dayEntity.setCategoryId(recordVO.getCategoryId());
            dayEntity.setCategoryName(recordVO.getCategoryName());
            dayEntity.setSpec(recordVO.getSpec());
            dayEntity.setUnitName(recordVO.getUnitName());
            dayEntity.setDayRentPrice(recordVO.getDayRentPrice());
            dayEntity.setStopRentPrice(recordVO.getStopRentPrice());
            dayEntity.setRentNum(1);
            dayEntity.setTax(recordVO.getTax());
            dayEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            dayEntity.setStopRentNotTaxPrice(recordVO.getStopRentNotTaxPrice());
            dayEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            dayEntity.setPlanOutDate(recordVO.getPlanOutDate());
            dayEntity.setProductionManufactor(recordVO.getProductionManufactor());
            dayEntity.setEquipmentCode(recordVO.getEquipmentCode());
            dayEntity.setEquipmentId(recordVO.getEquipmentId());
            dayEntity.setSourceId(vo.getParameterId());
            dayEntity.setChargingStartDate(vo.getStartDate());
            dayEntity.setChargingEndDate(vo.getEndDate());
            dayEntity.setRentDayDate(this.daysBetween(this.calculationDay(vo.getStartDate(), -1), vo.getEndDate()));
            if (OutRentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getDayRentNotTaxPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getDayRentPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
            } else if (OutRentEquipmentStateEnum.\u505c\u7528.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getStopRentNotTaxPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getStopRentPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
            }
            dayEntity.setRentDayTax(ComputeUtil.safeSub((BigDecimal)dayEntity.getRentDayTaxMny(), (BigDecimal)dayEntity.getRentDayMny()));
            dayEntity.setEquipmentState(vo.getEquipmentState());
            dayEntity.setRowState("add");
            dayEntity.setId(IdWorker.getId());
            outRentRentalDayList.add(dayEntity);
        }
        if (CollectionUtils.isNotEmpty(outRentRentalDayList)) {
            outRentRentalDayList.sort(Comparator.comparing(OutRentRentalDayEntity::getSourceId).thenComparing(OutRentRentalDayEntity::getChargingStartDate));
        }
    }

    private void setRentalMonthDetailValue(List<OutRentRentalCacheVO> resultList, List<OutRentRentalMonthEntity> outRentRentalMonthList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList<OutRentRentalMonthEntity> rstList = new ArrayList<OutRentRentalMonthEntity>();
        for (OutRentRentalCacheVO vo : resultList) {
            OutRentMonthRecordVO recordVO = vo.getRentMonthRecord();
            OutRentRentalMonthEntity monthEntity = new OutRentRentalMonthEntity();
            monthEntity.setSourceDetailId(recordVO.getId());
            monthEntity.setSourceName("\u8bbe\u5907\u79df\u8d41\u6708\u79df-" + recordVO.getEquipmentCode());
            monthEntity.setSourceType(2);
            monthEntity.setSourceCode(recordVO.getCode());
            monthEntity.setEquipmentName(recordVO.getName());
            monthEntity.setMonthFactoryCode(recordVO.getMonthFactoryCode());
            monthEntity.setCategoryId(recordVO.getCategoryId());
            monthEntity.setCategoryName(recordVO.getCategoryName());
            monthEntity.setSpec(recordVO.getSpec());
            monthEntity.setUnitName(recordVO.getUnitName());
            monthEntity.setMonthRentPrice(recordVO.getMonthRentPrice());
            monthEntity.setInsufficientMonthDayRentPrice(recordVO.getInsufficientMonthDayRentPrice());
            monthEntity.setStopRentPrice(recordVO.getStopRentPrice());
            monthEntity.setRentNum(1);
            monthEntity.setTax(recordVO.getTax());
            monthEntity.setMonthRentNotTaxPrice(recordVO.getMonthRentNotTaxPrice());
            monthEntity.setInsufficientMonthNotTaxRentPrice(recordVO.getInsufficientMonthNotTaxRentPrice());
            monthEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            monthEntity.setPlanOutDate(recordVO.getPlanOutDate());
            monthEntity.setProductionManufactor(recordVO.getProductionManufactor());
            monthEntity.setEquipmentCode(recordVO.getEquipmentCode());
            monthEntity.setEquipmentId(recordVO.getEquipmentId());
            monthEntity.setDayTaxPrice(recordVO.getDayTaxPrice());
            monthEntity.setTaxMny(recordVO.getTaxMny());
            monthEntity.setNotTaxMonthPrice(recordVO.getNotTaxMonthPrice());
            monthEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            monthEntity.setNotTaxStopPrice(recordVO.getNotTaxStopPrice());
            monthEntity.setSourceId(vo.getParameterId());
            monthEntity.setChargingStartDate(vo.getStartDate());
            monthEntity.setChargingEndDate(vo.getEndDate());
            if (OutRentEquipmentStateEnum.\u505c\u7528.getCode().equals(vo.getEquipmentState())) {
                Integer days = this.daysBetween(this.calculationDay(vo.getStartDate(), -1), vo.getEndDate());
                monthEntity.setRentMonthMny(this.getMny(monthEntity.getNotTaxStopPrice(), days, monthEntity.getRentNum()));
                monthEntity.setRentMonthTaxMny(this.getMny(monthEntity.getStopRentPrice(), days, monthEntity.getRentNum()));
                monthEntity.setRentDayDate(days);
            } else {
                this.monthSum(monthEntity, vo);
            }
            monthEntity.setRentMonthTax(ComputeUtil.safeSub((BigDecimal)monthEntity.getRentMonthTaxMny(), (BigDecimal)monthEntity.getRentMonthMny()));
            monthEntity.setEquipmentState(vo.getEquipmentState());
            monthEntity.setRowState("add");
            monthEntity.setId(IdWorker.getId());
            rstList.add(monthEntity);
        }
        rstList.sort(Comparator.comparing(OutRentRentalMonthEntity::getChargingStartDate));
        this.logger.info("\u5408\u5e76\u524d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(rstList));
        outRentRentalMonthList.addAll(rstList);
        if (CollectionUtils.isNotEmpty(outRentRentalMonthList)) {
            outRentRentalMonthList.sort(Comparator.comparing(OutRentRentalMonthEntity::getSourceId).thenComparing(OutRentRentalMonthEntity::getChargingStartDate));
        }
    }

    private void setQuantitiesByUseRecord(List<OutRentRentalQuantitiesEntity> outRentRentalQuantitiesList, OutRentContractEntity contractEntity, Date endDate) {
        this.logger.info(">>>>\u5f00\u59cb\u8ba1\u7b97\u5de5\u7a0b\u91cf\u79df");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("createTime", new Parameter("le", (Object)endDate));
        queryParam.getParams().put("rentalFlag", new Parameter("ne", (Object)1));
        List useRecordEntityList = this.useRecordService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)useRecordEntityList)) {
            return;
        }
        List useIdList = useRecordEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter("in", useIdList));
        List useDetailList = this.useRecordSubService.queryList(detailParam, false);
        HashMap map = new HashMap();
        for (UseRecordSubEntity detailEntity : useDetailList) {
            if (map.containsKey(detailEntity.getPid())) {
                ((List)map.get(detailEntity.getPid())).add(detailEntity);
                continue;
            }
            ArrayList<UseRecordSubEntity> packList = new ArrayList<UseRecordSubEntity>();
            packList.add(detailEntity);
            map.put(detailEntity.getPid(), packList);
        }
        for (UseRecordEntity use : useRecordEntityList) {
            List detailList = (List)map.get(use.getId());
            for (UseRecordSubEntity detail : detailList) {
                OutRentRentalQuantitiesEntity entity = new OutRentRentalQuantitiesEntity();
                entity.setSourceDetailId(detail.getId());
                entity.setSourceName("\u8bbe\u5907\u79df\u8d41\u5de5\u7a0b\u91cf\u79df-" + detail.getEquipmentId());
                entity.setSourceType(2);
                entity.setSourceId(use.getId());
                entity.setEquipmentName(detail.getEquipmentName());
                entity.setQuantitiesFactoryCode(detail.getEquipmentExitCode());
                entity.setCategoryId(detail.getEquipmentTypeId());
                entity.setCategoryName(detail.getEquipmentType());
                entity.setSpec(detail.getSpec());
                entity.setUnitName(detail.getUnit());
                entity.setQuantitiesNum(detail.getBillingWorkload());
                entity.setQuantitiesPrice(detail.getContractTaxPrice());
                entity.setRentNum(1);
                entity.setTax(contractEntity.getContractTax());
                entity.setEquipmentId(detail.getEquipmentId());
                entity.setNotTaxQuantitiesPrice(detail.getContractPrice());
                entity.setBillingUnitName(detail.getBillingUnit());
                entity.setChargingStartDate(use.getStartDate());
                entity.setChargingEndDate(use.getEndDate());
                entity.setRentQuantitiesMny(detail.getMny());
                entity.setRentQuantitiesTaxMny(detail.getTaxMny());
                entity.setRentQuantitiesTax(detail.getTax());
                entity.setRowState("add");
                entity.setId(IdWorker.getId());
                outRentRentalQuantitiesList.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(outRentRentalQuantitiesList)) {
            outRentRentalQuantitiesList.sort(Comparator.comparing(OutRentRentalQuantitiesEntity::getEquipmentId).thenComparing(OutRentRentalQuantitiesEntity::getChargingStartDate));
        }
        this.logger.info("<<<<\u8ba1\u7b97\u5de5\u7a0b\u91cf\u79df\u7ed3\u675f\uff0c\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(outRentRentalQuantitiesList));
    }

    private void monthSum(OutRentRentalMonthEntity monthEntity, OutRentRentalCacheVO vo) {
        Date startDate = monthEntity.getChargingStartDate();
        startDate = this.calculationDay(startDate, -1);
        int[] mo = this.dayCompare(startDate, monthEntity.getChargingEndDate());
        int month = mo[0];
        int day = mo[1];
        Integer rentNum = monthEntity.getRentNum();
        BigDecimal monthMny = this.getMny(monthEntity.getMonthRentNotTaxPrice(), month, rentNum);
        BigDecimal monthTaxMny = this.getMny(monthEntity.getMonthRentPrice(), month, rentNum);
        BigDecimal dayMny = this.getMny(monthEntity.getInsufficientMonthNotTaxRentPrice(), day, rentNum);
        BigDecimal dayTaxMny = this.getMny(monthEntity.getInsufficientMonthDayRentPrice(), day, rentNum);
        monthEntity.setRentMonthMny(monthMny.add(dayMny));
        monthEntity.setRentMonthTaxMny(monthTaxMny.add(dayTaxMny));
        monthEntity.setRentMonthDate(month);
        monthEntity.setRentDayDate(day);
    }

    private void setRentalValue(OutRentRentalEntity entity, OutRentContractEntity contractEntity, Date date, OutRentRentalVO vo) {
        entity.setProjectId(vo.getProjectId());
        entity.setProjectCode(vo.getProjectCode());
        entity.setProjectName(vo.getProjectName());
        entity.setOrgId(vo.getOrgId());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setParentOrgId(vo.getParentOrgId());
        entity.setParentOrgCode(vo.getParentOrgCode());
        entity.setParentOrgName(vo.getParentOrgName());
        entity.setContractId(contractEntity.getId());
        entity.setContractName(contractEntity.getContractName());
        entity.setContractCode(contractEntity.getContractCode());
        entity.setSupplierId(contractEntity.getSupplierId());
        entity.setSupplierName(contractEntity.getSupplierName());
        entity.setRentalDate(date);
        entity.setMeterRentType(contractEntity.getMeterRentType());
        entity.setMeterRentTypeName(contractEntity.getMeterRentTypeName());
        BigDecimal rentTotalMny = BigDecimal.ZERO;
        BigDecimal rentTotalTaxMny = BigDecimal.ZERO;
        BigDecimal rentTotalTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getRentRentalDayList())) {
            for (OutRentRentalDayEntity outRentRentalDayEntity : entity.getRentRentalDayList()) {
                if (this.isDetailDel(outRentRentalDayEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(outRentRentalDayEntity.getRentDayMny());
                rentTotalTaxMny = rentTotalTaxMny.add(outRentRentalDayEntity.getRentDayTaxMny());
                rentTotalTax = rentTotalTax.add(outRentRentalDayEntity.getRentDayTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalMonthList())) {
            for (OutRentRentalMonthEntity outRentRentalMonthEntity : entity.getRentRentalMonthList()) {
                if (this.isDetailDel(outRentRentalMonthEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(outRentRentalMonthEntity.getRentMonthMny());
                rentTotalTaxMny = rentTotalTaxMny.add(outRentRentalMonthEntity.getRentMonthTaxMny());
                rentTotalTax = rentTotalTax.add(outRentRentalMonthEntity.getRentMonthTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalQuantitiesList())) {
            for (OutRentRentalQuantitiesEntity outRentRentalQuantitiesEntity : entity.getRentRentalQuantitiesList()) {
                if (this.isDetailDel(outRentRentalQuantitiesEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(outRentRentalQuantitiesEntity.getRentQuantitiesMny());
                rentTotalTaxMny = rentTotalTaxMny.add(outRentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                rentTotalTax = rentTotalTax.add(outRentRentalQuantitiesEntity.getRentQuantitiesTax());
            }
        }
        entity.setRentTotalMny(rentTotalMny);
        entity.setRentTotalTaxMny(rentTotalTaxMny);
        entity.setRentTotalTax(rentTotalTax);
    }

    private void packParameterDetailAndContract(List<OutRentRentalCacheVO> resultList, Map<String, Map<Long, List<OutRentRentalCacheVO>>> contractAllMap, OutRentParameterVO parameterVO, String rentType, String monthSettlement) {
        Map<Long, List<OutRentRentalCacheVO>> map = contractAllMap.get(rentType);
        List<OutRentRentalCacheVO> cacheList = map.get(parameterVO.getEquipmentId());
        cacheList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        List parameterDetailList = parameterVO.getRentParameterDetailList();
        List<OutRentRentalCacheVO> resultList2 = new ArrayList<OutRentRentalCacheVO>();
        parameterDetailList.sort(Comparator.comparing(OutRentParameterDetailVO::getOperationDate));
        for (OutRentRentalCacheVO cacheVO : cacheList) {
            if (parameterDetailList.size() == 1) {
                OutRentParameterDetailVO detailVO = (OutRentParameterDetailVO)parameterDetailList.get(0);
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                    this.setRecordByRentType(cacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO.getEquipmentState())) continue;
                    OutRentRentalCacheVO rstvo2 = new OutRentRentalCacheVO();
                    rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                    rstvo2.setEndDate(cacheVO.getEndDate());
                    rstvo2.setEquipmentState(detailVO.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    if (!this.checkCacheVoIsMerge(rstVo, rstvo2)) continue;
                    resultList2.add(rstvo2);
                    continue;
                }
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate()) || detailVO.getOperationDate().after(cacheVO.getEndDate())) continue;
                OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                this.setRecordByRentType(cacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEndDate(cacheVO.getEndDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                resultList2.add(rstVo);
                continue;
            }
            int parameterListLength = parameterDetailList.size() - 1;
            for (int i = 0; i < parameterListLength; ++i) {
                OutRentRentalCacheVO rstvo2;
                OutRentParameterDetailVO detailVO = (OutRentParameterDetailVO)parameterDetailList.get(i);
                OutRentParameterDetailVO detailVO1 = (OutRentParameterDetailVO)parameterDetailList.get(i + 1);
                this.logger.info("cacheVo:\u3010{}\u3011\uff0cdetail:\u3010{}\u3011\uff0cdetail1\uff1a\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)cacheVO), JSONObject.toJSONString((Object)detailVO), JSONObject.toJSONString((Object)detailVO1)});
                OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                this.setRecordByRentType(cacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO.getEquipmentState())) continue;
                    rstvo2 = new OutRentRentalCacheVO();
                    rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                    rstvo2.setEndDate(cacheVO.getEndDate());
                    rstvo2.setEquipmentState(detailVO.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    if (!this.checkCacheVoIsMerge(rstVo, rstvo2)) continue;
                    resultList2.add(rstvo2);
                    continue;
                }
                if (!detailVO.getOperationDate().before(cacheVO.getStartDate()) && !detailVO1.getOperationDate().after(cacheVO.getEndDate())) {
                    Date detailStartDate = detailVO.getOperationDate();
                    rstVo.setStartDate(detailStartDate);
                    rstVo.setEndDate(detailVO1.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO1.getEquipmentState()) || i != parameterListLength - 1) continue;
                    OutRentRentalCacheVO rstvo22 = new OutRentRentalCacheVO();
                    rstvo22.setStartDate(this.dayAddOne(detailVO1.getOperationDate()));
                    rstvo22.setEndDate(cacheVO.getEndDate());
                    rstvo22.setEquipmentState(detailVO1.getEquipmentState());
                    rstvo22.setRentType(rentType);
                    rstvo22.setParameterId(parameterVO.getId());
                    rstvo22.setParameterType(detailVO1.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo22, rentType);
                    resultList2.add(rstvo22);
                    continue;
                }
                if (!detailVO.getOperationDate().before(cacheVO.getStartDate()) && !detailVO1.getOperationDate().before(cacheVO.getEndDate())) {
                    if (i != 0) {
                        OutRentRentalCacheVO rstvo1 = new OutRentRentalCacheVO();
                        rstvo1.setStartDate(cacheVO.getStartDate());
                        rstvo1.setEndDate(detailVO.getOperationDate());
                        rstvo1.setEquipmentState(detailVO.getEquipmentState());
                        rstvo1.setRentType(rentType);
                        rstvo1.setParameterId(parameterVO.getId());
                        rstvo1.setParameterType(detailVO.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo1, rentType);
                        resultList2.add(rstvo1);
                    }
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getEndDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    rstvo2 = new OutRentRentalCacheVO();
                    rstvo2.setStartDate(cacheVO.getEndDate());
                    rstvo2.setEndDate(detailVO1.getOperationDate());
                    rstvo2.setEquipmentState(detailVO1.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO1.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    resultList2.add(rstvo2);
                    continue;
                }
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEndDate(detailVO1.getOperationDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                resultList2.add(rstVo);
            }
        }
        resultList2 = this.packResultCacheVo(resultList2, monthSettlement);
        resultList.addAll(resultList2);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private void packParameterDetailAndContract2(List<OutRentRentalCacheVO> resultList, Map<String, Map<Long, List<OutRentRentalCacheVO>>> contractAllMap, OutRentParameterVO parameterVO, String rentType, String monthSettlement) {
        OutRentParameterDetailVO detailVO;
        Map<Long, List<OutRentRentalCacheVO>> map = contractAllMap.get(rentType);
        List<OutRentRentalCacheVO> cacheList = map.get(parameterVO.getEquipmentId());
        int size = cacheList.size();
        cacheList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        List parameterDetailList = parameterVO.getRentParameterDetailList();
        int num = parameterDetailList.size();
        if (num > 0) {
            OutRentParameterDetailVO rentParameterDetailVO = (OutRentParameterDetailVO)parameterDetailList.get(num - 1);
            OutRentRentalCacheVO rentRentalCacheVO = cacheList.get(size - 1);
            if (OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(rentParameterDetailVO.getEquipmentState()) && !rentParameterDetailVO.getOperationDate().before(rentRentalCacheVO.getEndDate())) {
                ((OutRentParameterDetailVO)parameterDetailList.get(num - 1)).setOperationDate(rentRentalCacheVO.getEndDate());
            } else if (!OutRentEquipmentStateEnum.\u9000\u573a.getCode().equals(rentParameterDetailVO.getEquipmentState()) || !rentParameterDetailVO.getOperationDate().before(rentRentalCacheVO.getEndDate())) {
                OutRentParameterDetailVO endRentParameterDetailVO = new OutRentParameterDetailVO();
                endRentParameterDetailVO.setOperationDate(rentRentalCacheVO.getEndDate());
                endRentParameterDetailVO.setEquipmentState(rentParameterDetailVO.getEquipmentState());
                endRentParameterDetailVO.setSourceType("2");
                parameterDetailList.add(endRentParameterDetailVO);
            }
        }
        ArrayList<OutRentRentalCacheVO> newResultList = new ArrayList<OutRentRentalCacheVO>();
        List<OutRentRentalCacheVO> resultList2 = new ArrayList<OutRentRentalCacheVO>();
        parameterDetailList.sort(Comparator.comparing(OutRentParameterDetailVO::getOperationDate));
        if (CollectionUtils.isNotEmpty(cacheList) && cacheList.size() == 1) {
            for (int i = 0; i < parameterDetailList.size(); ++i) {
                OutRentParameterDetailVO detailVO2 = (OutRentParameterDetailVO)parameterDetailList.get(i);
                OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                this.setRecordByRentType(cacheList.get(0), rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO2.getOperationDate());
                rstVo.setEquipmentState(detailVO2.getEquipmentState());
                rstVo.setParameterType(detailVO2.getSourceType());
                newResultList.add(rstVo);
            }
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                cacheList.get(0).setStartDate(dateFormat.parse("2000-01-01 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < parameterDetailList.size(); ++i) {
                detailVO = (OutRentParameterDetailVO)parameterDetailList.get(i);
                OutRentRentalCacheVO conCacheVO = cacheList.get(0);
                if (0 == i) {
                    for (int k = 0; k < cacheList.size(); ++k) {
                        Date conStartDate = cacheList.get(k).getStartDate();
                        Date c1 = detailVO.getOperationDate();
                        if (!c1.after(conStartDate)) continue;
                        conCacheVO = cacheList.get(k);
                    }
                    OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                    this.setRecordByRentType(conCacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    newResultList.add(rstVo);
                    continue;
                }
                OutRentParameterDetailVO detailVOLast = (OutRentParameterDetailVO)parameterDetailList.get(i - 1);
                for (int k = 0; k < cacheList.size(); ++k) {
                    Date conStartDate = cacheList.get(k).getStartDate();
                    Date c1 = detailVO.getOperationDate();
                    Date c2 = detailVOLast.getOperationDate();
                    if (!c1.after(conStartDate)) continue;
                    conCacheVO = cacheList.get(k);
                    if (!c2.before(conStartDate)) continue;
                    OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                    this.setRecordByRentType(cacheList.get(k), rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(cacheList.get(k).getStartDate());
                    rstVo.setEquipmentState(detailVOLast.getEquipmentState());
                    rstVo.setParameterType("-1");
                    newResultList.add(rstVo);
                }
                OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                this.setRecordByRentType(conCacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                newResultList.add(rstVo);
            }
        }
        if (CollectionUtils.isNotEmpty(newResultList)) {
            for (int i = 1; i < newResultList.size(); ++i) {
                OutRentRentalCacheVO detailVOLast = (OutRentRentalCacheVO)newResultList.get(i - 1);
                detailVO = (OutRentRentalCacheVO)newResultList.get(i);
                if (i == newResultList.size() - 1) {
                    detailVOLast.setEndDate(detailVO.getStartDate());
                } else {
                    detailVOLast.setEndDate(this.daySubOne(detailVO.getStartDate()));
                }
                resultList2.add(detailVOLast);
            }
        }
        resultList2 = this.packResultCacheVo(resultList2, monthSettlement);
        resultList.addAll(resultList2);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private boolean checkCacheVoIsMerge(OutRentRentalCacheVO vo1, OutRentRentalCacheVO vo2) {
        BigDecimal price2;
        BigDecimal price1;
        if (!vo1.getEquipmentState().equals(vo2.getEquipmentState())) {
            return true;
        }
        if (RENT_TYPE_DAY.equals(vo1.getRentType())) {
            if (OutRentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentDayRecord().getDayRentPrice();
                price2 = vo2.getRentDayRecord().getDayRentPrice();
            } else {
                price1 = vo1.getRentDayRecord().getStopRentPrice();
                price2 = vo2.getRentDayRecord().getStopRentPrice();
            }
        } else if (RENT_TYPE_MONTH.equals(vo1.getRentType())) {
            if (OutRentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentMonthRecord().getMonthRentPrice();
                price2 = vo2.getRentMonthRecord().getMonthRentPrice();
            } else {
                price1 = vo1.getRentMonthRecord().getStopRentPrice();
                price2 = vo2.getRentMonthRecord().getStopRentPrice();
            }
        } else if (RENT_TYPE_QUANTITIES.equals(vo1.getRentType())) {
            price1 = vo1.getRentQuantitiesRecord().getQuantitiesPrice();
            price2 = vo2.getRentQuantitiesRecord().getQuantitiesPrice();
        } else {
            return true;
        }
        if (price1.equals(price2)) {
            vo1.setEndDate(vo2.getEndDate());
            return false;
        }
        return true;
    }

    private List<OutRentRentalCacheVO> packResultCacheVo(List<OutRentRentalCacheVO> resultList, String monthSettlement) {
        ArrayList<OutRentRentalCacheVO> rtnList = new ArrayList<OutRentRentalCacheVO>();
        for (OutRentRentalCacheVO vo : resultList) {
            if (RENT_TYPE_MONTH.equals(vo.getRentType())) {
                Date ed;
                Date endUpDate;
                Date startBeginDate = this.monthDay(vo.getStartDate(), monthSettlement);
                Date startEndDate = this.monthDay(this.monthAddOne(vo.getStartDate()), monthSettlement);
                Date endBeginDate = this.monthDay(vo.getEndDate(), monthSettlement);
                Date endEndDate = this.monthDay(this.monthAddOne(vo.getEndDate()), monthSettlement);
                if (!vo.getStartDate().after(startBeginDate)) {
                    if (!vo.getEndDate().after(startBeginDate)) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (!vo.getEndDate().before(startBeginDate) && !vo.getEndDate().after(startEndDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        this.setRstValue(this.dayAddOne(startBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        if (endUpDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startBeginDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        } else {
                            this.setRstValue(this.dayAddOne(startBeginDate), startEndDate, vo, rtnList);
                            ed = startEndDate;
                        }
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        if (!endBeginDate.before(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startBeginDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                if (vo.getStartDate().after(startBeginDate)) {
                    if (!vo.getEndDate().after(startEndDate)) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        if (endUpDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startEndDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        } else {
                            ed = startEndDate;
                        }
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        if (endBeginDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startEndDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                rtnList.add(vo);
                continue;
            }
            rtnList.add(vo);
        }
        rtnList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        return rtnList;
    }

    private void setRstValue(Date start, Date end, OutRentRentalCacheVO vo, List<OutRentRentalCacheVO> rtnList) {
        OutRentRentalCacheVO rstvo1 = new OutRentRentalCacheVO();
        rstvo1.setStartDate(start);
        rstvo1.setEndDate(end);
        rstvo1.setEquipmentState(vo.getEquipmentState());
        rstvo1.setRentType(vo.getRentType());
        rstvo1.setRentMonthRecord(vo.getRentMonthRecord());
        rstvo1.setParameterId(vo.getParameterId());
        rstvo1.setParameterType(vo.getParameterType());
        rtnList.add(rstvo1);
    }

    private void setRecordByRentType(OutRentRentalCacheVO cacheVO, OutRentRentalCacheVO rstVo, String rentType) {
        if (RENT_TYPE_DAY.equals(rentType)) {
            rstVo.setRentDayRecord(cacheVO.getRentDayRecord());
        } else if (RENT_TYPE_MONTH.equals(rentType)) {
            rstVo.setRentMonthRecord(cacheVO.getRentMonthRecord());
        } else if (RENT_TYPE_QUANTITIES.equals(rentType)) {
            rstVo.setRentQuantitiesRecord(cacheVO.getRentQuantitiesRecord());
        }
    }

    private Map<String, Map<Long, List<OutRentRentalCacheVO>>> getContractRecord(Long contractId, OutRentContractEntity contractEntity, Date endDate) {
        HashMap<String, Map<Long, List<OutRentRentalCacheVO>>> rtnMap = new HashMap<String, Map<Long, List<OutRentRentalCacheVO>>>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("changeDate", new Parameter("le", (Object)endDate));
        queryParam.getOrderMap().put("changeDate", "asc");
        List recordList = this.contractRecordService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            this.packContractMap(contractEntity, rtnMap, contractEntity.getSignedDate(), endDate);
            this.logger.info("\u5408\u540c\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u8bb0\u5f55\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
            return rtnMap;
        }
        List recordIdList = recordList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("recordId", new Parameter("in", recordIdList));
        List dayRecordEntityList = this.dayRecordService.queryList(detailParam, false);
        List monthRecordEntityList = this.monthRecordService.queryList(detailParam, false);
        List quantitiesRecordEntityList = this.quantitiesRecordService.queryList(detailParam, false);
        HashMap dayMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dayRecordEntityList)) {
            for (Object dayRecordEntity : dayRecordEntityList) {
                if (dayMap.containsKey(dayRecordEntity.getRecordId())) {
                    ((List)dayMap.get(dayRecordEntity.getRecordId())).add(dayRecordEntity);
                    continue;
                }
                ArrayList<Object> packList = new ArrayList<Object>();
                packList.add(dayRecordEntity);
                dayMap.put(dayRecordEntity.getRecordId(), packList);
            }
        }
        HashMap monthMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)monthRecordEntityList)) {
            for (Object monthRecordEntity : monthRecordEntityList) {
                if (monthMap.containsKey(monthRecordEntity.getRecordId())) {
                    ((List)monthMap.get(monthRecordEntity.getRecordId())).add(monthRecordEntity);
                    continue;
                }
                ArrayList<Object> packList = new ArrayList<Object>();
                packList.add(monthRecordEntity);
                monthMap.put(monthRecordEntity.getRecordId(), packList);
            }
        }
        HashMap quantitiesMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)quantitiesRecordEntityList)) {
            for (OutRentQuantitiesRecordEntity quantitiesRecordEntity : quantitiesRecordEntityList) {
                if (quantitiesMap.containsKey(quantitiesRecordEntity.getRecordId())) {
                    ((List)quantitiesMap.get(quantitiesRecordEntity.getRecordId())).add(quantitiesRecordEntity);
                    continue;
                }
                ArrayList<OutRentQuantitiesRecordEntity> packList = new ArrayList<OutRentQuantitiesRecordEntity>();
                packList.add(quantitiesRecordEntity);
                quantitiesMap.put(quantitiesRecordEntity.getRecordId(), packList);
            }
        }
        Date startDate = null;
        Date recordEndDate = null;
        for (int i = 0; i < recordList.size(); ++i) {
            Map<Long, List<Object>> detailMap;
            OutRentRentalCacheVO cacheVO;
            OutRentContractRecordEntity recordEntity = (OutRentContractRecordEntity)((Object)recordList.get(i));
            recordEntity.setRentDayDetailedList((List)dayMap.get(recordEntity.getId()));
            recordEntity.setRentMonthDetailedList((List)monthMap.get(recordEntity.getId()));
            recordEntity.setRentQuantitiesDetailedList((List)quantitiesMap.get(recordEntity.getId()));
            if (startDate == null) {
                startDate = recordEntity.getSignedDate();
            }
            if (!startDate.after(recordEndDate = recordEntity.getChangeDate())) continue;
            if (CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())) {
                HashMap<Long, List<OutRentRentalCacheVO>> recordDayMap = (HashMap<Long, List<OutRentRentalCacheVO>>)rtnMap.get(RENT_TYPE_DAY);
                if (recordDayMap == null) {
                    recordDayMap = new HashMap<Long, List<OutRentRentalCacheVO>>();
                }
                for (OutRentDayRecordEntity outRentDayRecordEntity : recordEntity.getRentDayDetailedList()) {
                    cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_DAY);
                    cacheVO.setEquipmentId(outRentDayRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentDayRecord((OutRentDayRecordVO)BeanMapper.map((Object)((Object)outRentDayRecordEntity), OutRentDayRecordVO.class));
                    this.packCacheMap(cacheVO, recordDayMap);
                }
                rtnMap.put(RENT_TYPE_DAY, recordDayMap);
            }
            if (CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())) {
                detailMap = (HashMap<Long, List<OutRentRentalCacheVO>>)rtnMap.get(RENT_TYPE_MONTH);
                if (detailMap == null) {
                    detailMap = new HashMap<Long, List<OutRentRentalCacheVO>>();
                }
                for (OutRentMonthRecordEntity outRentMonthRecordEntity : recordEntity.getRentMonthDetailedList()) {
                    cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_MONTH);
                    cacheVO.setEquipmentId(outRentMonthRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentMonthRecord((OutRentMonthRecordVO)BeanMapper.map((Object)((Object)outRentMonthRecordEntity), OutRentMonthRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_MONTH, detailMap);
            }
            if (CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())) {
                detailMap = (Map)rtnMap.get(RENT_TYPE_QUANTITIES);
                if (detailMap == null) {
                    detailMap = new HashMap();
                }
                for (OutRentQuantitiesRecordEntity outRentQuantitiesRecordEntity : recordEntity.getRentQuantitiesDetailedList()) {
                    cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                    cacheVO.setEquipmentId(outRentQuantitiesRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentQuantitiesRecord((OutRentQuantitiesRecordVO)BeanMapper.map((Object)((Object)outRentQuantitiesRecordEntity), OutRentQuantitiesRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
            }
            startDate = recordEntity.getChangeDate();
        }
        this.packContractMap(contractEntity, rtnMap, recordEndDate, endDate);
        this.logger.info("\u5904\u7406\u5408\u540c\u4fe1\u606f\u7ed3\u675f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
        return rtnMap;
    }

    private void packCacheMap(OutRentRentalCacheVO cacheVO, Map<Long, List<OutRentRentalCacheVO>> map) {
        if (map == null) {
            map = new HashMap<Long, List<OutRentRentalCacheVO>>();
        }
        if (map.containsKey(cacheVO.getEquipmentId())) {
            map.get(cacheVO.getEquipmentId()).add(cacheVO);
        } else {
            ArrayList<OutRentRentalCacheVO> packList = new ArrayList<OutRentRentalCacheVO>();
            packList.add(cacheVO);
            map.put(cacheVO.getEquipmentId(), packList);
        }
    }

    private void packContractMap(OutRentContractEntity contractEntity, Map<String, Map<Long, List<OutRentRentalCacheVO>>> rtnMap, Date startDate, Date endDate) {
        OutRentRentalCacheVO cacheVO;
        Map<Long, List<OutRentRentalCacheVO>> detailMap;
        if (endDate.before(startDate)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_DAY);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<OutRentRentalCacheVO>>();
            }
            for (OutRentDayDetailedEntity outRentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_DAY);
                cacheVO.setEquipmentId(outRentDayDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentDayRecord((OutRentDayRecordVO)BeanMapper.map((Object)((Object)outRentDayDetailedEntity), OutRentDayRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_DAY, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_MONTH);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<OutRentRentalCacheVO>>();
            }
            for (OutRentMonthDetailedEntity outRentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_MONTH);
                cacheVO.setEquipmentId(outRentMonthDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentMonthRecord((OutRentMonthRecordVO)BeanMapper.map((Object)((Object)outRentMonthDetailedEntity), OutRentMonthRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_MONTH, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_QUANTITIES);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<OutRentRentalCacheVO>>();
            }
            for (OutRentQuantitiesDetailedEntity outRentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                cacheVO.setEquipmentId(outRentQuantitiesDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentQuantitiesRecord((OutRentQuantitiesRecordVO)BeanMapper.map((Object)((Object)outRentQuantitiesDetailedEntity), OutRentQuantitiesRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
        }
    }

    private Integer daysBetween(Date smdate, Date bdate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u671f\u8ba1\u7b97\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private Date monthDay(Date date, String monthSettlement) {
        Calendar from = Calendar.getInstance();
        from.setTime(date);
        int fromYear = from.get(1);
        int fromMonth = from.get(2);
        int settlement = Integer.parseInt(monthSettlement);
        GregorianCalendar myCalendar = new GregorianCalendar(fromYear, fromMonth, settlement);
        return myCalendar.getTime();
    }

    private Date dayAddOne(Date date) {
        return this.calculationDay(date, 1);
    }

    private Date daySubOne(Date date) {
        return this.calculationDay(date, -1);
    }

    private Date calculationDay(Date date, Integer days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    private Date monthAddOne(Date date) {
        return this.calculationMonth(date, 1);
    }

    private Date calculationMonth(Date date, Integer month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    private BigDecimal getMny(BigDecimal bigDecimal, Integer days, Integer nums) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.multiply(new BigDecimal(days)).multiply(new BigDecimal(nums));
    }

    public int[] dayCompare(Date fromDate, Date toDate) {
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }

    private boolean isDetailDel(String rowState) {
        return "del".equals(rowState);
    }
}

