/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceEntity;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceSubEntity;
import com.ejianc.business.proequipmentcorpout.appearance.service.IOutAppearanceService;
import com.ejianc.business.proequipmentcorpout.appearance.vo.OutAppearanceSubVO;
import com.ejianc.business.proequipmentcorpout.appearance.vo.OutAppearanceVO;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outAppearance")
public class OutAppearanceBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutAppearanceService service;
    @Autowired
    private IOutRentParameterService rentParameterService;
    @Autowired
    private IRentParameterService parameterService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IRentReceiptsApi receiptsApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        ArrayList<OutRentParameterEntity> parameterList = new ArrayList<OutRentParameterEntity>();
        List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        for (OutAppearanceSubEntity subEntity : appearanceSubList) {
            OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setOutDate(e.getAppearanceDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
            parameterEntity.setEquipmentStateName(RentEquipmentStateEnum.\u9000\u573a.getDescription());
            if (!OutRentEquipmentStateEnum.\u505c\u79df.getCode().equals(subEntity.getState())) {
                ArrayList<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<OutRentParameterDetailEntity>();
                OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
                detailEntity.setSourceId(e.getId());
                detailEntity.setOperationDate(subEntity.getRentEndDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
            }
            parameterList.add(parameterEntity);
            OutRentParameterEntity outRentParameterEntity = (OutRentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
            int type = outRentParameterEntity.getSourceType();
            if (0 == type) {
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(outRentParameterEntity.getEquipLedgerId()));
                assetEntity.setEquipmentStatus(3);
                assetEntity.setProjectId(null);
                assetEntity.setProjectName(null);
                this.assetService.updateById((Object)assetEntity);
                continue;
            }
            RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)this.parameterService.selectById(outRentParameterEntity.getEquipLedgerId()));
            rentParameterEntity.setUseType(1);
            rentParameterEntity.setUseProjectId(null);
            rentParameterEntity.setUseProjectName(null);
            rentParameterEntity.setUseProjectCode(null);
            rentParameterEntity.setUseOrgId(null);
            rentParameterEntity.setUseOrgCode(null);
            rentParameterEntity.setUseOrgName(null);
            this.parameterService.updateById((Object)rentParameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
        if (e.getRentHarborType() == 1) {
            OutAppearanceVO outAppearanceVO = (OutAppearanceVO)BeanMapper.map((Object)((Object)e), OutAppearanceVO.class);
            outAppearanceVO.setOrgId(e.getOutOrgId());
            outAppearanceVO.setOrgName(e.getOutOrgName());
            outAppearanceVO.setOrgCode(e.getOutOrgCode());
            this.logger.info("outAppearanceVO\uff1a{}", (Object)JSONObject.toJSONString((Object)outAppearanceVO));
            outAppearanceVO.setAppearanceSubList(BeanMapper.mapList(e.getAppearanceSubList(), OutAppearanceSubVO.class));
            CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)outAppearanceVO), RentReceiptsEnum.\u9000\u573a\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636e\u6210\u529f\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)response.getMsg()));
        }
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity entity = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        if (entity.getNotSignature().booleanValue()) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        List<Long> parameterIdList = appearanceSubList.stream().filter(item -> OutRentEquipmentStateEnum.\u505c\u79df.getCode() != item.getState()).map(OutAppearanceSubEntity::getSourceId).collect(Collectors.toList());
        List parameterStopRentIdList = appearanceSubList.stream().filter(item -> OutRentEquipmentStateEnum.\u505c\u79df.getCode() == item.getState()).map(OutAppearanceSubEntity::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(parameterIdList)) {
            this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode(), e.getId());
        }
        if (CollectionUtils.isNotEmpty(parameterStopRentIdList)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", parameterStopRentIdList);
            updateWrapper.set((Object)"equipment_state", (Object)RentEquipmentStateEnum.\u9000\u573a.getCode());
            updateWrapper.set((Object)"equipment_state_name", (Object)RentEquipmentStateEnum.\u9000\u573a.getDescription());
            updateWrapper.set((Object)"out_date", null);
            updateWrapper.set((Object)"operation_date", (Object)new Date());
            this.rentParameterService.update((Wrapper)updateWrapper);
        }
        for (OutAppearanceSubEntity subEntity : appearanceSubList) {
            OutRentParameterEntity outRentParameterEntity = (OutRentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
            int type = outRentParameterEntity.getSourceType();
            if (0 == type) {
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(outRentParameterEntity.getEquipLedgerId()));
                assetEntity.setEquipmentStatus(1);
                this.assetService.updateById((Object)assetEntity);
                continue;
            }
            RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)this.parameterService.selectById(outRentParameterEntity.getEquipLedgerId()));
            rentParameterEntity.setUseType(2);
            rentParameterEntity.setUseProjectId(outRentParameterEntity.getUseProjectId());
            rentParameterEntity.setUseProjectName(outRentParameterEntity.getProjectName());
            rentParameterEntity.setUseProjectCode(outRentParameterEntity.getProjectCode());
            rentParameterEntity.setUseOrgId(outRentParameterEntity.getUseOrgId());
            rentParameterEntity.setUseOrgCode(outRentParameterEntity.getUseOrgCode());
            rentParameterEntity.setUseOrgName(outRentParameterEntity.getUseOrgName());
            this.parameterService.updateById((Object)rentParameterEntity);
        }
        if (e.getRentHarborType() == 1) {
            CommonResponse response = this.receiptsApi.delReceipts(e.getId(), RentReceiptsEnum.\u9000\u573a\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636e\u6210\u529f\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)response.getMsg()));
        }
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success();
    }
}

