/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentChangeTotalPlanEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentChangeTotalPlanService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentTotalPlanService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentChangeTotalPlanVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentTotalPlanSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentTotalPlanVO;
import com.ejianc.business.proequipmentcorprent.vo.util.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentChangeTotalPlan"})
public class RentChangeTotalPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRentChangeTotalPlanService service;
    @Autowired
    private IRentTotalPlanService totalPlanService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentChangeTotalPlanVO> saveOrUpdate(@RequestBody RentChangeTotalPlanVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.insertOrUpdate(saveOrUpdateVO, false));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentChangeTotalPlanVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryChangeHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentChangeTotalPlanVO>> queryChangeHistory(@RequestParam Long id) {
        List<RentChangeTotalPlanVO> vo = this.service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentChangeTotalPlanVO> vos) {
        RentChangeTotalPlanVO vo;
        RentChangeTotalPlanEntity totalPlanEntity;
        if (vos.size() == 1 && (totalPlanEntity = (RentChangeTotalPlanEntity)((Object)this.service.selectById((vo = vos.get(0)).getId()))).getChangeStatus().equals(1)) {
            this.service.delete(totalPlanEntity);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentChangeTotalPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentChangeTotalPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RentChangeTotalPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentChangeTotalPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentChangeTotalPlanVO>> refRentChangeTotalPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentChangeTotalPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> queryPlanDetail(Long planId) {
        RentTotalPlanEntity entity = (RentTotalPlanEntity)((Object)this.totalPlanService.selectById(planId));
        RentTotalPlanVO vo = (RentTotalPlanVO)BeanMapper.map((Object)((Object)entity), RentTotalPlanVO.class);
        vo.setPlanMny(entity.getTemporaryAmount());
        vo.setMemo(null);
        vo.setPlanCode(entity.getCode());
        BigDecimal totalAmount = new BigDecimal(0);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())) {
            for (RentTotalPlanSubVO sub : vo.getTotalPlanSubList()) {
                sub.setSubDetailId(sub.getId());
                totalAmount = totalAmount.add(sub.getTemporaryAmount());
                vo.setBaseMny(totalAmount);
            }
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree((List)vo.getTotalPlanSubList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RentChangeTotalPlanVO totalPlanVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(totalPlanVO));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }
}

