/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outStore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.RequireFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.enums.WeighFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetRecordEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.consts.AssetRecordTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.rent.vo.RentAcceptanceSubVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="outStore")
public class OutStoreBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutStoreService service;
    @Autowired
    private IOutRentParameterService outRentParameterService;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IOutRentContractService outRentContractService;
    @Autowired
    private IRentReceiptsApi rentReceiptsApi;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetRecordService assetRecordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outStoreEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity;
        if (state == 0 && (outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId))).getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outStoreEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(billId));
        OutStoreVO outStoreVO = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        OutRentParameterVO pushParamVO = null;
        OutRentContractEntity contract = (OutRentContractEntity)((Object)this.outRentContractService.selectById(entity.getContractId()));
        ArrayList<OutRentParameterVO> saveList = new ArrayList<OutRentParameterVO>();
        ArrayList<RentAcceptanceSubVO> rentAcceptanceSubList = new ArrayList<RentAcceptanceSubVO>();
        RentAcceptanceSubVO tmpRentAcc = null;
        for (OutStoreDetailVO outStoreDetailVO : outStoreVO.getOutStoreDetailList()) {
            try {
                pushParamVO = (OutRentParameterVO)BeanConvertorUtil.convert((Object)outStoreVO, OutRentParameterVO.class);
                this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25, \u51fa\u5e93\u8f6c\u6362\u53f0\u8d26\u5355\u5f02\u5e38: ", (Throwable)e);
                return CommonResponse.error((String)"\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25\uff01");
            }
            pushParamVO.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
            pushParamVO.setBillState(Integer.valueOf(1));
            pushParamVO.setCategoryId(outStoreDetailVO.getMaterialTypeId());
            pushParamVO.setCategoryName(outStoreDetailVO.getMaterialTypeName());
            pushParamVO.setEquipmentId(outStoreDetailVO.getMaterialId());
            pushParamVO.setEquipmentCode(outStoreDetailVO.getMaterialCode());
            pushParamVO.setEquipmentName(outStoreDetailVO.getMaterialName());
            pushParamVO.setUnitId(outStoreDetailVO.getRentUnitId());
            pushParamVO.setUnitName(outStoreDetailVO.getRentUnitName());
            pushParamVO.setSpec(outStoreDetailVO.getSpec());
            pushParamVO.setPropertyRightCompany(outStoreDetailVO.getPropertyRightCompany());
            pushParamVO.setInstallLocation(outStoreDetailVO.getInstallLocation());
            pushParamVO.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
            pushParamVO.setAcceptanceDate(outStoreVO.getOutstoreDate());
            pushParamVO.setStartDate(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? outStoreDetailVO.getRentDetailDate() : null);
            pushParamVO.setMeterRentType(outStoreDetailVO.getRentCalculationType());
            pushParamVO.setEquipmentState(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? OutRentEquipmentStateEnum.\u542f\u7528.getCode() : OutRentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
            pushParamVO.setEquipmentStateName(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? OutRentEquipmentStateEnum.\u542f\u7528.getDescription() : OutRentEquipmentStateEnum.\u5f85\u542f\u7528.getDescription());
            pushParamVO.setUseType(Integer.valueOf(2));
            pushParamVO.setEquipLedgerId(outStoreDetailVO.getStoreEquipId());
            pushParamVO.setEquipLedgerFactoryCode(outStoreDetailVO.getStoreEquipCode());
            pushParamVO.setEquipLedgerEquipName(outStoreDetailVO.getStoreEquipName());
            pushParamVO.setEquipLedgerType(entity.getRentHarborType() == 0 ? "corpEquipPurLedger" : "corpEquipRentLedger");
            pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
            pushParamVO.setUseProjectId(pushParamVO.getProjectId());
            pushParamVO.setUseProjectName(pushParamVO.getProjectName());
            pushParamVO.setUseOrgCode(entity.getOutOrgCode());
            pushParamVO.setUseOrgName(entity.getOutOrgName());
            pushParamVO.setUseOrgId(entity.getOutOrgId());
            pushParamVO.setSupplierId(contract.getSupplierId());
            pushParamVO.setSupplierName(contract.getSupplierName());
            pushParamVO.setSourceId(outStoreVO.getId());
            pushParamVO.setSourceBillType(entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u81ea\u8d2d.getCode() : RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u79df\u8d41.getCode());
            pushParamVO.setMemo(outStoreDetailVO.getMemo());
            pushParamVO.setContractTaxRate(contract.getContractTax());
            pushParamVO.setContractCode(contract.getContractCode());
            OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
            paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            paramDetailVO.setOperationDate(outStoreDetailVO.getRentDetailDate());
            paramDetailVO.setSourceId(outStoreDetailVO.getId());
            paramDetailVO.setSourceType("4");
            ArrayList<OutRentParameterDetailVO> paramSubList = new ArrayList<OutRentParameterDetailVO>();
            paramSubList.add(paramDetailVO);
            pushParamVO.setRentParameterDetailList(paramSubList);
            this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            if (entity.getRentHarborType() == 1) {
                tmpRentAcc = new RentAcceptanceSubVO();
                tmpRentAcc.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
                tmpRentAcc.setEquipmentAppearanceCode(outStoreDetailVO.getEquipLeaveFactoryCode());
                tmpRentAcc.setSpecs(outStoreDetailVO.getSpec());
                tmpRentAcc.setCategoryId(outStoreDetailVO.getMaterialTypeId());
                tmpRentAcc.setCategoryName(outStoreDetailVO.getMaterialName());
                tmpRentAcc.setEquipmentCode(outStoreDetailVO.getMaterialCode());
                tmpRentAcc.setEquipmentId(outStoreDetailVO.getMaterialId());
                tmpRentAcc.setName(outStoreDetailVO.getMaterialName());
                tmpRentAcc.setContractId(entity.getContractId());
                tmpRentAcc.setNum(Integer.valueOf(null != outStoreDetailVO.getRentNum() ? Integer.valueOf(outStoreDetailVO.getRentNum().intValue()) : 0));
                tmpRentAcc.setRentTypeId(Integer.valueOf("day".equals(outStoreDetailVO.getRentCalculationType()) ? 1 : ("month".equals(outStoreDetailVO.getRentCalculationType()) ? 2 : 3)));
                tmpRentAcc.setRentTypeName("day".equals(outStoreDetailVO.getRentCalculationType()) ? "\u65e5\u79df" : ("month".equals(outStoreDetailVO.getRentCalculationType()) ? "\u6708\u79df" : "\u5de5\u7a0b\u91cf"));
                tmpRentAcc.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
                tmpRentAcc.setUnitName(outStoreDetailVO.getRentUnitName());
                tmpRentAcc.setUnitId(outStoreDetailVO.getRentUnitId());
                tmpRentAcc.setQuantitiesNum(null != outStoreDetailVO.getCalculateNum() ? outStoreDetailVO.getCalculateNum() : BigDecimal.ZERO);
                tmpRentAcc.setSourceId(outStoreDetailVO.getId());
                tmpRentAcc.setProductionManufactor(outStoreDetailVO.getProductionManufactor());
                rentAcceptanceSubList.add(tmpRentAcc);
            }
            saveList.add(pushParamVO);
        }
        if (Integer.valueOf("1").equals(entity.getSourceType())) {
            QueryWrapper rentParameterQuery = new QueryWrapper();
            rentParameterQuery.in((Object)"id", (Collection)entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
            List rentParameterList = this.rentParameterService.list((Wrapper)rentParameterQuery);
            if (CollectionUtils.isNotEmpty((Collection)rentParameterList)) {
                for (RentParameterEntity rp : rentParameterList) {
                    rp.setUseType(2);
                    if (null != rp.getUseProjectId()) continue;
                    rp.setUseProjectId(pushParamVO.getUseProjectId());
                    rp.setUseProjectName(pushParamVO.getProjectName());
                    rp.setUseProjectCode(pushParamVO.getProjectCode());
                    rp.setUseOrgId(pushParamVO.getUseOrgId());
                    rp.setUseOrgCode(pushParamVO.getUseOrgCode());
                    rp.setUseOrgName(pushParamVO.getUseOrgName());
                }
                this.rentParameterService.saveOrUpdateBatch(rentParameterList, rentParameterList.size(), false);
            }
        } else {
            QueryWrapper assetQuery = new QueryWrapper();
            assetQuery.in((Object)"id", (Collection)entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
            Map<Long, OutStoreDetailEntity> outStoreDetailMap = entity.getOutStoreDetailList().stream().collect(Collectors.toMap(item -> item.getStoreEquipId(), item -> item));
            List assetEntities = this.assetService.list((Wrapper)assetQuery);
            ArrayList<AssetRecordEntity> newAssetRecordList = new ArrayList<AssetRecordEntity>();
            Object tmpOutStoreDetail = null;
            if (CollectionUtils.isNotEmpty((Collection)assetEntities)) {
                for (AssetEntity asset : assetEntities) {
                    asset.setRentState(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? 1 : 5);
                    asset.setEquipmentStatus(1);
                    if (StringUtils.isBlank((CharSequence)asset.getProjectName())) {
                        asset.setProjectId(pushParamVO.getProjectId());
                        asset.setProjectName(pushParamVO.getProjectName());
                    }
                    newAssetRecordList.add(this.generateAssetRecord(asset, entity));
                }
                this.assetService.saveOrUpdateBatch(assetEntities, assetEntities.size(), false);
                if (CollectionUtils.isNotEmpty(newAssetRecordList)) {
                    this.assetRecordService.saveOrUpdateBatch(newAssetRecordList, newAssetRecordList.size(), false);
                }
            }
        }
        this.outRentParameterService.saveOrUpdateOutRentParams(saveList);
        if (entity.getRentHarborType() == 1) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)BeanMapper.map((Object)((Object)entity), RentAcceptanceVO.class)));
            data.put("orgId", (Object)outStoreVO.getOutOrgId());
            data.put("orgCode", (Object)outStoreVO.getOutOrgCode());
            data.put("orgName", (Object)outStoreVO.getOutOrgName());
            data.put("outOrgId", (Object)outStoreVO.getOrgId());
            data.put("outOrgCode", (Object)outStoreVO.getOrgCode());
            data.put("outOrgName", (Object)outStoreVO.getOrgName());
            data.put("supplierId", (Object)contract.getSupplierId());
            data.put("supplierName", (Object)contract.getSupplierName());
            data.put("acceptanceDate", (Object)entity.getOutstoreDate());
            data.put("acceptanceUserName", (Object)entity.getEmployeeName());
            data.put("acceptanceUserId", (Object)entity.getEmployeeId());
            data.put("rentDate", (Object)entity.getRentDate());
            data.put("acceptanceSource", (Object)("\u51fa\u5e93\u5355[" + entity.getId().toString() + "]"));
            data.put("acceptanceSourceId", (Object)1);
            data.put("sourceType", (Object)0);
            data.put("signStatus", (Object)0);
            data.put("carCode", (Object)entity.getLicensePlate());
            data.put("companyId", (Object)entity.getParentOrgId());
            data.put("companyName", (Object)entity.getParentOrgName());
            data.put("rentType", (Object)1);
            data.put("code", (Object)entity.getBillCode());
            data.put("entranceRentFlag", (Object)entity.getEntranceRentFlag());
            data.put("rentAcceptanceSubList", rentAcceptanceSubList);
            data.put("signStatus", (Object)entity.getSupplierSignStatus());
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u9a8c\u6536\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse response = this.rentReceiptsApi.receiptsSync(data, RentReceiptsEnum.\u9a8c\u6536\u5355.getName());
            if (!response.isSuccess()) {
                this.logger.error("\u5185\u79df\u51fa\u5e93\u5355\u63a8\u9879\u76ee\u9a8c\u6536\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    private AssetRecordEntity generateAssetRecord(AssetEntity asset, OutStoreEntity entity) {
        AssetRecordEntity tmpAssetRecord = new AssetRecordEntity();
        tmpAssetRecord.setAssetId(asset.getId());
        tmpAssetRecord.setAssetName(asset.getEquipmentName());
        tmpAssetRecord.setAssetCode(asset.getBillCode());
        tmpAssetRecord.setProjectId(entity.getProjectId());
        tmpAssetRecord.setProjectCode(entity.getProjectCode());
        tmpAssetRecord.setProjectName(entity.getProjectName());
        tmpAssetRecord.setOrgId(entity.getOutOrgId());
        tmpAssetRecord.setOrgCode(entity.getOutOrgCode());
        tmpAssetRecord.setOrgName(entity.getOutOrgName());
        tmpAssetRecord.setParentOrgCode(entity.getParentOrgCode());
        tmpAssetRecord.setParentOrgId(entity.getParentOrgId());
        tmpAssetRecord.setParentOrgName(entity.getParentOrgName());
        tmpAssetRecord.setEquipmentCode(asset.getEquipmentCode());
        tmpAssetRecord.setEquipmentId(asset.getEquipmentId());
        tmpAssetRecord.setEquipmentName(asset.getEquipmentName());
        tmpAssetRecord.setEquipmentTypeId(asset.getEquipmentTypeId());
        tmpAssetRecord.setEquipmentTypeCode(asset.getEquipmentTypeCode());
        tmpAssetRecord.setEquipmentTypeName(asset.getEquipmentTypeName());
        tmpAssetRecord.setBillDate(new Date());
        tmpAssetRecord.setSourceBillCode(asset.getBillCode());
        tmpAssetRecord.setSourceId(entity.getId());
        tmpAssetRecord.setSourceType(AssetRecordTypeEnum.\u51fa\u5e93.getCode());
        tmpAssetRecord.setSourceTypeName(AssetRecordTypeEnum.\u51fa\u5e93.getName());
        return tmpAssetRecord;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(billId));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)billId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List outRentParameterEntitys = this.outRentParameterService.list((Wrapper)query);
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.in((Object)"parameter_id", (Collection)outRentParameterEntitys.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        detailQuery.ne((Object)"source_type", (Object)"4");
        List list = this.outRentParameterDetailService.list((Wrapper)detailQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u8fdb\u884c\u4e0b\u6e38\u4e1a\u52a1\uff01");
        }
        String result = this.outRentParameterService.removeBySourceId(entity.getId(), entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u81ea\u8d2d.getCode() : RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u79df\u8d41.getCode());
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25\uff0c\u5220\u9664\u79df\u51fa\u53f0\u8d26\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + result));
        }
        if (Integer.valueOf("1").equals(entity.getSourceType())) {
            QueryWrapper rentParameterQuery = new QueryWrapper();
            rentParameterQuery.in((Object)"id", (Collection)entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
            List rentParameterList = this.rentParameterService.list((Wrapper)rentParameterQuery);
            if (CollectionUtils.isNotEmpty((Collection)rentParameterList)) {
                for (RentParameterEntity rp : rentParameterList) {
                    rp.setUseType(1);
                    if (null == rp.getUseProjectId()) continue;
                    rp.setUseProjectId(null);
                    rp.setUseProjectName(null);
                    rp.setUseProjectCode(null);
                    rp.setUseOrgId(null);
                    rp.setUseOrgCode(null);
                    rp.setUseOrgName(null);
                }
                this.rentParameterService.saveOrUpdateBatch(rentParameterList, rentParameterList.size(), false);
            }
        } else {
            QueryWrapper assetQuery = new QueryWrapper();
            assetQuery.in((Object)"id", (Collection)entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
            List assetEntities = this.assetService.list((Wrapper)assetQuery);
            if (CollectionUtils.isNotEmpty((Collection)assetEntities)) {
                for (AssetEntity asset : assetEntities) {
                    asset.setRentState(2);
                    asset.setEquipmentStatus(3);
                    if (!StringUtils.isNotBlank((CharSequence)asset.getProjectName())) continue;
                    asset.setProjectId(null);
                    asset.setProjectName(null);
                }
                this.assetService.saveOrUpdateBatch(assetEntities, assetEntities.size(), false);
                this.assetRecordService.delRecord(entity.getId());
            }
        }
        if (entity.getRentHarborType() == 1 && !(response = this.rentReceiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.\u9a8c\u6536\u5355.getName())).isSuccess()) {
            this.logger.error("\u51fa\u5e93\u5355\u5f03\u5ba1\u5f02\u5e38\uff0c\u5220\u9664\u5185\u79df\u9a8c\u6536\u5355\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

