package com.ejianc.business.proequipmentcorpout.appearance.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 设备出场表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outequipmentcorp_appearance")
public class OutAppearanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_org")
    private String projectOrg; // 所属单位
    @TableField(value="project_org_id")
    private Long projectOrgId; // 所属单位id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="appearance_date")
    private Date appearanceDate; // 出场日期
    @TableField(value="rent_end_date")
    private Date rentEndDate; // 止租日期
    @TableField(value="employee")
    private String employee; // 经办人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="photo_path")
    private String photoPath; // 现场照片路径
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="not_signature")
    private Boolean notSignature;//是否签字

    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部ID
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称

    @TableField(value="project_manger_sign")
    private String projectMangerSign; // 项目经理签字
    @TableField(value="supplier_sign")
    private String supplierSign; // 供应商签字

    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号

    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; //
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; //
    @TableField(value="sup_operator_name")
    private String supOperatorName; //
    @TableField(value="sup_operate_time")
    private Date supOperateTime; //
    @TableField(exist = false)
    private String systemId;
    @TableField(value="org_code")
    private String orgCode; // 项目部编码

    @TableField(value="rent_project_code")
    private String rentProjectCode; // 所属项目编号
    @TableField(value="rent_project_id")
    private Long rentProjectId; // 所属项目id
    @TableField(value="rent_project_name")
    private String rentProjectName; // 所属项目

    @TableField(value="rent_org_code")
    private String rentOrgCode; // 所属组织编号
    @TableField(value="rent_org_id")
    private Long rentOrgId; // 所属组织id
    @TableField(value="rent_org_name")
    private String rentOrgName; // 所属组织
    @TableField(value="rent_project_type")
    private Integer rentProjectType; // 项目类别，0-内部项目,1-外部项目
    @TableField(value="rent_project_addr")
    private String rentProjectAddr; // 所属项目地址

    /**
     * 租出单位主键
     */
    @TableField("out_org_id")
    private Long outOrgId;
    /**
     * 租出单位名称
     */
    @TableField("out_org_name")
    private String outOrgName;
    /**
     * 租出单位编码
     */
    @TableField("out_org_code")
    private String outOrgCode;

    /**
     * 租赁方/合同甲方id
     */
    @TableField("first_party_id")
    private Long firstPartyId;
    /**
     * 租赁方/合同甲方名称
     */
    @TableField("first_party_name")
    private String firstPartyName;

    @TableField("rent_harbor_type")
    private Integer rentHarborType;//租赁方式 0-外租 1-内阻

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="outAppearanceSubService")
    private List<OutAppearanceSubEntity> appearanceSubList = new ArrayList<>(); // 设备出场-设备明细

    public String getRentProjectCode() {
        return rentProjectCode;
    }

    public void setRentProjectCode(String rentProjectCode) {
        this.rentProjectCode = rentProjectCode;
    }

    public Long getRentProjectId() {
        return rentProjectId;
    }

    public void setRentProjectId(Long rentProjectId) {
        this.rentProjectId = rentProjectId;
    }

    public String getRentProjectName() {
        return rentProjectName;
    }

    public void setRentProjectName(String rentProjectName) {
        this.rentProjectName = rentProjectName;
    }

    public String getRentOrgCode() {
        return rentOrgCode;
    }

    public void setRentOrgCode(String rentOrgCode) {
        this.rentOrgCode = rentOrgCode;
    }

    public Long getRentOrgId() {
        return rentOrgId;
    }

    public void setRentOrgId(Long rentOrgId) {
        this.rentOrgId = rentOrgId;
    }

    public String getRentOrgName() {
        return rentOrgName;
    }

    public void setRentOrgName(String rentOrgName) {
        this.rentOrgName = rentOrgName;
    }

    public Integer getRentProjectType() {
        return rentProjectType;
    }

    public void setRentProjectType(Integer rentProjectType) {
        this.rentProjectType = rentProjectType;
    }

    public String getRentProjectAddr() {
        return rentProjectAddr;
    }

    public void setRentProjectAddr(String rentProjectAddr) {
        this.rentProjectAddr = rentProjectAddr;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    public Date getRentEndDate() {
        return rentEndDate;
    }

    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }
    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getPhotoPath() {
        return photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }

    public String getSupplierSign() {
        return supplierSign;
    }

    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }

    public List<OutAppearanceSubEntity> getAppearanceSubList() {
        return appearanceSubList;
    }

    public void setAppearanceSubList(List<OutAppearanceSubEntity> appearanceSubList) {
        this.appearanceSubList = appearanceSubList;
    }
}
