package com.ejianc.business.proequipmentcorpout.outLedger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.constants.MeterRentTypeEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.EntranceRentFlagEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/10/27 14:29
 */
@RestController
@RequestMapping(value = "/outRentParameter/")
public class OutRentParameterController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRentParameterService service;

    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentParameterVO> queryDetail(Long id) {
        OutRentParameterEntity entity = service.selectById(id);
        OutRentParameterVO vo = BeanMapper.map(entity, OutRentParameterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentParameterVO> vos) {
        service.removeByIds(vos.stream().map(OutRentParameterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<OutRentParameterEntity> page = service.queryPage(param,false);
        IPage<OutRentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentParameterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OutRentParameterEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<OutRentParameterVO> vos = BeanMapper.mapList(list, OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty(vos)) {
            vos.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setMeterRentTypeName(null != MeterRentTypeEnum.getEnumByCode(vo.getMeterRentType()) ? MeterRentTypeEnum.getEnumByCode(vo.getMeterRentType()).getName() : null);
                vo.setSourceTypeName(Integer.valueOf(1).equals(vo.getSourceType()) ? "租赁" : "自购");
            });
        }

        beans.put("records", vos);
        ExcelExport.getInstance().export("EquipRentOutLedger-export.xlsx", beans, response);
    }

    /**
     * @Description 参照（进场-启用设备）
     * @Return void
     */
    @RequestMapping(value = "/refRentParameterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refRentParameterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能必须传！");
        }

        param.getParams().put("equipmentState", new Parameter(QueryParam.IN, Arrays.asList(OutRentEquipmentStateEnum.启用.getCode(),
                OutRentEquipmentStateEnum.停用.getCode(), OutRentEquipmentStateEnum.待启用.getCode(), OutRentEquipmentStateEnum.停租.getCode())));//启用,和进场设备

        IPage<OutRentParameterEntity> page = service.queryPage(param, false);
        IPage<OutRentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<OutRentParameterVO> outRentParameterVOList = BeanMapper.mapList(page.getRecords(), OutRentParameterVO.class);

        if (CollectionUtils.isNotEmpty(outRentParameterVOList)){
            for (OutRentParameterVO outRentParameterVO : outRentParameterVOList) {
                //计租方式 day--日租，month--月租,engineering--工程量,other--其它费用
                switch (outRentParameterVO.getMeterRentType()) {
                    case "day":
                        outRentParameterVO.setMeterRentTypeName("日租");
                        break;
                    case "month":
                        outRentParameterVO.setMeterRentTypeName("月租");
                        break;
                    case "engineering":
                        outRentParameterVO.setMeterRentTypeName("工程量");
                        break;
                    default:
                        outRentParameterVO.setMeterRentTypeName("其它费用");
                        break;
                }
            }
        }
        pageData.setRecords(outRentParameterVOList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照（租出线-设备启用参照）
     * 数据展示范围：合同 在租出台账下租出状态为 停用 的设备，按照设备进场时间倒序排列
     * @Return void 用于设备停用
     */
    @RequestMapping(value = "/refOutRentEquipmentStart", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refOutRentEquipmentStart(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        /** 租户隔离 */
        Long contractId = null;
        Integer entranceRentFlag = null;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
            entranceRentFlag = _con.getInteger("entranceRentFlag");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能为空！");
        }
        if (entranceRentFlag != null) {
            if (EntranceRentFlagEnum.是.getCode().equals(entranceRentFlag)){
                //进场启用的条件只查待启用的数据
                param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, OutRentEquipmentStateEnum.待启用.getCode()));//待启用
            }else {
                //不是进场启用的逻辑不变
                param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, OutRentEquipmentStateEnum.停用.getCode()));//停用
            }
        } else {
            throw new BusinessException("是否为进场启用不能为空！");
        }
        logger.info("参照查询参数：{}", JSONObject.toJSONString(param.getParams()));
        IPage<OutRentParameterEntity> page = service.queryPage(param, false);
        IPage<OutRentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentParameterVO> outRentParameterVOList = BeanMapper.mapList(page.getRecords(), OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty(outRentParameterVOList)){
            for (OutRentParameterVO outRentParameterVO : outRentParameterVOList) {
                //计租方式 day--日租，month--月租,engineering--工程量,other--其它费用
                switch (outRentParameterVO.getMeterRentType()) {
                    case "day":
                        outRentParameterVO.setMeterRentTypeName("日租");
                        break;
                    case "month":
                        outRentParameterVO.setMeterRentTypeName("月租");
                        break;
                    case "engineering":
                        outRentParameterVO.setMeterRentTypeName("工程量");
                        break;
                    default:
                        outRentParameterVO.setMeterRentTypeName("其它费用");
                        break;
                }
            }
        }
        pageData.setRecords(outRentParameterVOList);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }



    /**
     * @Description 参照（租出线-设备停用参照）
     * @Return void 用于设备启用
     */
    @RequestMapping(value = "/refOutRentEquipmentStop", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refOutRentEquipmentStop(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("name");
        Long contractId = null;
        Integer entranceRentFlag = null;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
            entranceRentFlag = _con.getInteger("entranceRentFlag");
        }
        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能为空！");
        }
        if (entranceRentFlag != null) {
            if (EntranceRentFlagEnum.是.getCode().equals(entranceRentFlag)){
                //退场停用的条件查启用、停用的设备
                param.getParams().put("equipmentState", new Parameter(QueryParam.IN, Arrays.asList(OutRentEquipmentStateEnum.启用.getCode(), OutRentEquipmentStateEnum.停用.getCode())));//待启用
            }else {
                //是进场计租的合同逻辑不变
                param.getParams().put("equipmentState", new Parameter(QueryParam.EQ, OutRentEquipmentStateEnum.启用.getCode()));//启用
            }
        } else {
            throw new BusinessException("是否为退场停用不能为空！");
        }

        IPage<OutRentParameterEntity> page = service.queryPage(param, false);
        IPage<OutRentParameterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentParameterVO> outRentParameterVOList = BeanMapper.mapList(page.getRecords(), OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty(outRentParameterVOList)){
            for (OutRentParameterVO outRentParameterVO : outRentParameterVOList) {
                //计租方式 day--日租，month--月租,engineering--工程量,other--其它费用
                switch (outRentParameterVO.getMeterRentType()) {
                    case "day":
                        outRentParameterVO.setMeterRentTypeName("日租");
                        break;
                    case "month":
                        outRentParameterVO.setMeterRentTypeName("月租");
                        break;
                    case "engineering":
                        outRentParameterVO.setMeterRentTypeName("工程量");
                        break;
                    default:
                        outRentParameterVO.setMeterRentTypeName("其它费用");
                        break;
                }
            }
        }
        pageData.setRecords(outRentParameterVOList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
