package com.ejianc.business.proequipmentcorpout.outrent.service;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentSettlementEntity;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentConSettleReportVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettleRecordVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettlementVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 设备租赁结算主表
 * 
 * @author generator
 * 
 */
public interface IOutRentSettlementService extends IBaseService<OutRentSettlementEntity> {
    OutRentSettlementVO saveOrUpdate(OutRentSettlementVO saveOrUpdateVO);
    boolean queryExist(Long contractId,Long id);
    CommonResponse<Map> getDateMny(Long contractId);
    boolean pushBillToSupCenter(OutRentSettlementEntity entity);
    CommonResponse<String> updatePushBill(OutRentSettlementEntity entity);
    String updateBillSupSignSyncInfo(HttpServletRequest request);
    boolean pushSettleToPool(OutRentSettlementVO vo);
    boolean delSettleFromPool(Long id);
    ExecutionVO targetCost(OutRentSettlementEntity entity);
    CommonResponse<OutRentSettlementVO> pushCost(OutRentSettlementVO rentSettlementVO);
    void costPush(OutRentSettlementEntity rentSettlementEntity);
    List<RentRentalEntity> queryRental(Long contractId,String settleDate);
    /*
     * 参数控制集成方法
     * */
    ParamsCheckVO checkParams(OutRentSettlementVO vo);
    /*
     * 合同金额控结算金额
     * */
    List<ParamsCheckVO> checkParamsMnyList(OutRentContractEntity rentContractEntity, OutRentSettlementVO vo);
    CommonResponse<String> pushTargetCost(Long id);

    OutRentSettleRecordVO queryDetailRecord(Long contractId);
    void updateContractPoolSettle(OutRentSettlementVO vo, Boolean type);
    void delete( List<Long> settleIds);

    String updateBillSupSignSync(Map<String, String> map);

    Map<String, Object> count(Map<String, Object> paramMap);

    List<OutRentConSettleReportVO> pageList(Map<String, Object> paramMap);
}
