package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentSettlementEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStartSubVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStartVO;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("outRentEquipmentStart")
public class OutRentEquipmentStartBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOutRentEquipmentStartService outRentEquipmentStartService;
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IRentReceiptsApi receiptsApi;
	@Autowired
    private IAssetService assetService;
	@Autowired
    private IOutRentContractService contractService;
    @Autowired
    private IOutRentSettlementService outRentSettlementService;


	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_TYPE = "BT220221000000003";//已调整
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";

	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
	private final String OPERATE = "RENT-PROEQUIPMENT-START";

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStartEntity entity = outRentEquipmentStartService.selectById(billId);
		Boolean entranceRentFlag = false;
		if (EntranceRentFlagEnum.是.getCode().equals(entity.getEntranceRentFlag())){
			entranceRentFlag = true;
		}
		List<OutRentParameterEntity> parameterList = new ArrayList<>();
		List<OutRentEquipmentStartSubEntity> startSubEntityList = entity.getOutRentEquipmentStartSubList();
		for (OutRentEquipmentStartSubEntity subEntity : startSubEntityList) {
			// 主表赋值
			OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setStartDate(subEntity.getTypeDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());//启动状态
			parameterEntity.setEquipmentStateName(OutRentEquipmentStateEnum.启用.getDescription());//启动状态
			if (!entranceRentFlag){
				// 处理子表
				List<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<>();
				OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.启用单.getCode());
				detailEntity.setSourceId(entity.getId());
				detailEntity.setOperationDate(subEntity.getTypeDate());
				detailEntity.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
				detailEntity.setParameterId(subEntity.getSourceId());
				parameterDetailList.add(detailEntity);

				parameterEntity.setRentParameterDetailList(parameterDetailList);
			}else {
				//初次进场启用   需要把计租日期赋值
				parameterEntity.setMeterRentDate(subEntity.getTypeDate());
			}
			parameterList.add(parameterEntity);
		}
		if (entranceRentFlag){
			//是否为进场启用：
			//是：选择待启用的设备，提交时更新台账第一条数据的操作日期
			//更新租出台账子表操作时间
			List<Long> parameterIdList = startSubEntityList.stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
			Map<Long, Date> startSubDateMap = startSubEntityList.stream().collect(Collectors.toMap(OutRentEquipmentStartSubEntity::getSourceId, OutRentEquipmentStartSubEntity::getTypeDate, (key1, key2) -> key2));
			logger.info("获取设备子表集合：{}", JSONObject.toJSONString(startSubDateMap));
			logger.info("获取台账设备id集合：{}", JSONObject.toJSONString(parameterIdList));
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
			List<OutRentParameterDetailEntity> detailEntityList = outRentParameterDetailService.queryList(queryParam);
			logger.info("获取台账设备子表集合：{}", JSONObject.toJSONString(detailEntityList));
			if (CollectionUtils.isNotEmpty(detailEntityList)){
				for (OutRentParameterDetailEntity detailEntity : detailEntityList) {
					if (startSubDateMap.containsKey(detailEntity.getParameterId())){
						detailEntity.setOperationDate(startSubDateMap.get(detailEntity.getParameterId()));
					}
				}
			}
			outRentParameterDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
		}

		logger.info("推送台账数据parameterList：{}", JSONObject.toJSONString(parameterList));
		outRentParameterService.changeParameter(parameterList, RentParameterTypeEnum.启用单.getCode());

		//自有设备台账已删除租出状态，所以取消该代码
		//判断是否自购设备，是：修改自有设备台账设备 停启用状态
//        List<Long> outRentParameterIds = startSubEntityList.stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
//        List<OutRentParameterEntity> outRentParameterEntityList = (List<OutRentParameterEntity>) outRentParameterService.listByIds(outRentParameterIds);
//        if (CollectionUtils.isNotEmpty(outRentParameterEntityList)){
//            logger.info("通过启用子表：{}，取到租出设备台账数据：{}", JSONObject.toJSONString(startSubEntityList), JSONObject.toJSONString(outRentParameterEntityList));
//            List<Long> equipLedgerIds = outRentParameterEntityList.stream().filter(item -> item.getSourceType() == 0).map(OutRentParameterEntity::getEquipLedgerId).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(equipLedgerIds)){
//                logger.info("获取到租出设备台账的自有设备来源数据id集合：{}", JSONObject.toJSONString(equipLedgerIds));
//                List<AssetEntity> assetEntityList = (List<AssetEntity>) assetService.listByIds(equipLedgerIds);
//                if (CollectionUtils.isNotEmpty(assetEntityList)){
//                    logger.info("获取到租出设备台账的自有设备来源数据：{}", JSONObject.toJSONString(assetEntityList));
//                    for (AssetEntity assetEntity : assetEntityList) {
//                        assetEntity.setRentState(1);//租出状态 启用 1 停用 2
//                    }
//                    assetService.saveOrUpdateBatch(assetEntityList, assetEntityList.size(), false);
//                }
//            }else {
//                logger.info("未获取到自购设备来源的设备");
//            }
//        }

		logger.info("推送项目方数据entity：{}", JSONObject.toJSONString(entity));

		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			OutRentEquipmentStartVO startVO = BeanMapper.map(entity, OutRentEquipmentStartVO.class);

			//设置项目方需要字段
			//将租出单位信息赋值给组织
			startVO.setOrgId(entity.getOutOrgId());
			startVO.setOrgName(entity.getOutOrgName());
			startVO.setOrgCode(entity.getOutOrgCode());

			//设置项目方所属单位
			startVO.setCompanyId(entity.getParentOrgId());
			startVO.setCompanyName(entity.getParentOrgName());
			startVO.setOrganizationDate(entity.getCreateTime());

			logger.info("startVO：{}", JSONObject.toJSONString(startVO));
			startVO.setRentEquipmentStartSubList(BeanMapper.mapList(entity.getOutRentEquipmentStartSubList(), OutRentEquipmentStartSubVO.class));
			for (OutRentEquipmentStartSubVO startSubVO : startVO.getRentEquipmentStartSubList()) {
				startSubVO.setCategoryName(startSubVO.getEquipmentType());
				startSubVO.setName(startSubVO.getEquipmentName());
			}

			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(startVO), RentReceiptsEnum.启用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}

		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStartEntity entity = outRentEquipmentStartService.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}

		OutRentContractEntity contractEntity = contractService.selectById(entity.getContractId());
		if(contractEntity !=null && PerformanceStatusEnum.已终止.getCode().equals(contractEntity.getContractPerformanceState())){
			return CommonResponse.error("合同已终止，该单据不能撤回！");
		}

        QueryParam settlementQueryParam = new QueryParam();
        settlementQueryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<OutRentSettlementEntity> outRentSettlementEntityList = outRentSettlementService.queryList(settlementQueryParam);
        if (CollectionUtils.isNotEmpty(outRentSettlementEntityList)){
            return CommonResponse.error("当前单据的设备，已被下游结算单引用，不能撤回！");
        }

		//撤回台账数据
		List<OutRentEquipmentStartSubEntity> outRentEquipmentStartSubEntityList = entity.getOutRentEquipmentStartSubList();
		List<Long> outRentParameterIds = outRentEquipmentStartSubEntityList.stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
		logger.info("推送台账数据parameterIdList：{}", JSONObject.toJSONString(outRentParameterIds));

        for(OutRentEquipmentStartSubEntity subEntity:outRentEquipmentStartSubEntityList) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter(QueryParam.EQ, subEntity.getSourceId()));
            queryParam.getOrderMap().put("createTime", QueryParam.DESC);
            List<OutRentParameterDetailEntity> detailEntityList = outRentParameterDetailService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                OutRentParameterDetailEntity detailEntity = detailEntityList.get(0);
                if(detailEntityList.size()>1&&!billId.equals(detailEntity.getSourceId())){
                    return CommonResponse.error("弃审失败:该单据已存在下游单据或已做租金计算，请检查");
                }
            }
        }

		if (EntranceRentFlagEnum.是.getCode().equals(entity.getEntranceRentFlag())){
			//初次进场启用   1，更新主表状态为待启用，计租日期为空，操作时间为最新
			UpdateWrapper<OutRentParameterEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.in("id", outRentParameterIds);
			updateWrapper.set("meter_rent_date", null);
			updateWrapper.set("start_date", null);
			updateWrapper.set("operation_date", new Date());
			updateWrapper.set("equipment_state", OutRentEquipmentStateEnum.待启用.getCode());
			updateWrapper.set("equipment_state_name", OutRentEquipmentStateEnum.待启用.getDescription());
			outRentParameterService.update(updateWrapper);

			//更新子表操作时间为null
			UpdateWrapper<OutRentParameterDetailEntity> detailUpdateWrapper = new UpdateWrapper<>();
			detailUpdateWrapper.in("parameter_id", outRentParameterIds);
			detailUpdateWrapper.set("operation_date", null);
			outRentParameterDetailService.update(detailUpdateWrapper);

			QueryParam updateParam = new QueryParam();
			updateParam.getParams().put("id", new Parameter(QueryParam.IN, outRentParameterIds));
			List<OutRentParameterEntity> updateList = outRentParameterService.queryList(updateParam, false);
			//推送项目方修改设备状态
			JSONArray jsonArray = JSONArray.parseArray(JSONObject.toJSONString(updateList));
			receiptsApi.updateEquipmentState(jsonArray, true);

		}else{
			//进场启用为否  保持原有逻辑
			outRentParameterService.cancelParameter(outRentParameterIds, RentParameterTypeEnum.启用单.getCode(), entity.getId());
		}


		//自有设备台账已删除租出状态，所以取消该代码
		//判断是否自购设备，是：修改自有设备台账设备 停启用状态
//		List<OutRentParameterEntity> outRentParameterEntityList = (List<OutRentParameterEntity>) outRentParameterService.listByIds(outRentParameterIds);
//		if (CollectionUtils.isNotEmpty(outRentParameterEntityList)){
//			logger.info("通过启用子表：{}，取到租出设备台账数据：{}", JSONObject.toJSONString(outRentEquipmentStartSubEntityList), JSONObject.toJSONString(outRentParameterEntityList));
//			List<Long> equipLedgerIds = outRentParameterEntityList.stream().filter(item -> item.getSourceType() == 0).map(OutRentParameterEntity::getEquipLedgerId).collect(Collectors.toList());
//			if (CollectionUtils.isNotEmpty(equipLedgerIds)){
//				logger.info("获取到租出设备台账的自有设备来源数据id集合：{}", JSONObject.toJSONString(equipLedgerIds));
//				List<AssetEntity> assetEntityList = (List<AssetEntity>) assetService.listByIds(equipLedgerIds);
//				if (CollectionUtils.isNotEmpty(assetEntityList)){
//					logger.info("获取到租出设备台账的自有设备来源数据：{}", JSONObject.toJSONString(assetEntityList));
//					for (AssetEntity assetEntity : assetEntityList) {
//						assetEntity.setRentState(2);//租出状态 启用 1 停用 2
//					}
//					assetService.saveOrUpdateBatch(assetEntityList, assetEntityList.size(), false);
//				}
//			}else {
//				logger.info("未获取到自购设备来源的设备");
//			}
//		}


		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.启用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}

		return CommonResponse.success("审批回调成功！");
	}

}
