package com.ejianc.business.proequipmentcorppur.asset.service;

import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAmortizeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAmortizeEntity;

import java.util.Date;
import java.util.List;

/**
 * 固定资产摊销
 * 
 * @author generator
 * 
 */
public interface IAssetAmortizeService extends IBaseService<AssetAmortizeEntity> {

    /**
     * @description: 获取摊销设置
     * @return: void
     * @author songlx
     * @date: 2022/7/19
     */
    void getAmortizeSet(List<AssetAmortizeDetailVO> detailList, Long orgId);

    /**
     * @param detailList
     * @param amortizeDate
     * @description: 计算本次摊销金额
     * @return: void
     * @author songlx
     * @date: 2022/7/19
     */
    void caclAmortizeMny(List<AssetAmortizeDetailVO> detailList, Date amortizeDate);

    void costPush(AssetAmortizeEntity assetAmortizeEntity1);

    CommonResponse<AssetAmortizeVO> pushCost(AssetAmortizeVO assetAmortizeVO);

    /**
     * 判断选择的设备是否正在进行设备调出
     * @param leaveFactoryCodeList
     * @return
     */
    CommonResponse<String> getEquipmentAllocationOut(List<String> leaveFactoryCodeList);
}
