package com.ejianc.business.proequipmentcorppur.purchase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorppur.purchase.bean.RecordPurchaseContractDetailEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.RecordPurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.RecordPurchaseContractOtherDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchase.mapper.RecordPurchaseContractMapper;
import com.ejianc.business.proequipmentcorppur.purchase.service.IRecordPurchaseContractDetailService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IRecordPurchaseContractOtherDetailedService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IRecordPurchaseContractService;
import com.ejianc.business.proequipmentcorppur.purchase.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 设备采购合同-记录表
 *
 * @author generator
 */
@Service("recordPurchaseContractService")
public class RecordPurchaseContractServiceImpl extends BaseServiceImpl<RecordPurchaseContractMapper, RecordPurchaseContractEntity> implements IRecordPurchaseContractService {

    @Autowired
    private IRecordPurchaseContractDetailService recordDetailService;

    @Autowired
    private IRecordPurchaseContractOtherDetailedService recordOtherCostService;

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        LambdaQueryWrapper<RecordPurchaseContractEntity> lambda = Wrappers.<RecordPurchaseContractEntity>lambdaQuery();
        lambda.eq(RecordPurchaseContractEntity::getChangeId, id);

        RecordPurchaseContractEntity recordEntity = super.getOne(lambda);

        PurchaseContractVO contractVO = BeanMapper.map(recordEntity, PurchaseContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, recordEntity.getId()));
        List<RecordPurchaseContractDetailEntity> detailEntityListDb = recordDetailService.queryList(queryParam, false);
        List<RecordPurchaseContractDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (RecordPurchaseContractDetailEntity cdEntity : detailEntityList) {
//                cdEntity.setTid(cdEntity.getSrcTableId().toString());
//                cdEntity.setId(cdEntity.getSrcTableId());
//                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<PurchaseContractDetailedVO> resultMapList = BeanMapper.mapList(detailEntityList, PurchaseContractDetailedVO.class);
            contractVO.setDetailList(resultMapList);
        }


        //设置其他花费内容
        List<RecordPurchaseContractOtherDetailedEntity> otherCostEntityListDb = recordOtherCostService.queryList(queryParam, false);
        List<RecordPurchaseContractOtherDetailedEntity> otherCostEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)) {
            otherCostEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType()) {
                    otherCostEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherCostEntityList)) {
            for (RecordPurchaseContractOtherDetailedEntity ocEntity : otherCostEntityList) {
                ocEntity.setRowState("edit");
            }
            List<PurchaseContractOtherDetailedVO> resultMapList = BeanMapper.mapList(otherCostEntityList, PurchaseContractOtherDetailedVO.class);
            contractVO.setOtherCostList(resultMapList);
        }

        return contractVO;
    }
}
