package com.ejianc.business.proequipmentcorprent.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceEntity;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.proequipmentcorprent.appearance.service.IAppearanceService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.impl.UseRecordServiceImpl;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("appearance") 
public class AppearanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IAppearanceService service;
	@Autowired
	private IRentParameterService rentParameterService;
	@Autowired
	private IRentParameterDetailService rentParameterDetailService;
	@Autowired
	private IRentContractService contractService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		AppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e,false);

		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AppearanceEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
				|| BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(userContext.getUserCode());
			e.setCommitUserName(userContext.getUserName());
		}


		List<RentParameterEntity> parameterList = new ArrayList<>();
		List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		for (AppearanceSubEntity subEntity : appearanceSubList) {
//			// 主表赋值
			RentParameterEntity parameterEntity = new RentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			if(6!=subEntity.getState()){
				parameterEntity.setRentEndDate(e.getAppearanceDate());
			}
			parameterEntity.setOutDate(e.getAppearanceDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());//启动状态
			parameterEntity.setUseType(2);//使用
			// 处理子表
			if(6!=subEntity.getState()){
              //退场时，  如果选择设备是停租状态的话，不再插入子表数据   否则 和原逻辑不变
				List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
				RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.退场单.getCode());
				detailEntity.setSourceId(e.getId());
				detailEntity.setOperationDate(subEntity.getRentEndDate());
				detailEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());
				detailEntity.setParameterId(subEntity.getSourceId());
				parameterDetailList.add(detailEntity);

				parameterEntity.setRentParameterDetailList(parameterDetailList);
			}
			parameterList.add(parameterEntity);
		}
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.退场单.getCode());

		//TODO 推送供方暂时注释掉
		boolean pushFlag = false;
//推送供方
//		boolean pushFlag = service.pushBillToSupCenter(e,billTypeCode);
//		logger.info("获取推送供方结果--"+pushFlag);
		if(!pushFlag){
			e.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}else{
			e.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}
		service.saveOrUpdate(e, false);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AppearanceEntity entity = service.selectById(billId);
		if(entity.getNotSignature()){
			throw new BusinessException("已签字不能撤回！");
		}
		RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
		if(contractEntity !=null && PerformanceStatusEnum.已终止.getCode().equals(contractEntity.getContractPerformanceState())){
			return CommonResponse.error("合同已终止，该单据不能撤回！");
		}

		//合同id + 设备出厂编码来判断该设备是否唯一，如果另一个出厂编码在台账的数据时间大于该单据，则不能撤回
		List<AppearanceSubEntity> appearanceSubList = entity.getAppearanceSubList();
		if (CollectionUtils.isNotEmpty(appearanceSubList)){
			for (AppearanceSubEntity appearanceSubEntity : appearanceSubList) {
				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("equipment_exit_code", new Parameter(QueryParam.EQ, appearanceSubEntity.getEquipmentExitCode()));
				queryParam.getParams().put("contract_id",new Parameter(QueryParam.NE, entity.getContractId()));
				queryParam.getOrderMap().put("create_time", QueryParam.DESC);
				List<RentParameterEntity> list = rentParameterService.queryList(queryParam);
				logger.info("查出相同出厂编码，不同合同的设备台账数据：{}", JSONObject.toJSONString(list));
				if (CollectionUtils.isNotEmpty(list) ){
					RentParameterEntity outRentParameterEntity = list.get(0);
					if (!appearanceSubEntity.getId().equals(outRentParameterEntity.getSourceId())){
						return CommonResponse.error("台账已有新的设备，不支持撤回！");
					}
				}

				QueryParam parameterDetailQuery = new QueryParam();
				parameterDetailQuery.getParams().put("parameterId", new Parameter(QueryParam.EQ, appearanceSubEntity.getSourceId()));
				parameterDetailQuery.getOrderMap().put("createTime", QueryParam.DESC);
				List<RentParameterDetailEntity> detailEntityList = rentParameterDetailService.queryList(queryParam, false);
				if (CollectionUtils.isNotEmpty(detailEntityList)) {
					RentParameterDetailEntity detailEntity = detailEntityList.get(0);
					if(6!=appearanceSubEntity.getState()&&!billId.equals(detailEntity.getSourceId())){
						return CommonResponse.error("弃审失败:该单据已存在下游单据或已做租金计算，请检查");
					}
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AppearanceEntity e = service.selectById(billId);
		List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
		List<Long> parameterIdList = appearanceSubList.stream().filter(item -> 6 != item.getState()).map(AppearanceSubEntity::getSourceId).collect(Collectors.toList());//过滤停租
		List<Long> parameterIdListTz = appearanceSubList.stream().filter(item -> 6 == item.getState()).map(AppearanceSubEntity::getSourceId).collect(Collectors.toList());//停租
		if(CollectionUtils.isNotEmpty(parameterIdList)){
			rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.退场单.getCode(), e.getId());
		}
		if(CollectionUtils.isNotEmpty(parameterIdListTz)){
			//停租的设备  只需要改台账主表的状态，不再撤回子表明细
			QueryParam saveParam = new QueryParam();
			saveParam.getParams().put("id", new Parameter(QueryParam.IN, parameterIdList));
			List<RentParameterEntity> saveList = rentParameterService.queryList(saveParam, false);
			for (RentParameterEntity saveEntity : saveList) {
				saveEntity.setOutDate(null);
				saveEntity.setOperationDate(new Date());
				saveEntity.setEquipmentState(RentEquipmentStateEnum.停租.getCode());
			}

		}
		//推送供方
		if(BillPushStatusEnum.推送成功.getStatus().equals(e.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(e,billTypeCode);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				throw new BusinessException(commonResponse.getMsg());
			}
		}
		e.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		service.saveOrUpdate(e,false);
		return CommonResponse.success();
	}

}
