package com.ejianc.business.proequipmentcorprent.rent.controller;

import java.io.Serializable;

import com.ejianc.business.proequipmentcorprent.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettlementVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentalSumVo;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentRentalVO;

/**
 * 租金计算主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentRental")
@Api(value = "租金计算主表", tags = {"租金计算主表"})
public class RentRentalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi iOrgApi;



    @Autowired
    private IRentRentalService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentRentalVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentRentalVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveRental(saveOrUpdateVO));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentRentalVO> queryDetail(@RequestParam Long id) {
    	RentRentalEntity entity = service.selectById(id);
    	RentRentalVO vo = BeanMapper.map(entity, RentRentalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentRentalVO> pushCost(@RequestBody RentRentalVO vo) {
//        return service.pushCost(vo);
        return CommonResponse.success("没有实际成本推送！", vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentRentalVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (RentRentalVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
//        service.removeByIds(vos.stream().map(RentRentalVO::getId).collect(Collectors.toList()),true);
        service.delRental(vos);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentRentalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }
            else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                }
                else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<RentRentalEntity> page = service.queryPage(param,false);
        IPage<RentRentalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentRentalVO.class));
        setDefaultName(pageData.getRecords());
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 默认赋值名称
     *
     * @param list 需要赋值的列表
     */
    private void setDefaultName(List<RentRentalVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (RentRentalVO vo : list) {
                vo.setSettlementStateName(RentalSettlementStateEnum.getEnumByCode(vo.getSettlementState())
                        .getDescription());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("审核中");
                }
                if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("审核中");
                }
            }
        }
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<RentRentalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<RentRentalVO> voList = BeanMapper.mapList(list, RentRentalVO.class);
        setDefaultName(voList);
        beans.put("records", voList);
        ExcelExport.getInstance().export("RentRental-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refRentRentalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentRentalVO>> refRentRentalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("meterRentTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("settlementState", new Parameter(QueryParam.EQ, RentalSettlementStateEnum.未结算.getCode()));
//        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(),
                        BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            else {
                throw new BusinessException("合同信息不能为空！");
            }
        }
        else {
            throw new BusinessException("合同信息不能为空！");
        }

        IPage<RentRentalEntity> page = service.queryPage(param, false);
        IPage<RentRentalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentRentalVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 租金自动计算
     *
     * @param vo 参数
     * @return 计算结果
     */
    @RequestMapping(value = "/automaticRental", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentRentalVO> automaticRental(@RequestBody RentRentalVO vo) {
        RentRentalVO rentRentalVO = service.automaticRental(vo);
        return CommonResponse.success("租金自动计算成功！", rentRentalVO);
    }
}
