package com.ejianc.business.proequipmentcorprent.temporary.contract.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryEquipmentDetailedEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryPaymentClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryOtherEntity;

/**
 * 临时设备租赁合同
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_temporary_contract")
public class TemporaryContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 合同名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="rent_type")
    private Integer rentType; // 租赁方式
    @TableField(value="rent_type_name")
    private String rentTypeName; // 租赁方式名称
    @TableField(value="calibration_result_id")
    private Long calibrationResultId; // 定标结果id
    @TableField(value="calibration_result_name")
    private String calibrationResultName; // 定标结果名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="company_id")
    private Long companyId; // 所属单位
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称
    @TableField(value="contract_type")
    private Long contractType; // 合同类别
    @TableField(value="contract_type_name")
    private String contractTypeName; // 合同类别名称
    @TableField(value="party_id")
    private Long partyId; // 甲方
    @TableField(value="party_name")
    private String partyName; // 甲方名称
    @TableField(value="party_user")
    private Long partyUser; // 甲方负责人
    @TableField(value="party_user_name")
    private String partyUserName; // 甲方负责人名称
    @TableField(value="party_handle_user")
    private Long partyHandleUser; // 甲方经办人
    @TableField(value="party_handle_user_name")
    private String partyHandleUserName; // 甲方经办人名称
    @TableField(value="party_phone")
    private Long partyPhone; // 甲方电话
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="supplier_handle_user")
    private Long supplierHandleUser; // 乙方经办人id
    @TableField(value="supplier_handle_user_name")
    private String supplierHandleUserName; // 乙方经办人名称
    @TableField(value="supplier_phone")
    private Long supplierPhone; // 乙方电话
    @TableField(value="supplier_address")
    private String supplierAddress; // 乙方地址
    @TableField(value="signed_date")
    private Date signedDate; // 签订日期
    @TableField(value="supply_place")
    private String supplyPlace; // 供货地点
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税率
    @TableField(value="contract_performance_state")
    private String contractPerformanceState; // 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；   默认为未签定
    @TableField(value="contract_performance_name")
    private String contractPerformanceName; // 合同履约状态名称
    @TableField(value="draft_type")
    private String draftType; // 起草方式:1--线上起草,2-----合同上传，3---线下
    @TableField(value="draft_type_name")
    private String draftTypeName; // 起草方式名称
    @TableField(value="contract_file")
    private String contractFile; // 合同附件
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_amount_tax")
    private BigDecimal contractAmountTax; // 合同税额
    @TableField(value="contract_state")
    private Integer contractState; // 合同状态:1--未签订,2--履约中,3-已终止,4-已作废,5-已冻结,6-已结束,
    @TableField(value="signature_state")
    private String signatureState; // 1---未签章,2---待乙方签章,3-待甲方签章,4-已签章
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="after_change_mny")
    private BigDecimal afterChangeMny; // 变更后金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额(含税)
    @TableField(value="changing_item")
    private String changingItem; // 变更项
    @TableField(value="changing_ratio")
    private BigDecimal changingRatio; // 变更比例
    @TableField(value="changing_tax")
    private BigDecimal changingTax; // 本次变更税额
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_file")
    private String changeFile; // 变更附件
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_draft_type")
    private String changeDraftType; // 变更起草类型
    @TableField(value="add_type")
    private Integer addType; // 1----直接添加----2---定标结果
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="supplement_describe")
    private String supplementDescribe; // 补充协议补充项描述
    @TableField(value="supplement_code")
    private String supplementCode; // 补充协议编号
    @TableField(value="supplement_name")
    private String supplementName; // 补充协议名称
    @TableField(value="supplement_state")
    private Integer supplementState; // 补充协议状态:1-未签订,2-履约中,3-已终止,4-已作废
    @TableField(value="supplement_file")
    private String supplementFile; // 协议附件
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效时间
    @TableField(value="change_contract_signature_status")
    private Integer changeContractSignatureStatus; // 变更是否签章
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="main_contract_create_date")
    private Date mainContractCreateDate; // 主合同创建日期
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始版本金额
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    @TableField(value="supplement_handle_user")
    private Long supplementHandleUser; // 补充协议经办人ID
    @TableField(value="supplement_handle_user_name")
    private String supplementHandleUserName; // 补充协议经办人名称

    @TableField(value="equipment_tax_mny")
    private BigDecimal equipmentTaxMny;
    @TableField(value="equipment_mny")
    private BigDecimal equipmentMny;
    @TableField(value="equipment_tax")
    private BigDecimal equipmentTax;
    @TableField(value="other_tax_mny")
    private BigDecimal otherTaxMny;
    @TableField(value="other_mny")
    private BigDecimal otherMny;
    @TableField(value="other_tax")
    private BigDecimal otherTax;
    @TableField(value="tax_rate")
    private BigDecimal taxRate;
    @TableField(value="signed_file_id")
    private Long signedFileId; // 签章完成合同文件Id
    @TableField(value="company_code")
    private String companyCode; // 所属单位编码
    @TableField(value="project_department_code")
    private String projectDepartmentCode; // 项目部编码

    @TableField(exist=false)
    @SubEntity(serviceName="temporaryEquipmentDetailedService")
    private List<TemporaryEquipmentDetailedEntity> temporaryEquipmentDetailedList = new ArrayList<>(); // 临时设备租赁合同子表
    @TableField(exist=false)
    @SubEntity(serviceName="temporaryClauseService")
    private List<TemporaryClauseEntity> temporaryClauseList = new ArrayList<>(); // 临时租赁合同-条款
    @TableField(exist=false)
    @SubEntity(serviceName="temporaryPaymentClauseService")
    private List<TemporaryPaymentClauseEntity> temporaryPaymentClauseList = new ArrayList<>(); // 临时设备租赁合同支付条款

    @TableField(exist=false)
    @SubEntity(serviceName="temporaryOtherService")
    private List<TemporaryOtherEntity> temporaryOtherList = new ArrayList<>(); // 临时设备租赁合同其它费用

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getProjectDepartmentCode() {
        return projectDepartmentCode;
    }

    public void setProjectDepartmentCode(String projectDepartmentCode) {
        this.projectDepartmentCode = projectDepartmentCode;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public BigDecimal getEquipmentTax() {
        return equipmentTax;
    }

    public void setEquipmentTax(BigDecimal equipmentTax) {
        this.equipmentTax = equipmentTax;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public Long getCalibrationResultId() {
        return calibrationResultId;
    }

    public void setCalibrationResultId(Long calibrationResultId) {
        this.calibrationResultId = calibrationResultId;
    }
    public String getCalibrationResultName() {
        return calibrationResultName;
    }

    public void setCalibrationResultName(String calibrationResultName) {
        this.calibrationResultName = calibrationResultName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public Long getPartyId() {
        return partyId;
    }

    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }
    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }
    public Long getPartyUser() {
        return partyUser;
    }

    public void setPartyUser(Long partyUser) {
        this.partyUser = partyUser;
    }
    public String getPartyUserName() {
        return partyUserName;
    }

    public void setPartyUserName(String partyUserName) {
        this.partyUserName = partyUserName;
    }
    public Long getPartyHandleUser() {
        return partyHandleUser;
    }

    public void setPartyHandleUser(Long partyHandleUser) {
        this.partyHandleUser = partyHandleUser;
    }
    public String getPartyHandleUserName() {
        return partyHandleUserName;
    }

    public void setPartyHandleUserName(String partyHandleUserName) {
        this.partyHandleUserName = partyHandleUserName;
    }
    public Long getPartyPhone() {
        return partyPhone;
    }

    public void setPartyPhone(Long partyPhone) {
        this.partyPhone = partyPhone;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierHandleUser() {
        return supplierHandleUser;
    }

    public void setSupplierHandleUser(Long supplierHandleUser) {
        this.supplierHandleUser = supplierHandleUser;
    }
    public String getSupplierHandleUserName() {
        return supplierHandleUserName;
    }

    public void setSupplierHandleUserName(String supplierHandleUserName) {
        this.supplierHandleUserName = supplierHandleUserName;
    }
    public Long getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(Long supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }
    public Date getSignedDate() {
        return signedDate;
    }

    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }
    public String getSupplyPlace() {
        return supplyPlace;
    }

    public void setSupplyPlace(String supplyPlace) {
        this.supplyPlace = supplyPlace;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public String getContractPerformanceState() {
        return contractPerformanceState;
    }

    public void setContractPerformanceState(String contractPerformanceState) {
        this.contractPerformanceState = contractPerformanceState;
    }
    public String getContractPerformanceName() {
        return contractPerformanceName;
    }

    public void setContractPerformanceName(String contractPerformanceName) {
        this.contractPerformanceName = contractPerformanceName;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getDraftTypeName() {
        return draftTypeName;
    }

    public void setDraftTypeName(String draftTypeName) {
        this.draftTypeName = draftTypeName;
    }
    public String getContractFile() {
        return contractFile;
    }

    public void setContractFile(String contractFile) {
        this.contractFile = contractFile;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAmountTax() {
        return contractAmountTax;
    }

    public void setContractAmountTax(BigDecimal contractAmountTax) {
        this.contractAmountTax = contractAmountTax;
    }
    public Integer getContractState() {
        return contractState;
    }

    public void setContractState(Integer contractState) {
        this.contractState = contractState;
    }
    public String getSignatureState() {
        return signatureState;
    }

    public void setSignatureState(String signatureState) {
        this.signatureState = signatureState;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getAfterChangeMny() {
        return afterChangeMny;
    }

    public void setAfterChangeMny(BigDecimal afterChangeMny) {
        this.afterChangeMny = afterChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public String getChangingItem() {
        return changingItem;
    }

    public void setChangingItem(String changingItem) {
        this.changingItem = changingItem;
    }
    public BigDecimal getChangingRatio() {
        return changingRatio;
    }

    public void setChangingRatio(BigDecimal changingRatio) {
        this.changingRatio = changingRatio;
    }
    public BigDecimal getChangingTax() {
        return changingTax;
    }

    public void setChangingTax(BigDecimal changingTax) {
        this.changingTax = changingTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeFile() {
        return changeFile;
    }

    public void setChangeFile(String changeFile) {
        this.changeFile = changeFile;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public String getSupplementCode() {
        return supplementCode;
    }

    public void setSupplementCode(String supplementCode) {
        this.supplementCode = supplementCode;
    }
    public String getSupplementName() {
        return supplementName;
    }

    public void setSupplementName(String supplementName) {
        this.supplementName = supplementName;
    }
    public Integer getSupplementState() {
        return supplementState;
    }

    public void setSupplementState(Integer supplementState) {
        this.supplementState = supplementState;
    }
    public String getSupplementFile() {
        return supplementFile;
    }

    public void setSupplementFile(String supplementFile) {
        this.supplementFile = supplementFile;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public Long getSupplementHandleUser() {
        return supplementHandleUser;
    }

    public void setSupplementHandleUser(Long supplementHandleUser) {
        this.supplementHandleUser = supplementHandleUser;
    }
    public String getSupplementHandleUserName() {
        return supplementHandleUserName;
    }

    public void setSupplementHandleUserName(String supplementHandleUserName) {
        this.supplementHandleUserName = supplementHandleUserName;
    }
    

    public List<TemporaryEquipmentDetailedEntity> getTemporaryEquipmentDetailedList() {
        return temporaryEquipmentDetailedList;
    }

    public void setTemporaryEquipmentDetailedList(List<TemporaryEquipmentDetailedEntity> temporaryEquipmentDetailedList) {
        this.temporaryEquipmentDetailedList = temporaryEquipmentDetailedList;
    }

    public List<TemporaryClauseEntity> getTemporaryClauseList() {
        return temporaryClauseList;
    }

    public void setTemporaryClauseList(List<TemporaryClauseEntity> temporaryClauseList) {
        this.temporaryClauseList = temporaryClauseList;
    }

    public List<TemporaryPaymentClauseEntity> getTemporaryPaymentClauseList() {
        return temporaryPaymentClauseList;
    }

    public void setTemporaryPaymentClauseList(List<TemporaryPaymentClauseEntity> temporaryPaymentClauseList) {
        this.temporaryPaymentClauseList = temporaryPaymentClauseList;
    }

    public List<TemporaryOtherEntity> getTemporaryOtherList() {
        return temporaryOtherList;
    }

    public void setTemporaryOtherList(List<TemporaryOtherEntity> temporaryOtherList) {
        this.temporaryOtherList = temporaryOtherList;
    }

    public BigDecimal getEquipmentTaxMny() {
        return equipmentTaxMny;
    }

    public void setEquipmentTaxMny(BigDecimal equipmentTaxMny) {
        this.equipmentTaxMny = equipmentTaxMny;
    }

    public BigDecimal getEquipmentMny() {
        return equipmentMny;
    }

    public void setEquipmentMny(BigDecimal equipmentMny) {
        this.equipmentMny = equipmentMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
}
